// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDatacollectionVersionDiffCreateParams creates a new DatacollectionVersionDiffCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionVersionDiffCreateParams() *DatacollectionVersionDiffCreateParams {
	return &DatacollectionVersionDiffCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionVersionDiffCreateParamsWithTimeout creates a new DatacollectionVersionDiffCreateParams object
// with the ability to set a timeout on a request.
func NewDatacollectionVersionDiffCreateParamsWithTimeout(timeout time.Duration) *DatacollectionVersionDiffCreateParams {
	return &DatacollectionVersionDiffCreateParams{
		timeout: timeout,
	}
}

// NewDatacollectionVersionDiffCreateParamsWithContext creates a new DatacollectionVersionDiffCreateParams object
// with the ability to set a context for a request.
func NewDatacollectionVersionDiffCreateParamsWithContext(ctx context.Context) *DatacollectionVersionDiffCreateParams {
	return &DatacollectionVersionDiffCreateParams{
		Context: ctx,
	}
}

// NewDatacollectionVersionDiffCreateParamsWithHTTPClient creates a new DatacollectionVersionDiffCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionVersionDiffCreateParamsWithHTTPClient(client *http.Client) *DatacollectionVersionDiffCreateParams {
	return &DatacollectionVersionDiffCreateParams{
		HTTPClient: client,
	}
}

/*
DatacollectionVersionDiffCreateParams contains all the parameters to send to the API endpoint

	for the datacollection version diff create operation.

	Typically these are written to a http.Request.
*/
type DatacollectionVersionDiffCreateParams struct {

	/* DatacollectionUUID.

	   Unique identifier of the data collection.
	*/
	DatacollectionUUID string

	/* DatacollectionVersionUUID.

	   Unique identifier of the data collection version.
	*/
	DatacollectionVersionUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Info.

	   Data collection version diff specification.
	*/
	Info *models.DatacollectionVersionDiff

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection version diff create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionVersionDiffCreateParams) WithDefaults() *DatacollectionVersionDiffCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection version diff create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionVersionDiffCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := DatacollectionVersionDiffCreateParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) WithTimeout(timeout time.Duration) *DatacollectionVersionDiffCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) WithContext(ctx context.Context) *DatacollectionVersionDiffCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) WithHTTPClient(client *http.Client) *DatacollectionVersionDiffCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDatacollectionUUID adds the datacollectionUUID to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) WithDatacollectionUUID(datacollectionUUID string) *DatacollectionVersionDiffCreateParams {
	o.SetDatacollectionUUID(datacollectionUUID)
	return o
}

// SetDatacollectionUUID adds the datacollectionUuid to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) SetDatacollectionUUID(datacollectionUUID string) {
	o.DatacollectionUUID = datacollectionUUID
}

// WithDatacollectionVersionUUID adds the datacollectionVersionUUID to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) WithDatacollectionVersionUUID(datacollectionVersionUUID string) *DatacollectionVersionDiffCreateParams {
	o.SetDatacollectionVersionUUID(datacollectionVersionUUID)
	return o
}

// SetDatacollectionVersionUUID adds the datacollectionVersionUuid to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) SetDatacollectionVersionUUID(datacollectionVersionUUID string) {
	o.DatacollectionVersionUUID = datacollectionVersionUUID
}

// WithFields adds the fields to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) WithFields(fields []string) *DatacollectionVersionDiffCreateParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInfo adds the info to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) WithInfo(info *models.DatacollectionVersionDiff) *DatacollectionVersionDiffCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) SetInfo(info *models.DatacollectionVersionDiff) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) WithReturnRecords(returnRecords *bool) *DatacollectionVersionDiffCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) WithReturnTimeout(returnTimeout *int64) *DatacollectionVersionDiffCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionVersionDiffCreateParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection version diff create params
func (o *DatacollectionVersionDiffCreateParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionVersionDiffCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param datacollection.uuid
	if err := r.SetPathParam("datacollection.uuid", o.DatacollectionUUID); err != nil {
		return err
	}

	// path param datacollection_version.uuid
	if err := r.SetPathParam("datacollection_version.uuid", o.DatacollectionVersionUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDatacollectionVersionDiffCreate binds the parameter fields
func (o *DatacollectionVersionDiffCreateParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
