// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionVersionDiffCreateReader is a Reader for the DatacollectionVersionDiffCreate structure.
type DatacollectionVersionDiffCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionVersionDiffCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewDatacollectionVersionDiffCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDatacollectionVersionDiffCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionVersionDiffCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionVersionDiffCreateCreated creates a DatacollectionVersionDiffCreateCreated with default headers values
func NewDatacollectionVersionDiffCreateCreated() *DatacollectionVersionDiffCreateCreated {
	return &DatacollectionVersionDiffCreateCreated{}
}

/*
DatacollectionVersionDiffCreateCreated describes a response with status code 201, with default header values.

Created
*/
type DatacollectionVersionDiffCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DatacollectionVersionDiffResponse
}

// IsSuccess returns true when this datacollection version diff create created response has a 2xx status code
func (o *DatacollectionVersionDiffCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection version diff create created response has a 3xx status code
func (o *DatacollectionVersionDiffCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection version diff create created response has a 4xx status code
func (o *DatacollectionVersionDiffCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection version diff create created response has a 5xx status code
func (o *DatacollectionVersionDiffCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection version diff create created response a status code equal to that given
func (o *DatacollectionVersionDiffCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the datacollection version diff create created response
func (o *DatacollectionVersionDiffCreateCreated) Code() int {
	return 201
}

func (o *DatacollectionVersionDiffCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{datacollection_version.uuid}/diffs][%d] datacollectionVersionDiffCreateCreated %s", 201, payload)
}

func (o *DatacollectionVersionDiffCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{datacollection_version.uuid}/diffs][%d] datacollectionVersionDiffCreateCreated %s", 201, payload)
}

func (o *DatacollectionVersionDiffCreateCreated) GetPayload() *models.DatacollectionVersionDiffResponse {
	return o.Payload
}

func (o *DatacollectionVersionDiffCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DatacollectionVersionDiffResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionVersionDiffCreateAccepted creates a DatacollectionVersionDiffCreateAccepted with default headers values
func NewDatacollectionVersionDiffCreateAccepted() *DatacollectionVersionDiffCreateAccepted {
	return &DatacollectionVersionDiffCreateAccepted{}
}

/*
DatacollectionVersionDiffCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DatacollectionVersionDiffCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this datacollection version diff create accepted response has a 2xx status code
func (o *DatacollectionVersionDiffCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection version diff create accepted response has a 3xx status code
func (o *DatacollectionVersionDiffCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection version diff create accepted response has a 4xx status code
func (o *DatacollectionVersionDiffCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection version diff create accepted response has a 5xx status code
func (o *DatacollectionVersionDiffCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection version diff create accepted response a status code equal to that given
func (o *DatacollectionVersionDiffCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the datacollection version diff create accepted response
func (o *DatacollectionVersionDiffCreateAccepted) Code() int {
	return 202
}

func (o *DatacollectionVersionDiffCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{datacollection_version.uuid}/diffs][%d] datacollectionVersionDiffCreateAccepted %s", 202, payload)
}

func (o *DatacollectionVersionDiffCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{datacollection_version.uuid}/diffs][%d] datacollectionVersionDiffCreateAccepted %s", 202, payload)
}

func (o *DatacollectionVersionDiffCreateAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *DatacollectionVersionDiffCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionVersionDiffCreateDefault creates a DatacollectionVersionDiffCreateDefault with default headers values
func NewDatacollectionVersionDiffCreateDefault(code int) *DatacollectionVersionDiffCreateDefault {
	return &DatacollectionVersionDiffCreateDefault{
		_statusCode: code,
	}
}

/*
DatacollectionVersionDiffCreateDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionVersionDiffCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection version diff create default response has a 2xx status code
func (o *DatacollectionVersionDiffCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection version diff create default response has a 3xx status code
func (o *DatacollectionVersionDiffCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection version diff create default response has a 4xx status code
func (o *DatacollectionVersionDiffCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection version diff create default response has a 5xx status code
func (o *DatacollectionVersionDiffCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection version diff create default response a status code equal to that given
func (o *DatacollectionVersionDiffCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection version diff create default response
func (o *DatacollectionVersionDiffCreateDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionVersionDiffCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{datacollection_version.uuid}/diffs][%d] datacollection_version_diff_create default %s", o._statusCode, payload)
}

func (o *DatacollectionVersionDiffCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{datacollection_version.uuid}/diffs][%d] datacollection_version_diff_create default %s", o._statusCode, payload)
}

func (o *DatacollectionVersionDiffCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionVersionDiffCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
