// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDatacollectionVersionGetParams creates a new DatacollectionVersionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDatacollectionVersionGetParams() *DatacollectionVersionGetParams {
	return &DatacollectionVersionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDatacollectionVersionGetParamsWithTimeout creates a new DatacollectionVersionGetParams object
// with the ability to set a timeout on a request.
func NewDatacollectionVersionGetParamsWithTimeout(timeout time.Duration) *DatacollectionVersionGetParams {
	return &DatacollectionVersionGetParams{
		timeout: timeout,
	}
}

// NewDatacollectionVersionGetParamsWithContext creates a new DatacollectionVersionGetParams object
// with the ability to set a context for a request.
func NewDatacollectionVersionGetParamsWithContext(ctx context.Context) *DatacollectionVersionGetParams {
	return &DatacollectionVersionGetParams{
		Context: ctx,
	}
}

// NewDatacollectionVersionGetParamsWithHTTPClient creates a new DatacollectionVersionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDatacollectionVersionGetParamsWithHTTPClient(client *http.Client) *DatacollectionVersionGetParams {
	return &DatacollectionVersionGetParams{
		HTTPClient: client,
	}
}

/*
DatacollectionVersionGetParams contains all the parameters to send to the API endpoint

	for the datacollection version get operation.

	Typically these are written to a http.Request.
*/
type DatacollectionVersionGetParams struct {

	/* DatacollectionUUID.

	   Unique identifier of the data collection.
	*/
	DatacollectionUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Unique identifier of the data collection version.
	*/
	UUID string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the datacollection version get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionVersionGetParams) WithDefaults() *DatacollectionVersionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the datacollection version get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DatacollectionVersionGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the datacollection version get params
func (o *DatacollectionVersionGetParams) WithTimeout(timeout time.Duration) *DatacollectionVersionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the datacollection version get params
func (o *DatacollectionVersionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the datacollection version get params
func (o *DatacollectionVersionGetParams) WithContext(ctx context.Context) *DatacollectionVersionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the datacollection version get params
func (o *DatacollectionVersionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the datacollection version get params
func (o *DatacollectionVersionGetParams) WithHTTPClient(client *http.Client) *DatacollectionVersionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the datacollection version get params
func (o *DatacollectionVersionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDatacollectionUUID adds the datacollectionUUID to the datacollection version get params
func (o *DatacollectionVersionGetParams) WithDatacollectionUUID(datacollectionUUID string) *DatacollectionVersionGetParams {
	o.SetDatacollectionUUID(datacollectionUUID)
	return o
}

// SetDatacollectionUUID adds the datacollectionUuid to the datacollection version get params
func (o *DatacollectionVersionGetParams) SetDatacollectionUUID(datacollectionUUID string) {
	o.DatacollectionUUID = datacollectionUUID
}

// WithFields adds the fields to the datacollection version get params
func (o *DatacollectionVersionGetParams) WithFields(fields []string) *DatacollectionVersionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the datacollection version get params
func (o *DatacollectionVersionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the datacollection version get params
func (o *DatacollectionVersionGetParams) WithUUID(uuid string) *DatacollectionVersionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the datacollection version get params
func (o *DatacollectionVersionGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the datacollection version get params
func (o *DatacollectionVersionGetParams) WithWorkspaceUUID(workspaceUUID string) *DatacollectionVersionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the datacollection version get params
func (o *DatacollectionVersionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DatacollectionVersionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param datacollection.uuid
	if err := r.SetPathParam("datacollection.uuid", o.DatacollectionUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDatacollectionVersionGet binds the parameter fields
func (o *DatacollectionVersionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
