// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DatacollectionVersionGetReader is a Reader for the DatacollectionVersionGet structure.
type DatacollectionVersionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatacollectionVersionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDatacollectionVersionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDatacollectionVersionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDatacollectionVersionGetOK creates a DatacollectionVersionGetOK with default headers values
func NewDatacollectionVersionGetOK() *DatacollectionVersionGetOK {
	return &DatacollectionVersionGetOK{}
}

/*
DatacollectionVersionGetOK describes a response with status code 200, with default header values.

OK
*/
type DatacollectionVersionGetOK struct {
	Payload *models.DatacollectionVersion
}

// IsSuccess returns true when this datacollection version get o k response has a 2xx status code
func (o *DatacollectionVersionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datacollection version get o k response has a 3xx status code
func (o *DatacollectionVersionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datacollection version get o k response has a 4xx status code
func (o *DatacollectionVersionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this datacollection version get o k response has a 5xx status code
func (o *DatacollectionVersionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this datacollection version get o k response a status code equal to that given
func (o *DatacollectionVersionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the datacollection version get o k response
func (o *DatacollectionVersionGetOK) Code() int {
	return 200
}

func (o *DatacollectionVersionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{uuid}][%d] datacollectionVersionGetOK %s", 200, payload)
}

func (o *DatacollectionVersionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{uuid}][%d] datacollectionVersionGetOK %s", 200, payload)
}

func (o *DatacollectionVersionGetOK) GetPayload() *models.DatacollectionVersion {
	return o.Payload
}

func (o *DatacollectionVersionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DatacollectionVersion)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatacollectionVersionGetDefault creates a DatacollectionVersionGetDefault with default headers values
func NewDatacollectionVersionGetDefault(code int) *DatacollectionVersionGetDefault {
	return &DatacollectionVersionGetDefault{
		_statusCode: code,
	}
}

/*
DatacollectionVersionGetDefault describes a response with status code -1, with default header values.

Error
*/
type DatacollectionVersionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this datacollection version get default response has a 2xx status code
func (o *DatacollectionVersionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this datacollection version get default response has a 3xx status code
func (o *DatacollectionVersionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this datacollection version get default response has a 4xx status code
func (o *DatacollectionVersionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this datacollection version get default response has a 5xx status code
func (o *DatacollectionVersionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this datacollection version get default response a status code equal to that given
func (o *DatacollectionVersionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the datacollection version get default response
func (o *DatacollectionVersionGetDefault) Code() int {
	return o._statusCode
}

func (o *DatacollectionVersionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{uuid}][%d] datacollection_version_get default %s", o._statusCode, payload)
}

func (o *DatacollectionVersionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{uuid}][%d] datacollection_version_get default %s", o._statusCode, payload)
}

func (o *DatacollectionVersionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DatacollectionVersionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
