// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGovernanceWorkspaceAggregationsCollectionGetParams creates a new GovernanceWorkspaceAggregationsCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGovernanceWorkspaceAggregationsCollectionGetParams() *GovernanceWorkspaceAggregationsCollectionGetParams {
	return &GovernanceWorkspaceAggregationsCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGovernanceWorkspaceAggregationsCollectionGetParamsWithTimeout creates a new GovernanceWorkspaceAggregationsCollectionGetParams object
// with the ability to set a timeout on a request.
func NewGovernanceWorkspaceAggregationsCollectionGetParamsWithTimeout(timeout time.Duration) *GovernanceWorkspaceAggregationsCollectionGetParams {
	return &GovernanceWorkspaceAggregationsCollectionGetParams{
		timeout: timeout,
	}
}

// NewGovernanceWorkspaceAggregationsCollectionGetParamsWithContext creates a new GovernanceWorkspaceAggregationsCollectionGetParams object
// with the ability to set a context for a request.
func NewGovernanceWorkspaceAggregationsCollectionGetParamsWithContext(ctx context.Context) *GovernanceWorkspaceAggregationsCollectionGetParams {
	return &GovernanceWorkspaceAggregationsCollectionGetParams{
		Context: ctx,
	}
}

// NewGovernanceWorkspaceAggregationsCollectionGetParamsWithHTTPClient creates a new GovernanceWorkspaceAggregationsCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewGovernanceWorkspaceAggregationsCollectionGetParamsWithHTTPClient(client *http.Client) *GovernanceWorkspaceAggregationsCollectionGetParams {
	return &GovernanceWorkspaceAggregationsCollectionGetParams{
		HTTPClient: client,
	}
}

/*
GovernanceWorkspaceAggregationsCollectionGetParams contains all the parameters to send to the API endpoint

	for the governance workspace aggregations collection get operation.

	Typically these are written to a http.Request.
*/
type GovernanceWorkspaceAggregationsCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the governance workspace aggregations collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) WithDefaults() *GovernanceWorkspaceAggregationsCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the governance workspace aggregations collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := GovernanceWorkspaceAggregationsCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) WithTimeout(timeout time.Duration) *GovernanceWorkspaceAggregationsCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) WithContext(ctx context.Context) *GovernanceWorkspaceAggregationsCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) WithHTTPClient(client *http.Client) *GovernanceWorkspaceAggregationsCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) WithFields(fields []string) *GovernanceWorkspaceAggregationsCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) WithMaxRecords(maxRecords *int64) *GovernanceWorkspaceAggregationsCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) WithOrderBy(orderBy []string) *GovernanceWorkspaceAggregationsCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) WithReturnRecords(returnRecords *bool) *GovernanceWorkspaceAggregationsCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *GovernanceWorkspaceAggregationsCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the governance workspace aggregations collection get params
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGovernanceWorkspaceAggregationsCollectionGet binds the parameter fields
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamGovernanceWorkspaceAggregationsCollectionGet binds the parameter order_by
func (o *GovernanceWorkspaceAggregationsCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
