// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWorkspaceCollectionGetParams creates a new WorkspaceCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceCollectionGetParams() *WorkspaceCollectionGetParams {
	return &WorkspaceCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceCollectionGetParamsWithTimeout creates a new WorkspaceCollectionGetParams object
// with the ability to set a timeout on a request.
func NewWorkspaceCollectionGetParamsWithTimeout(timeout time.Duration) *WorkspaceCollectionGetParams {
	return &WorkspaceCollectionGetParams{
		timeout: timeout,
	}
}

// NewWorkspaceCollectionGetParamsWithContext creates a new WorkspaceCollectionGetParams object
// with the ability to set a context for a request.
func NewWorkspaceCollectionGetParamsWithContext(ctx context.Context) *WorkspaceCollectionGetParams {
	return &WorkspaceCollectionGetParams{
		Context: ctx,
	}
}

// NewWorkspaceCollectionGetParamsWithHTTPClient creates a new WorkspaceCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceCollectionGetParamsWithHTTPClient(client *http.Client) *WorkspaceCollectionGetParams {
	return &WorkspaceCollectionGetParams{
		HTTPClient: client,
	}
}

/*
WorkspaceCollectionGetParams contains all the parameters to send to the API endpoint

	for the workspace collection get operation.

	Typically these are written to a http.Request.
*/
type WorkspaceCollectionGetParams struct {

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* DataCollectionCount.

	   Filter by data_collection_count
	*/
	DataCollectionCount *int64

	/* Description.

	   Filter by description
	*/
	Description *string

	/* EntityCount.

	   Filter by entity_count
	*/
	EntityCount *int64

	/* ErrorsErrorCode.

	   Filter by errors.error.code
	*/
	ErrorsErrorCode *string

	/* ErrorsErrorMessage.

	   Filter by errors.error.message
	*/
	ErrorsErrorMessage *string

	/* ErrorsErrorTarget.

	   Filter by errors.error.target
	*/
	ErrorsErrorTarget *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LastRefreshTime.

	   Filter by last_refresh_time
	*/
	LastRefreshTime *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Message.

	   Filter by message
	*/
	Message *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Owner.

	   Filter by owner
	*/
	Owner *string

	/* PoliciesDescription.

	   Filter by policies.description
	*/
	PoliciesDescription *string

	/* PoliciesName.

	   Filter by policies.name
	*/
	PoliciesName *string

	/* PoliciesUUID.

	   Filter by policies.uuid
	*/
	PoliciesUUID *string

	/* RefreshInterval.

	   Filter by refresh_interval
	*/
	RefreshInterval *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SpaceAvailable.

	   Filter by space.available
	*/
	SpaceAvailable *int64

	/* SpaceTotal.

	   Filter by space.total
	*/
	SpaceTotal *int64

	/* SpaceUsed.

	   Filter by space.used
	*/
	SpaceUsed *int64

	/* State.

	   Filter by state
	*/
	State *string

	/* UpdateTime.

	   Filter by update_time
	*/
	UpdateTime *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VersionCurrentJobState.

	   Filter by version.current.job.state
	*/
	VersionCurrentJobState *string

	/* VersionCurrentJobUUID.

	   Filter by version.current.job.uuid
	*/
	VersionCurrentJobUUID *string

	/* VersionCurrentUUID.

	   Filter by version.current.uuid
	*/
	VersionCurrentUUID *string

	/* VersionJobState.

	   Filter by version.job.state
	*/
	VersionJobState *string

	/* VersionJobUUID.

	   Filter by version.job.uuid
	*/
	VersionJobUUID *string

	/* VersionNextJobState.

	   Filter by version.next.job.state
	*/
	VersionNextJobState *string

	/* VersionNextJobUUID.

	   Filter by version.next.job.uuid
	*/
	VersionNextJobUUID *string

	/* VersionNextUUID.

	   Filter by version.next.uuid
	*/
	VersionNextUUID *string

	/* VersionUUID.

	   Filter by version.uuid
	*/
	VersionUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceCollectionGetParams) WithDefaults() *WorkspaceCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := WorkspaceCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithTimeout(timeout time.Duration) *WorkspaceCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithContext(ctx context.Context) *WorkspaceCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithHTTPClient(client *http.Client) *WorkspaceCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCreateTime adds the createTime to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithCreateTime(createTime *string) *WorkspaceCollectionGetParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithDataCollectionCount adds the dataCollectionCount to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithDataCollectionCount(dataCollectionCount *int64) *WorkspaceCollectionGetParams {
	o.SetDataCollectionCount(dataCollectionCount)
	return o
}

// SetDataCollectionCount adds the dataCollectionCount to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetDataCollectionCount(dataCollectionCount *int64) {
	o.DataCollectionCount = dataCollectionCount
}

// WithDescription adds the description to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithDescription(description *string) *WorkspaceCollectionGetParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetDescription(description *string) {
	o.Description = description
}

// WithEntityCount adds the entityCount to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithEntityCount(entityCount *int64) *WorkspaceCollectionGetParams {
	o.SetEntityCount(entityCount)
	return o
}

// SetEntityCount adds the entityCount to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetEntityCount(entityCount *int64) {
	o.EntityCount = entityCount
}

// WithErrorsErrorCode adds the errorsErrorCode to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithErrorsErrorCode(errorsErrorCode *string) *WorkspaceCollectionGetParams {
	o.SetErrorsErrorCode(errorsErrorCode)
	return o
}

// SetErrorsErrorCode adds the errorsErrorCode to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetErrorsErrorCode(errorsErrorCode *string) {
	o.ErrorsErrorCode = errorsErrorCode
}

// WithErrorsErrorMessage adds the errorsErrorMessage to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithErrorsErrorMessage(errorsErrorMessage *string) *WorkspaceCollectionGetParams {
	o.SetErrorsErrorMessage(errorsErrorMessage)
	return o
}

// SetErrorsErrorMessage adds the errorsErrorMessage to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetErrorsErrorMessage(errorsErrorMessage *string) {
	o.ErrorsErrorMessage = errorsErrorMessage
}

// WithErrorsErrorTarget adds the errorsErrorTarget to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithErrorsErrorTarget(errorsErrorTarget *string) *WorkspaceCollectionGetParams {
	o.SetErrorsErrorTarget(errorsErrorTarget)
	return o
}

// SetErrorsErrorTarget adds the errorsErrorTarget to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetErrorsErrorTarget(errorsErrorTarget *string) {
	o.ErrorsErrorTarget = errorsErrorTarget
}

// WithFields adds the fields to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithFields(fields []string) *WorkspaceCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLastRefreshTime adds the lastRefreshTime to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithLastRefreshTime(lastRefreshTime *string) *WorkspaceCollectionGetParams {
	o.SetLastRefreshTime(lastRefreshTime)
	return o
}

// SetLastRefreshTime adds the lastRefreshTime to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetLastRefreshTime(lastRefreshTime *string) {
	o.LastRefreshTime = lastRefreshTime
}

// WithMaxRecords adds the maxRecords to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithMaxRecords(maxRecords *int64) *WorkspaceCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMessage adds the message to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithMessage(message *string) *WorkspaceCollectionGetParams {
	o.SetMessage(message)
	return o
}

// SetMessage adds the message to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetMessage(message *string) {
	o.Message = message
}

// WithName adds the name to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithName(name *string) *WorkspaceCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithOrderBy(orderBy []string) *WorkspaceCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOwner adds the owner to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithOwner(owner *string) *WorkspaceCollectionGetParams {
	o.SetOwner(owner)
	return o
}

// SetOwner adds the owner to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetOwner(owner *string) {
	o.Owner = owner
}

// WithPoliciesDescription adds the policiesDescription to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithPoliciesDescription(policiesDescription *string) *WorkspaceCollectionGetParams {
	o.SetPoliciesDescription(policiesDescription)
	return o
}

// SetPoliciesDescription adds the policiesDescription to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetPoliciesDescription(policiesDescription *string) {
	o.PoliciesDescription = policiesDescription
}

// WithPoliciesName adds the policiesName to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithPoliciesName(policiesName *string) *WorkspaceCollectionGetParams {
	o.SetPoliciesName(policiesName)
	return o
}

// SetPoliciesName adds the policiesName to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetPoliciesName(policiesName *string) {
	o.PoliciesName = policiesName
}

// WithPoliciesUUID adds the policiesUUID to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithPoliciesUUID(policiesUUID *string) *WorkspaceCollectionGetParams {
	o.SetPoliciesUUID(policiesUUID)
	return o
}

// SetPoliciesUUID adds the policiesUuid to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetPoliciesUUID(policiesUUID *string) {
	o.PoliciesUUID = policiesUUID
}

// WithRefreshInterval adds the refreshInterval to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithRefreshInterval(refreshInterval *string) *WorkspaceCollectionGetParams {
	o.SetRefreshInterval(refreshInterval)
	return o
}

// SetRefreshInterval adds the refreshInterval to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetRefreshInterval(refreshInterval *string) {
	o.RefreshInterval = refreshInterval
}

// WithReturnRecords adds the returnRecords to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithReturnRecords(returnRecords *bool) *WorkspaceCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *WorkspaceCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSpaceAvailable adds the spaceAvailable to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithSpaceAvailable(spaceAvailable *int64) *WorkspaceCollectionGetParams {
	o.SetSpaceAvailable(spaceAvailable)
	return o
}

// SetSpaceAvailable adds the spaceAvailable to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetSpaceAvailable(spaceAvailable *int64) {
	o.SpaceAvailable = spaceAvailable
}

// WithSpaceTotal adds the spaceTotal to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithSpaceTotal(spaceTotal *int64) *WorkspaceCollectionGetParams {
	o.SetSpaceTotal(spaceTotal)
	return o
}

// SetSpaceTotal adds the spaceTotal to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetSpaceTotal(spaceTotal *int64) {
	o.SpaceTotal = spaceTotal
}

// WithSpaceUsed adds the spaceUsed to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithSpaceUsed(spaceUsed *int64) *WorkspaceCollectionGetParams {
	o.SetSpaceUsed(spaceUsed)
	return o
}

// SetSpaceUsed adds the spaceUsed to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetSpaceUsed(spaceUsed *int64) {
	o.SpaceUsed = spaceUsed
}

// WithState adds the state to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithState(state *string) *WorkspaceCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithUpdateTime adds the updateTime to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithUpdateTime(updateTime *string) *WorkspaceCollectionGetParams {
	o.SetUpdateTime(updateTime)
	return o
}

// SetUpdateTime adds the updateTime to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetUpdateTime(updateTime *string) {
	o.UpdateTime = updateTime
}

// WithUUID adds the uuid to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithUUID(uuid *string) *WorkspaceCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVersionCurrentJobState adds the versionCurrentJobState to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithVersionCurrentJobState(versionCurrentJobState *string) *WorkspaceCollectionGetParams {
	o.SetVersionCurrentJobState(versionCurrentJobState)
	return o
}

// SetVersionCurrentJobState adds the versionCurrentJobState to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetVersionCurrentJobState(versionCurrentJobState *string) {
	o.VersionCurrentJobState = versionCurrentJobState
}

// WithVersionCurrentJobUUID adds the versionCurrentJobUUID to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithVersionCurrentJobUUID(versionCurrentJobUUID *string) *WorkspaceCollectionGetParams {
	o.SetVersionCurrentJobUUID(versionCurrentJobUUID)
	return o
}

// SetVersionCurrentJobUUID adds the versionCurrentJobUuid to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetVersionCurrentJobUUID(versionCurrentJobUUID *string) {
	o.VersionCurrentJobUUID = versionCurrentJobUUID
}

// WithVersionCurrentUUID adds the versionCurrentUUID to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithVersionCurrentUUID(versionCurrentUUID *string) *WorkspaceCollectionGetParams {
	o.SetVersionCurrentUUID(versionCurrentUUID)
	return o
}

// SetVersionCurrentUUID adds the versionCurrentUuid to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetVersionCurrentUUID(versionCurrentUUID *string) {
	o.VersionCurrentUUID = versionCurrentUUID
}

// WithVersionJobState adds the versionJobState to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithVersionJobState(versionJobState *string) *WorkspaceCollectionGetParams {
	o.SetVersionJobState(versionJobState)
	return o
}

// SetVersionJobState adds the versionJobState to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetVersionJobState(versionJobState *string) {
	o.VersionJobState = versionJobState
}

// WithVersionJobUUID adds the versionJobUUID to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithVersionJobUUID(versionJobUUID *string) *WorkspaceCollectionGetParams {
	o.SetVersionJobUUID(versionJobUUID)
	return o
}

// SetVersionJobUUID adds the versionJobUuid to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetVersionJobUUID(versionJobUUID *string) {
	o.VersionJobUUID = versionJobUUID
}

// WithVersionNextJobState adds the versionNextJobState to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithVersionNextJobState(versionNextJobState *string) *WorkspaceCollectionGetParams {
	o.SetVersionNextJobState(versionNextJobState)
	return o
}

// SetVersionNextJobState adds the versionNextJobState to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetVersionNextJobState(versionNextJobState *string) {
	o.VersionNextJobState = versionNextJobState
}

// WithVersionNextJobUUID adds the versionNextJobUUID to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithVersionNextJobUUID(versionNextJobUUID *string) *WorkspaceCollectionGetParams {
	o.SetVersionNextJobUUID(versionNextJobUUID)
	return o
}

// SetVersionNextJobUUID adds the versionNextJobUuid to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetVersionNextJobUUID(versionNextJobUUID *string) {
	o.VersionNextJobUUID = versionNextJobUUID
}

// WithVersionNextUUID adds the versionNextUUID to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithVersionNextUUID(versionNextUUID *string) *WorkspaceCollectionGetParams {
	o.SetVersionNextUUID(versionNextUUID)
	return o
}

// SetVersionNextUUID adds the versionNextUuid to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetVersionNextUUID(versionNextUUID *string) {
	o.VersionNextUUID = versionNextUUID
}

// WithVersionUUID adds the versionUUID to the workspace collection get params
func (o *WorkspaceCollectionGetParams) WithVersionUUID(versionUUID *string) *WorkspaceCollectionGetParams {
	o.SetVersionUUID(versionUUID)
	return o
}

// SetVersionUUID adds the versionUuid to the workspace collection get params
func (o *WorkspaceCollectionGetParams) SetVersionUUID(versionUUID *string) {
	o.VersionUUID = versionUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionCount != nil {

		// query param data_collection_count
		var qrDataCollectionCount int64

		if o.DataCollectionCount != nil {
			qrDataCollectionCount = *o.DataCollectionCount
		}
		qDataCollectionCount := swag.FormatInt64(qrDataCollectionCount)
		if qDataCollectionCount != "" {

			if err := r.SetQueryParam("data_collection_count", qDataCollectionCount); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.EntityCount != nil {

		// query param entity_count
		var qrEntityCount int64

		if o.EntityCount != nil {
			qrEntityCount = *o.EntityCount
		}
		qEntityCount := swag.FormatInt64(qrEntityCount)
		if qEntityCount != "" {

			if err := r.SetQueryParam("entity_count", qEntityCount); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorCode != nil {

		// query param errors.error.code
		var qrErrorsErrorCode string

		if o.ErrorsErrorCode != nil {
			qrErrorsErrorCode = *o.ErrorsErrorCode
		}
		qErrorsErrorCode := qrErrorsErrorCode
		if qErrorsErrorCode != "" {

			if err := r.SetQueryParam("errors.error.code", qErrorsErrorCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorMessage != nil {

		// query param errors.error.message
		var qrErrorsErrorMessage string

		if o.ErrorsErrorMessage != nil {
			qrErrorsErrorMessage = *o.ErrorsErrorMessage
		}
		qErrorsErrorMessage := qrErrorsErrorMessage
		if qErrorsErrorMessage != "" {

			if err := r.SetQueryParam("errors.error.message", qErrorsErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorTarget != nil {

		// query param errors.error.target
		var qrErrorsErrorTarget string

		if o.ErrorsErrorTarget != nil {
			qrErrorsErrorTarget = *o.ErrorsErrorTarget
		}
		qErrorsErrorTarget := qrErrorsErrorTarget
		if qErrorsErrorTarget != "" {

			if err := r.SetQueryParam("errors.error.target", qErrorsErrorTarget); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LastRefreshTime != nil {

		// query param last_refresh_time
		var qrLastRefreshTime string

		if o.LastRefreshTime != nil {
			qrLastRefreshTime = *o.LastRefreshTime
		}
		qLastRefreshTime := qrLastRefreshTime
		if qLastRefreshTime != "" {

			if err := r.SetQueryParam("last_refresh_time", qLastRefreshTime); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Message != nil {

		// query param message
		var qrMessage string

		if o.Message != nil {
			qrMessage = *o.Message
		}
		qMessage := qrMessage
		if qMessage != "" {

			if err := r.SetQueryParam("message", qMessage); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Owner != nil {

		// query param owner
		var qrOwner string

		if o.Owner != nil {
			qrOwner = *o.Owner
		}
		qOwner := qrOwner
		if qOwner != "" {

			if err := r.SetQueryParam("owner", qOwner); err != nil {
				return err
			}
		}
	}

	if o.PoliciesDescription != nil {

		// query param policies.description
		var qrPoliciesDescription string

		if o.PoliciesDescription != nil {
			qrPoliciesDescription = *o.PoliciesDescription
		}
		qPoliciesDescription := qrPoliciesDescription
		if qPoliciesDescription != "" {

			if err := r.SetQueryParam("policies.description", qPoliciesDescription); err != nil {
				return err
			}
		}
	}

	if o.PoliciesName != nil {

		// query param policies.name
		var qrPoliciesName string

		if o.PoliciesName != nil {
			qrPoliciesName = *o.PoliciesName
		}
		qPoliciesName := qrPoliciesName
		if qPoliciesName != "" {

			if err := r.SetQueryParam("policies.name", qPoliciesName); err != nil {
				return err
			}
		}
	}

	if o.PoliciesUUID != nil {

		// query param policies.uuid
		var qrPoliciesUUID string

		if o.PoliciesUUID != nil {
			qrPoliciesUUID = *o.PoliciesUUID
		}
		qPoliciesUUID := qrPoliciesUUID
		if qPoliciesUUID != "" {

			if err := r.SetQueryParam("policies.uuid", qPoliciesUUID); err != nil {
				return err
			}
		}
	}

	if o.RefreshInterval != nil {

		// query param refresh_interval
		var qrRefreshInterval string

		if o.RefreshInterval != nil {
			qrRefreshInterval = *o.RefreshInterval
		}
		qRefreshInterval := qrRefreshInterval
		if qRefreshInterval != "" {

			if err := r.SetQueryParam("refresh_interval", qRefreshInterval); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SpaceAvailable != nil {

		// query param space.available
		var qrSpaceAvailable int64

		if o.SpaceAvailable != nil {
			qrSpaceAvailable = *o.SpaceAvailable
		}
		qSpaceAvailable := swag.FormatInt64(qrSpaceAvailable)
		if qSpaceAvailable != "" {

			if err := r.SetQueryParam("space.available", qSpaceAvailable); err != nil {
				return err
			}
		}
	}

	if o.SpaceTotal != nil {

		// query param space.total
		var qrSpaceTotal int64

		if o.SpaceTotal != nil {
			qrSpaceTotal = *o.SpaceTotal
		}
		qSpaceTotal := swag.FormatInt64(qrSpaceTotal)
		if qSpaceTotal != "" {

			if err := r.SetQueryParam("space.total", qSpaceTotal); err != nil {
				return err
			}
		}
	}

	if o.SpaceUsed != nil {

		// query param space.used
		var qrSpaceUsed int64

		if o.SpaceUsed != nil {
			qrSpaceUsed = *o.SpaceUsed
		}
		qSpaceUsed := swag.FormatInt64(qrSpaceUsed)
		if qSpaceUsed != "" {

			if err := r.SetQueryParam("space.used", qSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.UpdateTime != nil {

		// query param update_time
		var qrUpdateTime string

		if o.UpdateTime != nil {
			qrUpdateTime = *o.UpdateTime
		}
		qUpdateTime := qrUpdateTime
		if qUpdateTime != "" {

			if err := r.SetQueryParam("update_time", qUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionCurrentJobState != nil {

		// query param version.current.job.state
		var qrVersionCurrentJobState string

		if o.VersionCurrentJobState != nil {
			qrVersionCurrentJobState = *o.VersionCurrentJobState
		}
		qVersionCurrentJobState := qrVersionCurrentJobState
		if qVersionCurrentJobState != "" {

			if err := r.SetQueryParam("version.current.job.state", qVersionCurrentJobState); err != nil {
				return err
			}
		}
	}

	if o.VersionCurrentJobUUID != nil {

		// query param version.current.job.uuid
		var qrVersionCurrentJobUUID string

		if o.VersionCurrentJobUUID != nil {
			qrVersionCurrentJobUUID = *o.VersionCurrentJobUUID
		}
		qVersionCurrentJobUUID := qrVersionCurrentJobUUID
		if qVersionCurrentJobUUID != "" {

			if err := r.SetQueryParam("version.current.job.uuid", qVersionCurrentJobUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionCurrentUUID != nil {

		// query param version.current.uuid
		var qrVersionCurrentUUID string

		if o.VersionCurrentUUID != nil {
			qrVersionCurrentUUID = *o.VersionCurrentUUID
		}
		qVersionCurrentUUID := qrVersionCurrentUUID
		if qVersionCurrentUUID != "" {

			if err := r.SetQueryParam("version.current.uuid", qVersionCurrentUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionJobState != nil {

		// query param version.job.state
		var qrVersionJobState string

		if o.VersionJobState != nil {
			qrVersionJobState = *o.VersionJobState
		}
		qVersionJobState := qrVersionJobState
		if qVersionJobState != "" {

			if err := r.SetQueryParam("version.job.state", qVersionJobState); err != nil {
				return err
			}
		}
	}

	if o.VersionJobUUID != nil {

		// query param version.job.uuid
		var qrVersionJobUUID string

		if o.VersionJobUUID != nil {
			qrVersionJobUUID = *o.VersionJobUUID
		}
		qVersionJobUUID := qrVersionJobUUID
		if qVersionJobUUID != "" {

			if err := r.SetQueryParam("version.job.uuid", qVersionJobUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionNextJobState != nil {

		// query param version.next.job.state
		var qrVersionNextJobState string

		if o.VersionNextJobState != nil {
			qrVersionNextJobState = *o.VersionNextJobState
		}
		qVersionNextJobState := qrVersionNextJobState
		if qVersionNextJobState != "" {

			if err := r.SetQueryParam("version.next.job.state", qVersionNextJobState); err != nil {
				return err
			}
		}
	}

	if o.VersionNextJobUUID != nil {

		// query param version.next.job.uuid
		var qrVersionNextJobUUID string

		if o.VersionNextJobUUID != nil {
			qrVersionNextJobUUID = *o.VersionNextJobUUID
		}
		qVersionNextJobUUID := qrVersionNextJobUUID
		if qVersionNextJobUUID != "" {

			if err := r.SetQueryParam("version.next.job.uuid", qVersionNextJobUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionNextUUID != nil {

		// query param version.next.uuid
		var qrVersionNextUUID string

		if o.VersionNextUUID != nil {
			qrVersionNextUUID = *o.VersionNextUUID
		}
		qVersionNextUUID := qrVersionNextUUID
		if qVersionNextUUID != "" {

			if err := r.SetQueryParam("version.next.uuid", qVersionNextUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionUUID != nil {

		// query param version.uuid
		var qrVersionUUID string

		if o.VersionUUID != nil {
			qrVersionUUID = *o.VersionUUID
		}
		qVersionUUID := qrVersionUUID
		if qVersionUUID != "" {

			if err := r.SetQueryParam("version.uuid", qVersionUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWorkspaceCollectionGet binds the parameter fields
func (o *WorkspaceCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamWorkspaceCollectionGet binds the parameter order_by
func (o *WorkspaceCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
