// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceCollectionGetReader is a Reader for the WorkspaceCollectionGet structure.
type WorkspaceCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceCollectionGetOK creates a WorkspaceCollectionGetOK with default headers values
func NewWorkspaceCollectionGetOK() *WorkspaceCollectionGetOK {
	return &WorkspaceCollectionGetOK{}
}

/*
WorkspaceCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceCollectionGetOK struct {
	Payload *models.WorkspaceResponse
}

// IsSuccess returns true when this workspace collection get o k response has a 2xx status code
func (o *WorkspaceCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace collection get o k response has a 3xx status code
func (o *WorkspaceCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace collection get o k response has a 4xx status code
func (o *WorkspaceCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace collection get o k response has a 5xx status code
func (o *WorkspaceCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace collection get o k response a status code equal to that given
func (o *WorkspaceCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace collection get o k response
func (o *WorkspaceCollectionGetOK) Code() int {
	return 200
}

func (o *WorkspaceCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces][%d] workspaceCollectionGetOK %s", 200, payload)
}

func (o *WorkspaceCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces][%d] workspaceCollectionGetOK %s", 200, payload)
}

func (o *WorkspaceCollectionGetOK) GetPayload() *models.WorkspaceResponse {
	return o.Payload
}

func (o *WorkspaceCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.WorkspaceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceCollectionGetDefault creates a WorkspaceCollectionGetDefault with default headers values
func NewWorkspaceCollectionGetDefault(code int) *WorkspaceCollectionGetDefault {
	return &WorkspaceCollectionGetDefault{
		_statusCode: code,
	}
}

/*
WorkspaceCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace collection get default response has a 2xx status code
func (o *WorkspaceCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace collection get default response has a 3xx status code
func (o *WorkspaceCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace collection get default response has a 4xx status code
func (o *WorkspaceCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace collection get default response has a 5xx status code
func (o *WorkspaceCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace collection get default response a status code equal to that given
func (o *WorkspaceCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace collection get default response
func (o *WorkspaceCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces][%d] workspace_collection_get default %s", o._statusCode, payload)
}

func (o *WorkspaceCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces][%d] workspace_collection_get default %s", o._statusCode, payload)
}

func (o *WorkspaceCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
