// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceCreateReader is a Reader for the WorkspaceCreate structure.
type WorkspaceCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewWorkspaceCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewWorkspaceCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceCreateCreated creates a WorkspaceCreateCreated with default headers values
func NewWorkspaceCreateCreated() *WorkspaceCreateCreated {
	return &WorkspaceCreateCreated{}
}

/*
WorkspaceCreateCreated describes a response with status code 201, with default header values.

Created
*/
type WorkspaceCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.WorkspaceResponse
}

// IsSuccess returns true when this workspace create created response has a 2xx status code
func (o *WorkspaceCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace create created response has a 3xx status code
func (o *WorkspaceCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace create created response has a 4xx status code
func (o *WorkspaceCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace create created response has a 5xx status code
func (o *WorkspaceCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace create created response a status code equal to that given
func (o *WorkspaceCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the workspace create created response
func (o *WorkspaceCreateCreated) Code() int {
	return 201
}

func (o *WorkspaceCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces][%d] workspaceCreateCreated %s", 201, payload)
}

func (o *WorkspaceCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces][%d] workspaceCreateCreated %s", 201, payload)
}

func (o *WorkspaceCreateCreated) GetPayload() *models.WorkspaceResponse {
	return o.Payload
}

func (o *WorkspaceCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.WorkspaceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceCreateAccepted creates a WorkspaceCreateAccepted with default headers values
func NewWorkspaceCreateAccepted() *WorkspaceCreateAccepted {
	return &WorkspaceCreateAccepted{}
}

/*
WorkspaceCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type WorkspaceCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this workspace create accepted response has a 2xx status code
func (o *WorkspaceCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace create accepted response has a 3xx status code
func (o *WorkspaceCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace create accepted response has a 4xx status code
func (o *WorkspaceCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace create accepted response has a 5xx status code
func (o *WorkspaceCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace create accepted response a status code equal to that given
func (o *WorkspaceCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the workspace create accepted response
func (o *WorkspaceCreateAccepted) Code() int {
	return 202
}

func (o *WorkspaceCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces][%d] workspaceCreateAccepted %s", 202, payload)
}

func (o *WorkspaceCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces][%d] workspaceCreateAccepted %s", 202, payload)
}

func (o *WorkspaceCreateAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *WorkspaceCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceCreateDefault creates a WorkspaceCreateDefault with default headers values
func NewWorkspaceCreateDefault(code int) *WorkspaceCreateDefault {
	return &WorkspaceCreateDefault{
		_statusCode: code,
	}
}

/*
WorkspaceCreateDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace create default response has a 2xx status code
func (o *WorkspaceCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace create default response has a 3xx status code
func (o *WorkspaceCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace create default response has a 4xx status code
func (o *WorkspaceCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace create default response has a 5xx status code
func (o *WorkspaceCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace create default response a status code equal to that given
func (o *WorkspaceCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace create default response
func (o *WorkspaceCreateDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces][%d] workspace_create default %s", o._statusCode, payload)
}

func (o *WorkspaceCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces][%d] workspace_create default %s", o._statusCode, payload)
}

func (o *WorkspaceCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
