// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceDataSourceCollectionGetReader is a Reader for the WorkspaceDataSourceCollectionGet structure.
type WorkspaceDataSourceCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceDataSourceCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceDataSourceCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceDataSourceCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceDataSourceCollectionGetOK creates a WorkspaceDataSourceCollectionGetOK with default headers values
func NewWorkspaceDataSourceCollectionGetOK() *WorkspaceDataSourceCollectionGetOK {
	return &WorkspaceDataSourceCollectionGetOK{}
}

/*
WorkspaceDataSourceCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceDataSourceCollectionGetOK struct {
	Payload *models.WorkspaceDataSourceResponse
}

// IsSuccess returns true when this workspace data source collection get o k response has a 2xx status code
func (o *WorkspaceDataSourceCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace data source collection get o k response has a 3xx status code
func (o *WorkspaceDataSourceCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace data source collection get o k response has a 4xx status code
func (o *WorkspaceDataSourceCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace data source collection get o k response has a 5xx status code
func (o *WorkspaceDataSourceCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace data source collection get o k response a status code equal to that given
func (o *WorkspaceDataSourceCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace data source collection get o k response
func (o *WorkspaceDataSourceCollectionGetOK) Code() int {
	return 200
}

func (o *WorkspaceDataSourceCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspaceDataSourceCollectionGetOK %s", 200, payload)
}

func (o *WorkspaceDataSourceCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspaceDataSourceCollectionGetOK %s", 200, payload)
}

func (o *WorkspaceDataSourceCollectionGetOK) GetPayload() *models.WorkspaceDataSourceResponse {
	return o.Payload
}

func (o *WorkspaceDataSourceCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.WorkspaceDataSourceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceDataSourceCollectionGetDefault creates a WorkspaceDataSourceCollectionGetDefault with default headers values
func NewWorkspaceDataSourceCollectionGetDefault(code int) *WorkspaceDataSourceCollectionGetDefault {
	return &WorkspaceDataSourceCollectionGetDefault{
		_statusCode: code,
	}
}

/*
WorkspaceDataSourceCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceDataSourceCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace data source collection get default response has a 2xx status code
func (o *WorkspaceDataSourceCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace data source collection get default response has a 3xx status code
func (o *WorkspaceDataSourceCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace data source collection get default response has a 4xx status code
func (o *WorkspaceDataSourceCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace data source collection get default response has a 5xx status code
func (o *WorkspaceDataSourceCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace data source collection get default response a status code equal to that given
func (o *WorkspaceDataSourceCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace data source collection get default response
func (o *WorkspaceDataSourceCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceDataSourceCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspace_data_source_collection_get default %s", o._statusCode, payload)
}

func (o *WorkspaceDataSourceCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspace_data_source_collection_get default %s", o._statusCode, payload)
}

func (o *WorkspaceDataSourceCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceDataSourceCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
