// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceDataSourceCreateReader is a Reader for the WorkspaceDataSourceCreate structure.
type WorkspaceDataSourceCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceDataSourceCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewWorkspaceDataSourceCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewWorkspaceDataSourceCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceDataSourceCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceDataSourceCreateCreated creates a WorkspaceDataSourceCreateCreated with default headers values
func NewWorkspaceDataSourceCreateCreated() *WorkspaceDataSourceCreateCreated {
	return &WorkspaceDataSourceCreateCreated{}
}

/*
WorkspaceDataSourceCreateCreated describes a response with status code 201, with default header values.

Created
*/
type WorkspaceDataSourceCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.WorkspaceDataSourceResponse
}

// IsSuccess returns true when this workspace data source create created response has a 2xx status code
func (o *WorkspaceDataSourceCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace data source create created response has a 3xx status code
func (o *WorkspaceDataSourceCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace data source create created response has a 4xx status code
func (o *WorkspaceDataSourceCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace data source create created response has a 5xx status code
func (o *WorkspaceDataSourceCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace data source create created response a status code equal to that given
func (o *WorkspaceDataSourceCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the workspace data source create created response
func (o *WorkspaceDataSourceCreateCreated) Code() int {
	return 201
}

func (o *WorkspaceDataSourceCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspaceDataSourceCreateCreated %s", 201, payload)
}

func (o *WorkspaceDataSourceCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspaceDataSourceCreateCreated %s", 201, payload)
}

func (o *WorkspaceDataSourceCreateCreated) GetPayload() *models.WorkspaceDataSourceResponse {
	return o.Payload
}

func (o *WorkspaceDataSourceCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.WorkspaceDataSourceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceDataSourceCreateAccepted creates a WorkspaceDataSourceCreateAccepted with default headers values
func NewWorkspaceDataSourceCreateAccepted() *WorkspaceDataSourceCreateAccepted {
	return &WorkspaceDataSourceCreateAccepted{}
}

/*
WorkspaceDataSourceCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type WorkspaceDataSourceCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this workspace data source create accepted response has a 2xx status code
func (o *WorkspaceDataSourceCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace data source create accepted response has a 3xx status code
func (o *WorkspaceDataSourceCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace data source create accepted response has a 4xx status code
func (o *WorkspaceDataSourceCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace data source create accepted response has a 5xx status code
func (o *WorkspaceDataSourceCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace data source create accepted response a status code equal to that given
func (o *WorkspaceDataSourceCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the workspace data source create accepted response
func (o *WorkspaceDataSourceCreateAccepted) Code() int {
	return 202
}

func (o *WorkspaceDataSourceCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspaceDataSourceCreateAccepted %s", 202, payload)
}

func (o *WorkspaceDataSourceCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspaceDataSourceCreateAccepted %s", 202, payload)
}

func (o *WorkspaceDataSourceCreateAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *WorkspaceDataSourceCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceDataSourceCreateDefault creates a WorkspaceDataSourceCreateDefault with default headers values
func NewWorkspaceDataSourceCreateDefault(code int) *WorkspaceDataSourceCreateDefault {
	return &WorkspaceDataSourceCreateDefault{
		_statusCode: code,
	}
}

/*
WorkspaceDataSourceCreateDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceDataSourceCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace data source create default response has a 2xx status code
func (o *WorkspaceDataSourceCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace data source create default response has a 3xx status code
func (o *WorkspaceDataSourceCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace data source create default response has a 4xx status code
func (o *WorkspaceDataSourceCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace data source create default response has a 5xx status code
func (o *WorkspaceDataSourceCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace data source create default response a status code equal to that given
func (o *WorkspaceDataSourceCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace data source create default response
func (o *WorkspaceDataSourceCreateDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceDataSourceCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspace_data_source_create default %s", o._statusCode, payload)
}

func (o *WorkspaceDataSourceCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspace_data_source_create default %s", o._statusCode, payload)
}

func (o *WorkspaceDataSourceCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceDataSourceCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
