// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWorkspaceDataSourceDeleteCollectionParams creates a new WorkspaceDataSourceDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceDataSourceDeleteCollectionParams() *WorkspaceDataSourceDeleteCollectionParams {
	return &WorkspaceDataSourceDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceDataSourceDeleteCollectionParamsWithTimeout creates a new WorkspaceDataSourceDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewWorkspaceDataSourceDeleteCollectionParamsWithTimeout(timeout time.Duration) *WorkspaceDataSourceDeleteCollectionParams {
	return &WorkspaceDataSourceDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewWorkspaceDataSourceDeleteCollectionParamsWithContext creates a new WorkspaceDataSourceDeleteCollectionParams object
// with the ability to set a context for a request.
func NewWorkspaceDataSourceDeleteCollectionParamsWithContext(ctx context.Context) *WorkspaceDataSourceDeleteCollectionParams {
	return &WorkspaceDataSourceDeleteCollectionParams{
		Context: ctx,
	}
}

// NewWorkspaceDataSourceDeleteCollectionParamsWithHTTPClient creates a new WorkspaceDataSourceDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceDataSourceDeleteCollectionParamsWithHTTPClient(client *http.Client) *WorkspaceDataSourceDeleteCollectionParams {
	return &WorkspaceDataSourceDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
WorkspaceDataSourceDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the workspace data source delete collection operation.

	Typically these are written to a http.Request.
*/
type WorkspaceDataSourceDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* ErrorsErrorCode.

	   Filter by errors.error.code
	*/
	ErrorsErrorCode *string

	/* ErrorsErrorMessage.

	   Filter by errors.error.message
	*/
	ErrorsErrorMessage *string

	/* ErrorsErrorTarget.

	   Filter by errors.error.target
	*/
	ErrorsErrorTarget *string

	/* Info.

	   Info specification
	*/
	Info WorkspaceDataSourceDeleteCollectionBody

	/* LastRefreshTime.

	   Filter by last_refresh_time
	*/
	LastRefreshTime *string

	/* LocalStorageName.

	   Filter by local_storage.name
	*/
	LocalStorageName *string

	/* LocalStorageSvmName.

	   Filter by local_storage.svm.name
	*/
	LocalStorageSvmName *string

	/* LocalStorageSvmUUID.

	   Filter by local_storage.svm.uuid
	*/
	LocalStorageSvmUUID *string

	/* LocalStorageUUID.

	   Filter by local_storage.uuid
	*/
	LocalStorageUUID *string

	/* Message.

	   Filter by message
	*/
	Message *string

	/* RemoteStorageClusterName.

	   Filter by remote_storage.cluster.name
	*/
	RemoteStorageClusterName *string

	/* RemoteStorageClusterUUID.

	   Filter by remote_storage.cluster.uuid
	*/
	RemoteStorageClusterUUID *string

	/* RemoteStorageName.

	   Filter by remote_storage.name
	*/
	RemoteStorageName *string

	/* RemoteStorageSvmName.

	   Filter by remote_storage.svm.name
	*/
	RemoteStorageSvmName *string

	/* RemoteStorageSvmUUID.

	   Filter by remote_storage.svm.uuid
	*/
	RemoteStorageSvmUUID *string

	/* RemoteStorageUUID.

	   Filter by remote_storage.uuid
	*/
	RemoteStorageUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SpaceAvailable.

	   Filter by space.available
	*/
	SpaceAvailable *int64

	/* SpaceTotal.

	   Filter by space.total
	*/
	SpaceTotal *int64

	/* SpaceUsed.

	   Filter by space.used
	*/
	SpaceUsed *int64

	/* State.

	   Filter by state
	*/
	State *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	/* WorkspacesName.

	   Filter by workspaces.name
	*/
	WorkspacesName *string

	/* WorkspacesUUID.

	   Filter by workspaces.uuid
	*/
	WorkspacesUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace data source delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceDataSourceDeleteCollectionParams) WithDefaults() *WorkspaceDataSourceDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace data source delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceDataSourceDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := WorkspaceDataSourceDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithTimeout(timeout time.Duration) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithContext(ctx context.Context) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithHTTPClient(client *http.Client) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithErrorsErrorCode adds the errorsErrorCode to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithErrorsErrorCode(errorsErrorCode *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetErrorsErrorCode(errorsErrorCode)
	return o
}

// SetErrorsErrorCode adds the errorsErrorCode to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetErrorsErrorCode(errorsErrorCode *string) {
	o.ErrorsErrorCode = errorsErrorCode
}

// WithErrorsErrorMessage adds the errorsErrorMessage to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithErrorsErrorMessage(errorsErrorMessage *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetErrorsErrorMessage(errorsErrorMessage)
	return o
}

// SetErrorsErrorMessage adds the errorsErrorMessage to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetErrorsErrorMessage(errorsErrorMessage *string) {
	o.ErrorsErrorMessage = errorsErrorMessage
}

// WithErrorsErrorTarget adds the errorsErrorTarget to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithErrorsErrorTarget(errorsErrorTarget *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetErrorsErrorTarget(errorsErrorTarget)
	return o
}

// SetErrorsErrorTarget adds the errorsErrorTarget to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetErrorsErrorTarget(errorsErrorTarget *string) {
	o.ErrorsErrorTarget = errorsErrorTarget
}

// WithInfo adds the info to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithInfo(info WorkspaceDataSourceDeleteCollectionBody) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetInfo(info WorkspaceDataSourceDeleteCollectionBody) {
	o.Info = info
}

// WithLastRefreshTime adds the lastRefreshTime to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithLastRefreshTime(lastRefreshTime *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetLastRefreshTime(lastRefreshTime)
	return o
}

// SetLastRefreshTime adds the lastRefreshTime to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetLastRefreshTime(lastRefreshTime *string) {
	o.LastRefreshTime = lastRefreshTime
}

// WithLocalStorageName adds the localStorageName to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithLocalStorageName(localStorageName *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetLocalStorageName(localStorageName)
	return o
}

// SetLocalStorageName adds the localStorageName to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetLocalStorageName(localStorageName *string) {
	o.LocalStorageName = localStorageName
}

// WithLocalStorageSvmName adds the localStorageSvmName to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithLocalStorageSvmName(localStorageSvmName *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetLocalStorageSvmName(localStorageSvmName)
	return o
}

// SetLocalStorageSvmName adds the localStorageSvmName to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetLocalStorageSvmName(localStorageSvmName *string) {
	o.LocalStorageSvmName = localStorageSvmName
}

// WithLocalStorageSvmUUID adds the localStorageSvmUUID to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithLocalStorageSvmUUID(localStorageSvmUUID *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetLocalStorageSvmUUID(localStorageSvmUUID)
	return o
}

// SetLocalStorageSvmUUID adds the localStorageSvmUuid to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetLocalStorageSvmUUID(localStorageSvmUUID *string) {
	o.LocalStorageSvmUUID = localStorageSvmUUID
}

// WithLocalStorageUUID adds the localStorageUUID to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithLocalStorageUUID(localStorageUUID *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetLocalStorageUUID(localStorageUUID)
	return o
}

// SetLocalStorageUUID adds the localStorageUuid to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetLocalStorageUUID(localStorageUUID *string) {
	o.LocalStorageUUID = localStorageUUID
}

// WithMessage adds the message to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithMessage(message *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetMessage(message)
	return o
}

// SetMessage adds the message to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetMessage(message *string) {
	o.Message = message
}

// WithRemoteStorageClusterName adds the remoteStorageClusterName to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithRemoteStorageClusterName(remoteStorageClusterName *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetRemoteStorageClusterName(remoteStorageClusterName)
	return o
}

// SetRemoteStorageClusterName adds the remoteStorageClusterName to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetRemoteStorageClusterName(remoteStorageClusterName *string) {
	o.RemoteStorageClusterName = remoteStorageClusterName
}

// WithRemoteStorageClusterUUID adds the remoteStorageClusterUUID to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithRemoteStorageClusterUUID(remoteStorageClusterUUID *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetRemoteStorageClusterUUID(remoteStorageClusterUUID)
	return o
}

// SetRemoteStorageClusterUUID adds the remoteStorageClusterUuid to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetRemoteStorageClusterUUID(remoteStorageClusterUUID *string) {
	o.RemoteStorageClusterUUID = remoteStorageClusterUUID
}

// WithRemoteStorageName adds the remoteStorageName to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithRemoteStorageName(remoteStorageName *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetRemoteStorageName(remoteStorageName)
	return o
}

// SetRemoteStorageName adds the remoteStorageName to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetRemoteStorageName(remoteStorageName *string) {
	o.RemoteStorageName = remoteStorageName
}

// WithRemoteStorageSvmName adds the remoteStorageSvmName to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithRemoteStorageSvmName(remoteStorageSvmName *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetRemoteStorageSvmName(remoteStorageSvmName)
	return o
}

// SetRemoteStorageSvmName adds the remoteStorageSvmName to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetRemoteStorageSvmName(remoteStorageSvmName *string) {
	o.RemoteStorageSvmName = remoteStorageSvmName
}

// WithRemoteStorageSvmUUID adds the remoteStorageSvmUUID to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithRemoteStorageSvmUUID(remoteStorageSvmUUID *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetRemoteStorageSvmUUID(remoteStorageSvmUUID)
	return o
}

// SetRemoteStorageSvmUUID adds the remoteStorageSvmUuid to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetRemoteStorageSvmUUID(remoteStorageSvmUUID *string) {
	o.RemoteStorageSvmUUID = remoteStorageSvmUUID
}

// WithRemoteStorageUUID adds the remoteStorageUUID to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithRemoteStorageUUID(remoteStorageUUID *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetRemoteStorageUUID(remoteStorageUUID)
	return o
}

// SetRemoteStorageUUID adds the remoteStorageUuid to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetRemoteStorageUUID(remoteStorageUUID *string) {
	o.RemoteStorageUUID = remoteStorageUUID
}

// WithReturnRecords adds the returnRecords to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSpaceAvailable adds the spaceAvailable to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithSpaceAvailable(spaceAvailable *int64) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetSpaceAvailable(spaceAvailable)
	return o
}

// SetSpaceAvailable adds the spaceAvailable to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetSpaceAvailable(spaceAvailable *int64) {
	o.SpaceAvailable = spaceAvailable
}

// WithSpaceTotal adds the spaceTotal to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithSpaceTotal(spaceTotal *int64) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetSpaceTotal(spaceTotal)
	return o
}

// SetSpaceTotal adds the spaceTotal to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetSpaceTotal(spaceTotal *int64) {
	o.SpaceTotal = spaceTotal
}

// WithSpaceUsed adds the spaceUsed to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithSpaceUsed(spaceUsed *int64) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetSpaceUsed(spaceUsed)
	return o
}

// SetSpaceUsed adds the spaceUsed to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetSpaceUsed(spaceUsed *int64) {
	o.SpaceUsed = spaceUsed
}

// WithState adds the state to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithState(state *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetState(state *string) {
	o.State = state
}

// WithType adds the typeVar to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithType(typeVar *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithUUID(uuid *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithWorkspaceUUID(workspaceUUID string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WithWorkspacesName adds the workspacesName to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithWorkspacesName(workspacesName *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetWorkspacesName(workspacesName)
	return o
}

// SetWorkspacesName adds the workspacesName to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetWorkspacesName(workspacesName *string) {
	o.WorkspacesName = workspacesName
}

// WithWorkspacesUUID adds the workspacesUUID to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) WithWorkspacesUUID(workspacesUUID *string) *WorkspaceDataSourceDeleteCollectionParams {
	o.SetWorkspacesUUID(workspacesUUID)
	return o
}

// SetWorkspacesUUID adds the workspacesUuid to the workspace data source delete collection params
func (o *WorkspaceDataSourceDeleteCollectionParams) SetWorkspacesUUID(workspacesUUID *string) {
	o.WorkspacesUUID = workspacesUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceDataSourceDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorCode != nil {

		// query param errors.error.code
		var qrErrorsErrorCode string

		if o.ErrorsErrorCode != nil {
			qrErrorsErrorCode = *o.ErrorsErrorCode
		}
		qErrorsErrorCode := qrErrorsErrorCode
		if qErrorsErrorCode != "" {

			if err := r.SetQueryParam("errors.error.code", qErrorsErrorCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorMessage != nil {

		// query param errors.error.message
		var qrErrorsErrorMessage string

		if o.ErrorsErrorMessage != nil {
			qrErrorsErrorMessage = *o.ErrorsErrorMessage
		}
		qErrorsErrorMessage := qrErrorsErrorMessage
		if qErrorsErrorMessage != "" {

			if err := r.SetQueryParam("errors.error.message", qErrorsErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorTarget != nil {

		// query param errors.error.target
		var qrErrorsErrorTarget string

		if o.ErrorsErrorTarget != nil {
			qrErrorsErrorTarget = *o.ErrorsErrorTarget
		}
		qErrorsErrorTarget := qrErrorsErrorTarget
		if qErrorsErrorTarget != "" {

			if err := r.SetQueryParam("errors.error.target", qErrorsErrorTarget); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.LastRefreshTime != nil {

		// query param last_refresh_time
		var qrLastRefreshTime string

		if o.LastRefreshTime != nil {
			qrLastRefreshTime = *o.LastRefreshTime
		}
		qLastRefreshTime := qrLastRefreshTime
		if qLastRefreshTime != "" {

			if err := r.SetQueryParam("last_refresh_time", qLastRefreshTime); err != nil {
				return err
			}
		}
	}

	if o.LocalStorageName != nil {

		// query param local_storage.name
		var qrLocalStorageName string

		if o.LocalStorageName != nil {
			qrLocalStorageName = *o.LocalStorageName
		}
		qLocalStorageName := qrLocalStorageName
		if qLocalStorageName != "" {

			if err := r.SetQueryParam("local_storage.name", qLocalStorageName); err != nil {
				return err
			}
		}
	}

	if o.LocalStorageSvmName != nil {

		// query param local_storage.svm.name
		var qrLocalStorageSvmName string

		if o.LocalStorageSvmName != nil {
			qrLocalStorageSvmName = *o.LocalStorageSvmName
		}
		qLocalStorageSvmName := qrLocalStorageSvmName
		if qLocalStorageSvmName != "" {

			if err := r.SetQueryParam("local_storage.svm.name", qLocalStorageSvmName); err != nil {
				return err
			}
		}
	}

	if o.LocalStorageSvmUUID != nil {

		// query param local_storage.svm.uuid
		var qrLocalStorageSvmUUID string

		if o.LocalStorageSvmUUID != nil {
			qrLocalStorageSvmUUID = *o.LocalStorageSvmUUID
		}
		qLocalStorageSvmUUID := qrLocalStorageSvmUUID
		if qLocalStorageSvmUUID != "" {

			if err := r.SetQueryParam("local_storage.svm.uuid", qLocalStorageSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.LocalStorageUUID != nil {

		// query param local_storage.uuid
		var qrLocalStorageUUID string

		if o.LocalStorageUUID != nil {
			qrLocalStorageUUID = *o.LocalStorageUUID
		}
		qLocalStorageUUID := qrLocalStorageUUID
		if qLocalStorageUUID != "" {

			if err := r.SetQueryParam("local_storage.uuid", qLocalStorageUUID); err != nil {
				return err
			}
		}
	}

	if o.Message != nil {

		// query param message
		var qrMessage string

		if o.Message != nil {
			qrMessage = *o.Message
		}
		qMessage := qrMessage
		if qMessage != "" {

			if err := r.SetQueryParam("message", qMessage); err != nil {
				return err
			}
		}
	}

	if o.RemoteStorageClusterName != nil {

		// query param remote_storage.cluster.name
		var qrRemoteStorageClusterName string

		if o.RemoteStorageClusterName != nil {
			qrRemoteStorageClusterName = *o.RemoteStorageClusterName
		}
		qRemoteStorageClusterName := qrRemoteStorageClusterName
		if qRemoteStorageClusterName != "" {

			if err := r.SetQueryParam("remote_storage.cluster.name", qRemoteStorageClusterName); err != nil {
				return err
			}
		}
	}

	if o.RemoteStorageClusterUUID != nil {

		// query param remote_storage.cluster.uuid
		var qrRemoteStorageClusterUUID string

		if o.RemoteStorageClusterUUID != nil {
			qrRemoteStorageClusterUUID = *o.RemoteStorageClusterUUID
		}
		qRemoteStorageClusterUUID := qrRemoteStorageClusterUUID
		if qRemoteStorageClusterUUID != "" {

			if err := r.SetQueryParam("remote_storage.cluster.uuid", qRemoteStorageClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.RemoteStorageName != nil {

		// query param remote_storage.name
		var qrRemoteStorageName string

		if o.RemoteStorageName != nil {
			qrRemoteStorageName = *o.RemoteStorageName
		}
		qRemoteStorageName := qrRemoteStorageName
		if qRemoteStorageName != "" {

			if err := r.SetQueryParam("remote_storage.name", qRemoteStorageName); err != nil {
				return err
			}
		}
	}

	if o.RemoteStorageSvmName != nil {

		// query param remote_storage.svm.name
		var qrRemoteStorageSvmName string

		if o.RemoteStorageSvmName != nil {
			qrRemoteStorageSvmName = *o.RemoteStorageSvmName
		}
		qRemoteStorageSvmName := qrRemoteStorageSvmName
		if qRemoteStorageSvmName != "" {

			if err := r.SetQueryParam("remote_storage.svm.name", qRemoteStorageSvmName); err != nil {
				return err
			}
		}
	}

	if o.RemoteStorageSvmUUID != nil {

		// query param remote_storage.svm.uuid
		var qrRemoteStorageSvmUUID string

		if o.RemoteStorageSvmUUID != nil {
			qrRemoteStorageSvmUUID = *o.RemoteStorageSvmUUID
		}
		qRemoteStorageSvmUUID := qrRemoteStorageSvmUUID
		if qRemoteStorageSvmUUID != "" {

			if err := r.SetQueryParam("remote_storage.svm.uuid", qRemoteStorageSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.RemoteStorageUUID != nil {

		// query param remote_storage.uuid
		var qrRemoteStorageUUID string

		if o.RemoteStorageUUID != nil {
			qrRemoteStorageUUID = *o.RemoteStorageUUID
		}
		qRemoteStorageUUID := qrRemoteStorageUUID
		if qRemoteStorageUUID != "" {

			if err := r.SetQueryParam("remote_storage.uuid", qRemoteStorageUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SpaceAvailable != nil {

		// query param space.available
		var qrSpaceAvailable int64

		if o.SpaceAvailable != nil {
			qrSpaceAvailable = *o.SpaceAvailable
		}
		qSpaceAvailable := swag.FormatInt64(qrSpaceAvailable)
		if qSpaceAvailable != "" {

			if err := r.SetQueryParam("space.available", qSpaceAvailable); err != nil {
				return err
			}
		}
	}

	if o.SpaceTotal != nil {

		// query param space.total
		var qrSpaceTotal int64

		if o.SpaceTotal != nil {
			qrSpaceTotal = *o.SpaceTotal
		}
		qSpaceTotal := swag.FormatInt64(qrSpaceTotal)
		if qSpaceTotal != "" {

			if err := r.SetQueryParam("space.total", qSpaceTotal); err != nil {
				return err
			}
		}
	}

	if o.SpaceUsed != nil {

		// query param space.used
		var qrSpaceUsed int64

		if o.SpaceUsed != nil {
			qrSpaceUsed = *o.SpaceUsed
		}
		qSpaceUsed := swag.FormatInt64(qrSpaceUsed)
		if qSpaceUsed != "" {

			if err := r.SetQueryParam("space.used", qSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if o.WorkspacesName != nil {

		// query param workspaces.name
		var qrWorkspacesName string

		if o.WorkspacesName != nil {
			qrWorkspacesName = *o.WorkspacesName
		}
		qWorkspacesName := qrWorkspacesName
		if qWorkspacesName != "" {

			if err := r.SetQueryParam("workspaces.name", qWorkspacesName); err != nil {
				return err
			}
		}
	}

	if o.WorkspacesUUID != nil {

		// query param workspaces.uuid
		var qrWorkspacesUUID string

		if o.WorkspacesUUID != nil {
			qrWorkspacesUUID = *o.WorkspacesUUID
		}
		qWorkspacesUUID := qrWorkspacesUUID
		if qWorkspacesUUID != "" {

			if err := r.SetQueryParam("workspaces.uuid", qWorkspacesUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
