// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceDataSourceDeleteCollectionReader is a Reader for the WorkspaceDataSourceDeleteCollection structure.
type WorkspaceDataSourceDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceDataSourceDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceDataSourceDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewWorkspaceDataSourceDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceDataSourceDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceDataSourceDeleteCollectionOK creates a WorkspaceDataSourceDeleteCollectionOK with default headers values
func NewWorkspaceDataSourceDeleteCollectionOK() *WorkspaceDataSourceDeleteCollectionOK {
	return &WorkspaceDataSourceDeleteCollectionOK{}
}

/*
WorkspaceDataSourceDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceDataSourceDeleteCollectionOK struct {
}

// IsSuccess returns true when this workspace data source delete collection o k response has a 2xx status code
func (o *WorkspaceDataSourceDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace data source delete collection o k response has a 3xx status code
func (o *WorkspaceDataSourceDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace data source delete collection o k response has a 4xx status code
func (o *WorkspaceDataSourceDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace data source delete collection o k response has a 5xx status code
func (o *WorkspaceDataSourceDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace data source delete collection o k response a status code equal to that given
func (o *WorkspaceDataSourceDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace data source delete collection o k response
func (o *WorkspaceDataSourceDeleteCollectionOK) Code() int {
	return 200
}

func (o *WorkspaceDataSourceDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspaceDataSourceDeleteCollectionOK", 200)
}

func (o *WorkspaceDataSourceDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspaceDataSourceDeleteCollectionOK", 200)
}

func (o *WorkspaceDataSourceDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewWorkspaceDataSourceDeleteCollectionAccepted creates a WorkspaceDataSourceDeleteCollectionAccepted with default headers values
func NewWorkspaceDataSourceDeleteCollectionAccepted() *WorkspaceDataSourceDeleteCollectionAccepted {
	return &WorkspaceDataSourceDeleteCollectionAccepted{}
}

/*
WorkspaceDataSourceDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type WorkspaceDataSourceDeleteCollectionAccepted struct {
	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this workspace data source delete collection accepted response has a 2xx status code
func (o *WorkspaceDataSourceDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace data source delete collection accepted response has a 3xx status code
func (o *WorkspaceDataSourceDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace data source delete collection accepted response has a 4xx status code
func (o *WorkspaceDataSourceDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace data source delete collection accepted response has a 5xx status code
func (o *WorkspaceDataSourceDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace data source delete collection accepted response a status code equal to that given
func (o *WorkspaceDataSourceDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the workspace data source delete collection accepted response
func (o *WorkspaceDataSourceDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *WorkspaceDataSourceDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspaceDataSourceDeleteCollectionAccepted %s", 202, payload)
}

func (o *WorkspaceDataSourceDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspaceDataSourceDeleteCollectionAccepted %s", 202, payload)
}

func (o *WorkspaceDataSourceDeleteCollectionAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *WorkspaceDataSourceDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceDataSourceDeleteCollectionDefault creates a WorkspaceDataSourceDeleteCollectionDefault with default headers values
func NewWorkspaceDataSourceDeleteCollectionDefault(code int) *WorkspaceDataSourceDeleteCollectionDefault {
	return &WorkspaceDataSourceDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
WorkspaceDataSourceDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceDataSourceDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace data source delete collection default response has a 2xx status code
func (o *WorkspaceDataSourceDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace data source delete collection default response has a 3xx status code
func (o *WorkspaceDataSourceDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace data source delete collection default response has a 4xx status code
func (o *WorkspaceDataSourceDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace data source delete collection default response has a 5xx status code
func (o *WorkspaceDataSourceDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace data source delete collection default response a status code equal to that given
func (o *WorkspaceDataSourceDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace data source delete collection default response
func (o *WorkspaceDataSourceDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceDataSourceDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspace_data_source_delete_collection default %s", o._statusCode, payload)
}

func (o *WorkspaceDataSourceDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-sources][%d] workspace_data_source_delete_collection default %s", o._statusCode, payload)
}

func (o *WorkspaceDataSourceDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceDataSourceDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
WorkspaceDataSourceDeleteCollectionBody Data source collection within a workspace.
swagger:model WorkspaceDataSourceDeleteCollectionBody
*/
type WorkspaceDataSourceDeleteCollectionBody struct {

	// The total number of data sources present in a workspace.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`

	// workspace data source response inline records
	WorkspaceDataSourceResponseInlineRecords []*models.DataSource `json:"records,omitempty"`
}

// Validate validates this workspace data source delete collection body
func (o *WorkspaceDataSourceDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateWorkspaceDataSourceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceDataSourceDeleteCollectionBody) validateWorkspaceDataSourceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.WorkspaceDataSourceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.WorkspaceDataSourceResponseInlineRecords); i++ {
		if swag.IsZero(o.WorkspaceDataSourceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.WorkspaceDataSourceResponseInlineRecords[i] != nil {
			if err := o.WorkspaceDataSourceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this workspace data source delete collection body based on the context it is used
func (o *WorkspaceDataSourceDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWorkspaceDataSourceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceDataSourceDeleteCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceDataSourceDeleteCollectionBody) contextValidateWorkspaceDataSourceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.WorkspaceDataSourceResponseInlineRecords); i++ {

		if o.WorkspaceDataSourceResponseInlineRecords[i] != nil {
			if err := o.WorkspaceDataSourceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *WorkspaceDataSourceDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WorkspaceDataSourceDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res WorkspaceDataSourceDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
