// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWorkspaceDataSourceDeleteParams creates a new WorkspaceDataSourceDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceDataSourceDeleteParams() *WorkspaceDataSourceDeleteParams {
	return &WorkspaceDataSourceDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceDataSourceDeleteParamsWithTimeout creates a new WorkspaceDataSourceDeleteParams object
// with the ability to set a timeout on a request.
func NewWorkspaceDataSourceDeleteParamsWithTimeout(timeout time.Duration) *WorkspaceDataSourceDeleteParams {
	return &WorkspaceDataSourceDeleteParams{
		timeout: timeout,
	}
}

// NewWorkspaceDataSourceDeleteParamsWithContext creates a new WorkspaceDataSourceDeleteParams object
// with the ability to set a context for a request.
func NewWorkspaceDataSourceDeleteParamsWithContext(ctx context.Context) *WorkspaceDataSourceDeleteParams {
	return &WorkspaceDataSourceDeleteParams{
		Context: ctx,
	}
}

// NewWorkspaceDataSourceDeleteParamsWithHTTPClient creates a new WorkspaceDataSourceDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceDataSourceDeleteParamsWithHTTPClient(client *http.Client) *WorkspaceDataSourceDeleteParams {
	return &WorkspaceDataSourceDeleteParams{
		HTTPClient: client,
	}
}

/*
WorkspaceDataSourceDeleteParams contains all the parameters to send to the API endpoint

	for the workspace data source delete operation.

	Typically these are written to a http.Request.
*/
type WorkspaceDataSourceDeleteParams struct {

	/* UUID.

	   Unique identifier of the data source.
	*/
	UUID string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace data source delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceDataSourceDeleteParams) WithDefaults() *WorkspaceDataSourceDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace data source delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceDataSourceDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the workspace data source delete params
func (o *WorkspaceDataSourceDeleteParams) WithTimeout(timeout time.Duration) *WorkspaceDataSourceDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace data source delete params
func (o *WorkspaceDataSourceDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace data source delete params
func (o *WorkspaceDataSourceDeleteParams) WithContext(ctx context.Context) *WorkspaceDataSourceDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace data source delete params
func (o *WorkspaceDataSourceDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace data source delete params
func (o *WorkspaceDataSourceDeleteParams) WithHTTPClient(client *http.Client) *WorkspaceDataSourceDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace data source delete params
func (o *WorkspaceDataSourceDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithUUID adds the uuid to the workspace data source delete params
func (o *WorkspaceDataSourceDeleteParams) WithUUID(uuid string) *WorkspaceDataSourceDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the workspace data source delete params
func (o *WorkspaceDataSourceDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the workspace data source delete params
func (o *WorkspaceDataSourceDeleteParams) WithWorkspaceUUID(workspaceUUID string) *WorkspaceDataSourceDeleteParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the workspace data source delete params
func (o *WorkspaceDataSourceDeleteParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceDataSourceDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
