// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceDataSourceDeleteReader is a Reader for the WorkspaceDataSourceDelete structure.
type WorkspaceDataSourceDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceDataSourceDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceDataSourceDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewWorkspaceDataSourceDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceDataSourceDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceDataSourceDeleteOK creates a WorkspaceDataSourceDeleteOK with default headers values
func NewWorkspaceDataSourceDeleteOK() *WorkspaceDataSourceDeleteOK {
	return &WorkspaceDataSourceDeleteOK{}
}

/*
WorkspaceDataSourceDeleteOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceDataSourceDeleteOK struct {
}

// IsSuccess returns true when this workspace data source delete o k response has a 2xx status code
func (o *WorkspaceDataSourceDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace data source delete o k response has a 3xx status code
func (o *WorkspaceDataSourceDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace data source delete o k response has a 4xx status code
func (o *WorkspaceDataSourceDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace data source delete o k response has a 5xx status code
func (o *WorkspaceDataSourceDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace data source delete o k response a status code equal to that given
func (o *WorkspaceDataSourceDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace data source delete o k response
func (o *WorkspaceDataSourceDeleteOK) Code() int {
	return 200
}

func (o *WorkspaceDataSourceDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-sources/{uuid}][%d] workspaceDataSourceDeleteOK", 200)
}

func (o *WorkspaceDataSourceDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-sources/{uuid}][%d] workspaceDataSourceDeleteOK", 200)
}

func (o *WorkspaceDataSourceDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewWorkspaceDataSourceDeleteAccepted creates a WorkspaceDataSourceDeleteAccepted with default headers values
func NewWorkspaceDataSourceDeleteAccepted() *WorkspaceDataSourceDeleteAccepted {
	return &WorkspaceDataSourceDeleteAccepted{}
}

/*
WorkspaceDataSourceDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type WorkspaceDataSourceDeleteAccepted struct {
	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this workspace data source delete accepted response has a 2xx status code
func (o *WorkspaceDataSourceDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace data source delete accepted response has a 3xx status code
func (o *WorkspaceDataSourceDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace data source delete accepted response has a 4xx status code
func (o *WorkspaceDataSourceDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace data source delete accepted response has a 5xx status code
func (o *WorkspaceDataSourceDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace data source delete accepted response a status code equal to that given
func (o *WorkspaceDataSourceDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the workspace data source delete accepted response
func (o *WorkspaceDataSourceDeleteAccepted) Code() int {
	return 202
}

func (o *WorkspaceDataSourceDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-sources/{uuid}][%d] workspaceDataSourceDeleteAccepted %s", 202, payload)
}

func (o *WorkspaceDataSourceDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-sources/{uuid}][%d] workspaceDataSourceDeleteAccepted %s", 202, payload)
}

func (o *WorkspaceDataSourceDeleteAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *WorkspaceDataSourceDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceDataSourceDeleteDefault creates a WorkspaceDataSourceDeleteDefault with default headers values
func NewWorkspaceDataSourceDeleteDefault(code int) *WorkspaceDataSourceDeleteDefault {
	return &WorkspaceDataSourceDeleteDefault{
		_statusCode: code,
	}
}

/*
WorkspaceDataSourceDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceDataSourceDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace data source delete default response has a 2xx status code
func (o *WorkspaceDataSourceDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace data source delete default response has a 3xx status code
func (o *WorkspaceDataSourceDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace data source delete default response has a 4xx status code
func (o *WorkspaceDataSourceDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace data source delete default response has a 5xx status code
func (o *WorkspaceDataSourceDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace data source delete default response a status code equal to that given
func (o *WorkspaceDataSourceDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace data source delete default response
func (o *WorkspaceDataSourceDeleteDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceDataSourceDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-sources/{uuid}][%d] workspace_data_source_delete default %s", o._statusCode, payload)
}

func (o *WorkspaceDataSourceDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/data-sources/{uuid}][%d] workspace_data_source_delete default %s", o._statusCode, payload)
}

func (o *WorkspaceDataSourceDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceDataSourceDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
