// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWorkspaceDataSourceGetParams creates a new WorkspaceDataSourceGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceDataSourceGetParams() *WorkspaceDataSourceGetParams {
	return &WorkspaceDataSourceGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceDataSourceGetParamsWithTimeout creates a new WorkspaceDataSourceGetParams object
// with the ability to set a timeout on a request.
func NewWorkspaceDataSourceGetParamsWithTimeout(timeout time.Duration) *WorkspaceDataSourceGetParams {
	return &WorkspaceDataSourceGetParams{
		timeout: timeout,
	}
}

// NewWorkspaceDataSourceGetParamsWithContext creates a new WorkspaceDataSourceGetParams object
// with the ability to set a context for a request.
func NewWorkspaceDataSourceGetParamsWithContext(ctx context.Context) *WorkspaceDataSourceGetParams {
	return &WorkspaceDataSourceGetParams{
		Context: ctx,
	}
}

// NewWorkspaceDataSourceGetParamsWithHTTPClient creates a new WorkspaceDataSourceGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceDataSourceGetParamsWithHTTPClient(client *http.Client) *WorkspaceDataSourceGetParams {
	return &WorkspaceDataSourceGetParams{
		HTTPClient: client,
	}
}

/*
WorkspaceDataSourceGetParams contains all the parameters to send to the API endpoint

	for the workspace data source get operation.

	Typically these are written to a http.Request.
*/
type WorkspaceDataSourceGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Unique identifier of the data source.
	*/
	UUID string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace data source get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceDataSourceGetParams) WithDefaults() *WorkspaceDataSourceGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace data source get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceDataSourceGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the workspace data source get params
func (o *WorkspaceDataSourceGetParams) WithTimeout(timeout time.Duration) *WorkspaceDataSourceGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace data source get params
func (o *WorkspaceDataSourceGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace data source get params
func (o *WorkspaceDataSourceGetParams) WithContext(ctx context.Context) *WorkspaceDataSourceGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace data source get params
func (o *WorkspaceDataSourceGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace data source get params
func (o *WorkspaceDataSourceGetParams) WithHTTPClient(client *http.Client) *WorkspaceDataSourceGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace data source get params
func (o *WorkspaceDataSourceGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the workspace data source get params
func (o *WorkspaceDataSourceGetParams) WithFields(fields []string) *WorkspaceDataSourceGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the workspace data source get params
func (o *WorkspaceDataSourceGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the workspace data source get params
func (o *WorkspaceDataSourceGetParams) WithUUID(uuid string) *WorkspaceDataSourceGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the workspace data source get params
func (o *WorkspaceDataSourceGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the workspace data source get params
func (o *WorkspaceDataSourceGetParams) WithWorkspaceUUID(workspaceUUID string) *WorkspaceDataSourceGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the workspace data source get params
func (o *WorkspaceDataSourceGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceDataSourceGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWorkspaceDataSourceGet binds the parameter fields
func (o *WorkspaceDataSourceGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
