// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceDataSourceGetReader is a Reader for the WorkspaceDataSourceGet structure.
type WorkspaceDataSourceGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceDataSourceGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceDataSourceGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceDataSourceGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceDataSourceGetOK creates a WorkspaceDataSourceGetOK with default headers values
func NewWorkspaceDataSourceGetOK() *WorkspaceDataSourceGetOK {
	return &WorkspaceDataSourceGetOK{}
}

/*
WorkspaceDataSourceGetOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceDataSourceGetOK struct {
	Payload *models.WorkspaceDataSource
}

// IsSuccess returns true when this workspace data source get o k response has a 2xx status code
func (o *WorkspaceDataSourceGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace data source get o k response has a 3xx status code
func (o *WorkspaceDataSourceGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace data source get o k response has a 4xx status code
func (o *WorkspaceDataSourceGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace data source get o k response has a 5xx status code
func (o *WorkspaceDataSourceGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace data source get o k response a status code equal to that given
func (o *WorkspaceDataSourceGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace data source get o k response
func (o *WorkspaceDataSourceGetOK) Code() int {
	return 200
}

func (o *WorkspaceDataSourceGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-sources/{uuid}][%d] workspaceDataSourceGetOK %s", 200, payload)
}

func (o *WorkspaceDataSourceGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-sources/{uuid}][%d] workspaceDataSourceGetOK %s", 200, payload)
}

func (o *WorkspaceDataSourceGetOK) GetPayload() *models.WorkspaceDataSource {
	return o.Payload
}

func (o *WorkspaceDataSourceGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.WorkspaceDataSource)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceDataSourceGetDefault creates a WorkspaceDataSourceGetDefault with default headers values
func NewWorkspaceDataSourceGetDefault(code int) *WorkspaceDataSourceGetDefault {
	return &WorkspaceDataSourceGetDefault{
		_statusCode: code,
	}
}

/*
	WorkspaceDataSourceGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4 | The data source does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type WorkspaceDataSourceGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace data source get default response has a 2xx status code
func (o *WorkspaceDataSourceGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace data source get default response has a 3xx status code
func (o *WorkspaceDataSourceGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace data source get default response has a 4xx status code
func (o *WorkspaceDataSourceGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace data source get default response has a 5xx status code
func (o *WorkspaceDataSourceGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace data source get default response a status code equal to that given
func (o *WorkspaceDataSourceGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace data source get default response
func (o *WorkspaceDataSourceGetDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceDataSourceGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-sources/{uuid}][%d] workspace_data_source_get default %s", o._statusCode, payload)
}

func (o *WorkspaceDataSourceGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/data-sources/{uuid}][%d] workspace_data_source_get default %s", o._statusCode, payload)
}

func (o *WorkspaceDataSourceGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceDataSourceGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
