// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceDeleteCollectionReader is a Reader for the WorkspaceDeleteCollection structure.
type WorkspaceDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewWorkspaceDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceDeleteCollectionOK creates a WorkspaceDeleteCollectionOK with default headers values
func NewWorkspaceDeleteCollectionOK() *WorkspaceDeleteCollectionOK {
	return &WorkspaceDeleteCollectionOK{}
}

/*
WorkspaceDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceDeleteCollectionOK struct {
}

// IsSuccess returns true when this workspace delete collection o k response has a 2xx status code
func (o *WorkspaceDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace delete collection o k response has a 3xx status code
func (o *WorkspaceDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace delete collection o k response has a 4xx status code
func (o *WorkspaceDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace delete collection o k response has a 5xx status code
func (o *WorkspaceDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace delete collection o k response a status code equal to that given
func (o *WorkspaceDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace delete collection o k response
func (o *WorkspaceDeleteCollectionOK) Code() int {
	return 200
}

func (o *WorkspaceDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces][%d] workspaceDeleteCollectionOK", 200)
}

func (o *WorkspaceDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces][%d] workspaceDeleteCollectionOK", 200)
}

func (o *WorkspaceDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewWorkspaceDeleteCollectionAccepted creates a WorkspaceDeleteCollectionAccepted with default headers values
func NewWorkspaceDeleteCollectionAccepted() *WorkspaceDeleteCollectionAccepted {
	return &WorkspaceDeleteCollectionAccepted{}
}

/*
WorkspaceDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type WorkspaceDeleteCollectionAccepted struct {
	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this workspace delete collection accepted response has a 2xx status code
func (o *WorkspaceDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace delete collection accepted response has a 3xx status code
func (o *WorkspaceDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace delete collection accepted response has a 4xx status code
func (o *WorkspaceDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace delete collection accepted response has a 5xx status code
func (o *WorkspaceDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace delete collection accepted response a status code equal to that given
func (o *WorkspaceDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the workspace delete collection accepted response
func (o *WorkspaceDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *WorkspaceDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces][%d] workspaceDeleteCollectionAccepted %s", 202, payload)
}

func (o *WorkspaceDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces][%d] workspaceDeleteCollectionAccepted %s", 202, payload)
}

func (o *WorkspaceDeleteCollectionAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *WorkspaceDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceDeleteCollectionDefault creates a WorkspaceDeleteCollectionDefault with default headers values
func NewWorkspaceDeleteCollectionDefault(code int) *WorkspaceDeleteCollectionDefault {
	return &WorkspaceDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
WorkspaceDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace delete collection default response has a 2xx status code
func (o *WorkspaceDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace delete collection default response has a 3xx status code
func (o *WorkspaceDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace delete collection default response has a 4xx status code
func (o *WorkspaceDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace delete collection default response has a 5xx status code
func (o *WorkspaceDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace delete collection default response a status code equal to that given
func (o *WorkspaceDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace delete collection default response
func (o *WorkspaceDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces][%d] workspace_delete_collection default %s", o._statusCode, payload)
}

func (o *WorkspaceDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces][%d] workspace_delete_collection default %s", o._statusCode, payload)
}

func (o *WorkspaceDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
WorkspaceDeleteCollectionBody workspace delete collection body
swagger:model WorkspaceDeleteCollectionBody
*/
type WorkspaceDeleteCollectionBody struct {

	// The total number of workspaces present in the cluster.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`

	// workspace response inline records
	WorkspaceResponseInlineRecords []*models.Workspace `json:"records,omitempty"`
}

// Validate validates this workspace delete collection body
func (o *WorkspaceDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateWorkspaceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceDeleteCollectionBody) validateWorkspaceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.WorkspaceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.WorkspaceResponseInlineRecords); i++ {
		if swag.IsZero(o.WorkspaceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.WorkspaceResponseInlineRecords[i] != nil {
			if err := o.WorkspaceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this workspace delete collection body based on the context it is used
func (o *WorkspaceDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWorkspaceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceDeleteCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceDeleteCollectionBody) contextValidateWorkspaceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.WorkspaceResponseInlineRecords); i++ {

		if o.WorkspaceResponseInlineRecords[i] != nil {
			if err := o.WorkspaceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *WorkspaceDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WorkspaceDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res WorkspaceDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
