// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWorkspaceDeleteParams creates a new WorkspaceDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceDeleteParams() *WorkspaceDeleteParams {
	return &WorkspaceDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceDeleteParamsWithTimeout creates a new WorkspaceDeleteParams object
// with the ability to set a timeout on a request.
func NewWorkspaceDeleteParamsWithTimeout(timeout time.Duration) *WorkspaceDeleteParams {
	return &WorkspaceDeleteParams{
		timeout: timeout,
	}
}

// NewWorkspaceDeleteParamsWithContext creates a new WorkspaceDeleteParams object
// with the ability to set a context for a request.
func NewWorkspaceDeleteParamsWithContext(ctx context.Context) *WorkspaceDeleteParams {
	return &WorkspaceDeleteParams{
		Context: ctx,
	}
}

// NewWorkspaceDeleteParamsWithHTTPClient creates a new WorkspaceDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceDeleteParamsWithHTTPClient(client *http.Client) *WorkspaceDeleteParams {
	return &WorkspaceDeleteParams{
		HTTPClient: client,
	}
}

/*
WorkspaceDeleteParams contains all the parameters to send to the API endpoint

	for the workspace delete operation.

	Typically these are written to a http.Request.
*/
type WorkspaceDeleteParams struct {

	/* DeleteDataCollections.

	     - If `true`, deletes the workspace and all its associated data collections.
	- If `false`, deletes the workspace if it doesn't have any data collections, otherwise, an error is returned.

	*/
	DeleteDataCollections *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   Unique identifier of the workspace.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceDeleteParams) WithDefaults() *WorkspaceDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceDeleteParams) SetDefaults() {
	var (
		deleteDataCollectionsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := WorkspaceDeleteParams{
		DeleteDataCollections: &deleteDataCollectionsDefault,
		ReturnTimeout:         &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the workspace delete params
func (o *WorkspaceDeleteParams) WithTimeout(timeout time.Duration) *WorkspaceDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace delete params
func (o *WorkspaceDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace delete params
func (o *WorkspaceDeleteParams) WithContext(ctx context.Context) *WorkspaceDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace delete params
func (o *WorkspaceDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace delete params
func (o *WorkspaceDeleteParams) WithHTTPClient(client *http.Client) *WorkspaceDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace delete params
func (o *WorkspaceDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDeleteDataCollections adds the deleteDataCollections to the workspace delete params
func (o *WorkspaceDeleteParams) WithDeleteDataCollections(deleteDataCollections *bool) *WorkspaceDeleteParams {
	o.SetDeleteDataCollections(deleteDataCollections)
	return o
}

// SetDeleteDataCollections adds the deleteDataCollections to the workspace delete params
func (o *WorkspaceDeleteParams) SetDeleteDataCollections(deleteDataCollections *bool) {
	o.DeleteDataCollections = deleteDataCollections
}

// WithReturnTimeout adds the returnTimeout to the workspace delete params
func (o *WorkspaceDeleteParams) WithReturnTimeout(returnTimeout *int64) *WorkspaceDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the workspace delete params
func (o *WorkspaceDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the workspace delete params
func (o *WorkspaceDeleteParams) WithUUID(uuid string) *WorkspaceDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the workspace delete params
func (o *WorkspaceDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DeleteDataCollections != nil {

		// query param delete_data_collections
		var qrDeleteDataCollections bool

		if o.DeleteDataCollections != nil {
			qrDeleteDataCollections = *o.DeleteDataCollections
		}
		qDeleteDataCollections := swag.FormatBool(qrDeleteDataCollections)
		if qDeleteDataCollections != "" {

			if err := r.SetQueryParam("delete_data_collections", qDeleteDataCollections); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
