// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceDeleteReader is a Reader for the WorkspaceDelete structure.
type WorkspaceDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewWorkspaceDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceDeleteOK creates a WorkspaceDeleteOK with default headers values
func NewWorkspaceDeleteOK() *WorkspaceDeleteOK {
	return &WorkspaceDeleteOK{}
}

/*
WorkspaceDeleteOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceDeleteOK struct {
}

// IsSuccess returns true when this workspace delete o k response has a 2xx status code
func (o *WorkspaceDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace delete o k response has a 3xx status code
func (o *WorkspaceDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace delete o k response has a 4xx status code
func (o *WorkspaceDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace delete o k response has a 5xx status code
func (o *WorkspaceDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace delete o k response a status code equal to that given
func (o *WorkspaceDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace delete o k response
func (o *WorkspaceDeleteOK) Code() int {
	return 200
}

func (o *WorkspaceDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{uuid}][%d] workspaceDeleteOK", 200)
}

func (o *WorkspaceDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{uuid}][%d] workspaceDeleteOK", 200)
}

func (o *WorkspaceDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewWorkspaceDeleteAccepted creates a WorkspaceDeleteAccepted with default headers values
func NewWorkspaceDeleteAccepted() *WorkspaceDeleteAccepted {
	return &WorkspaceDeleteAccepted{}
}

/*
WorkspaceDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type WorkspaceDeleteAccepted struct {
	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this workspace delete accepted response has a 2xx status code
func (o *WorkspaceDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace delete accepted response has a 3xx status code
func (o *WorkspaceDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace delete accepted response has a 4xx status code
func (o *WorkspaceDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace delete accepted response has a 5xx status code
func (o *WorkspaceDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace delete accepted response a status code equal to that given
func (o *WorkspaceDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the workspace delete accepted response
func (o *WorkspaceDeleteAccepted) Code() int {
	return 202
}

func (o *WorkspaceDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{uuid}][%d] workspaceDeleteAccepted %s", 202, payload)
}

func (o *WorkspaceDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{uuid}][%d] workspaceDeleteAccepted %s", 202, payload)
}

func (o *WorkspaceDeleteAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *WorkspaceDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceDeleteDefault creates a WorkspaceDeleteDefault with default headers values
func NewWorkspaceDeleteDefault(code int) *WorkspaceDeleteDefault {
	return &WorkspaceDeleteDefault{
		_statusCode: code,
	}
}

/*
WorkspaceDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace delete default response has a 2xx status code
func (o *WorkspaceDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace delete default response has a 3xx status code
func (o *WorkspaceDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace delete default response has a 4xx status code
func (o *WorkspaceDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace delete default response has a 5xx status code
func (o *WorkspaceDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace delete default response a status code equal to that given
func (o *WorkspaceDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace delete default response
func (o *WorkspaceDeleteDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{uuid}][%d] workspace_delete default %s", o._statusCode, payload)
}

func (o *WorkspaceDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{uuid}][%d] workspace_delete default %s", o._statusCode, payload)
}

func (o *WorkspaceDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
