// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWorkspaceGetParams creates a new WorkspaceGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceGetParams() *WorkspaceGetParams {
	return &WorkspaceGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceGetParamsWithTimeout creates a new WorkspaceGetParams object
// with the ability to set a timeout on a request.
func NewWorkspaceGetParamsWithTimeout(timeout time.Duration) *WorkspaceGetParams {
	return &WorkspaceGetParams{
		timeout: timeout,
	}
}

// NewWorkspaceGetParamsWithContext creates a new WorkspaceGetParams object
// with the ability to set a context for a request.
func NewWorkspaceGetParamsWithContext(ctx context.Context) *WorkspaceGetParams {
	return &WorkspaceGetParams{
		Context: ctx,
	}
}

// NewWorkspaceGetParamsWithHTTPClient creates a new WorkspaceGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceGetParamsWithHTTPClient(client *http.Client) *WorkspaceGetParams {
	return &WorkspaceGetParams{
		HTTPClient: client,
	}
}

/*
WorkspaceGetParams contains all the parameters to send to the API endpoint

	for the workspace get operation.

	Typically these are written to a http.Request.
*/
type WorkspaceGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Unique identifier of the workspace.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceGetParams) WithDefaults() *WorkspaceGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the workspace get params
func (o *WorkspaceGetParams) WithTimeout(timeout time.Duration) *WorkspaceGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace get params
func (o *WorkspaceGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace get params
func (o *WorkspaceGetParams) WithContext(ctx context.Context) *WorkspaceGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace get params
func (o *WorkspaceGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace get params
func (o *WorkspaceGetParams) WithHTTPClient(client *http.Client) *WorkspaceGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace get params
func (o *WorkspaceGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the workspace get params
func (o *WorkspaceGetParams) WithFields(fields []string) *WorkspaceGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the workspace get params
func (o *WorkspaceGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the workspace get params
func (o *WorkspaceGetParams) WithUUID(uuid string) *WorkspaceGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the workspace get params
func (o *WorkspaceGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWorkspaceGet binds the parameter fields
func (o *WorkspaceGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
