// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceGetReader is a Reader for the WorkspaceGet structure.
type WorkspaceGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceGetOK creates a WorkspaceGetOK with default headers values
func NewWorkspaceGetOK() *WorkspaceGetOK {
	return &WorkspaceGetOK{}
}

/*
WorkspaceGetOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceGetOK struct {
	Payload *models.Workspace
}

// IsSuccess returns true when this workspace get o k response has a 2xx status code
func (o *WorkspaceGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace get o k response has a 3xx status code
func (o *WorkspaceGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace get o k response has a 4xx status code
func (o *WorkspaceGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace get o k response has a 5xx status code
func (o *WorkspaceGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace get o k response a status code equal to that given
func (o *WorkspaceGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace get o k response
func (o *WorkspaceGetOK) Code() int {
	return 200
}

func (o *WorkspaceGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{uuid}][%d] workspaceGetOK %s", 200, payload)
}

func (o *WorkspaceGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{uuid}][%d] workspaceGetOK %s", 200, payload)
}

func (o *WorkspaceGetOK) GetPayload() *models.Workspace {
	return o.Payload
}

func (o *WorkspaceGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Workspace)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceGetDefault creates a WorkspaceGetDefault with default headers values
func NewWorkspaceGetDefault(code int) *WorkspaceGetDefault {
	return &WorkspaceGetDefault{
		_statusCode: code,
	}
}

/*
	WorkspaceGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4 | The workspace does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type WorkspaceGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace get default response has a 2xx status code
func (o *WorkspaceGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace get default response has a 3xx status code
func (o *WorkspaceGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace get default response has a 4xx status code
func (o *WorkspaceGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace get default response has a 5xx status code
func (o *WorkspaceGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace get default response a status code equal to that given
func (o *WorkspaceGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace get default response
func (o *WorkspaceGetDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{uuid}][%d] workspace_get default %s", o._statusCode, payload)
}

func (o *WorkspaceGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{uuid}][%d] workspace_get default %s", o._statusCode, payload)
}

func (o *WorkspaceGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
