// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWorkspaceModifyCollectionParams creates a new WorkspaceModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceModifyCollectionParams() *WorkspaceModifyCollectionParams {
	return &WorkspaceModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceModifyCollectionParamsWithTimeout creates a new WorkspaceModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewWorkspaceModifyCollectionParamsWithTimeout(timeout time.Duration) *WorkspaceModifyCollectionParams {
	return &WorkspaceModifyCollectionParams{
		timeout: timeout,
	}
}

// NewWorkspaceModifyCollectionParamsWithContext creates a new WorkspaceModifyCollectionParams object
// with the ability to set a context for a request.
func NewWorkspaceModifyCollectionParamsWithContext(ctx context.Context) *WorkspaceModifyCollectionParams {
	return &WorkspaceModifyCollectionParams{
		Context: ctx,
	}
}

// NewWorkspaceModifyCollectionParamsWithHTTPClient creates a new WorkspaceModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceModifyCollectionParamsWithHTTPClient(client *http.Client) *WorkspaceModifyCollectionParams {
	return &WorkspaceModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
WorkspaceModifyCollectionParams contains all the parameters to send to the API endpoint

	for the workspace modify collection operation.

	Typically these are written to a http.Request.
*/
type WorkspaceModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* DataCollectionCount.

	   Filter by data_collection_count
	*/
	DataCollectionCount *int64

	/* Description.

	   Filter by description
	*/
	Description *string

	/* EntityCount.

	   Filter by entity_count
	*/
	EntityCount *int64

	/* ErrorsErrorCode.

	   Filter by errors.error.code
	*/
	ErrorsErrorCode *string

	/* ErrorsErrorMessage.

	   Filter by errors.error.message
	*/
	ErrorsErrorMessage *string

	/* ErrorsErrorTarget.

	   Filter by errors.error.target
	*/
	ErrorsErrorTarget *string

	/* Info.

	   Info specification
	*/
	Info WorkspaceModifyCollectionBody

	/* LastRefreshTime.

	   Filter by last_refresh_time
	*/
	LastRefreshTime *string

	/* Message.

	   Filter by message
	*/
	Message *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* Owner.

	   Filter by owner
	*/
	Owner *string

	/* PoliciesDescription.

	   Filter by policies.description
	*/
	PoliciesDescription *string

	/* PoliciesName.

	   Filter by policies.name
	*/
	PoliciesName *string

	/* PoliciesUUID.

	   Filter by policies.uuid
	*/
	PoliciesUUID *string

	/* RefreshInterval.

	   Filter by refresh_interval
	*/
	RefreshInterval *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SpaceAvailable.

	   Filter by space.available
	*/
	SpaceAvailable *int64

	/* SpaceTotal.

	   Filter by space.total
	*/
	SpaceTotal *int64

	/* SpaceUsed.

	   Filter by space.used
	*/
	SpaceUsed *int64

	/* State.

	   Filter by state
	*/
	State *string

	/* UpdateTime.

	   Filter by update_time
	*/
	UpdateTime *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VersionCurrentJobState.

	   Filter by version.current.job.state
	*/
	VersionCurrentJobState *string

	/* VersionCurrentJobUUID.

	   Filter by version.current.job.uuid
	*/
	VersionCurrentJobUUID *string

	/* VersionCurrentUUID.

	   Filter by version.current.uuid
	*/
	VersionCurrentUUID *string

	/* VersionJobState.

	   Filter by version.job.state
	*/
	VersionJobState *string

	/* VersionJobUUID.

	   Filter by version.job.uuid
	*/
	VersionJobUUID *string

	/* VersionNextJobState.

	   Filter by version.next.job.state
	*/
	VersionNextJobState *string

	/* VersionNextJobUUID.

	   Filter by version.next.job.uuid
	*/
	VersionNextJobUUID *string

	/* VersionNextUUID.

	   Filter by version.next.uuid
	*/
	VersionNextUUID *string

	/* VersionUUID.

	   Filter by version.uuid
	*/
	VersionUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceModifyCollectionParams) WithDefaults() *WorkspaceModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := WorkspaceModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithTimeout(timeout time.Duration) *WorkspaceModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithContext(ctx context.Context) *WorkspaceModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithHTTPClient(client *http.Client) *WorkspaceModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *WorkspaceModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCreateTime adds the createTime to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithCreateTime(createTime *string) *WorkspaceModifyCollectionParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithDataCollectionCount adds the dataCollectionCount to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithDataCollectionCount(dataCollectionCount *int64) *WorkspaceModifyCollectionParams {
	o.SetDataCollectionCount(dataCollectionCount)
	return o
}

// SetDataCollectionCount adds the dataCollectionCount to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetDataCollectionCount(dataCollectionCount *int64) {
	o.DataCollectionCount = dataCollectionCount
}

// WithDescription adds the description to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithDescription(description *string) *WorkspaceModifyCollectionParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetDescription(description *string) {
	o.Description = description
}

// WithEntityCount adds the entityCount to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithEntityCount(entityCount *int64) *WorkspaceModifyCollectionParams {
	o.SetEntityCount(entityCount)
	return o
}

// SetEntityCount adds the entityCount to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetEntityCount(entityCount *int64) {
	o.EntityCount = entityCount
}

// WithErrorsErrorCode adds the errorsErrorCode to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithErrorsErrorCode(errorsErrorCode *string) *WorkspaceModifyCollectionParams {
	o.SetErrorsErrorCode(errorsErrorCode)
	return o
}

// SetErrorsErrorCode adds the errorsErrorCode to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetErrorsErrorCode(errorsErrorCode *string) {
	o.ErrorsErrorCode = errorsErrorCode
}

// WithErrorsErrorMessage adds the errorsErrorMessage to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithErrorsErrorMessage(errorsErrorMessage *string) *WorkspaceModifyCollectionParams {
	o.SetErrorsErrorMessage(errorsErrorMessage)
	return o
}

// SetErrorsErrorMessage adds the errorsErrorMessage to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetErrorsErrorMessage(errorsErrorMessage *string) {
	o.ErrorsErrorMessage = errorsErrorMessage
}

// WithErrorsErrorTarget adds the errorsErrorTarget to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithErrorsErrorTarget(errorsErrorTarget *string) *WorkspaceModifyCollectionParams {
	o.SetErrorsErrorTarget(errorsErrorTarget)
	return o
}

// SetErrorsErrorTarget adds the errorsErrorTarget to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetErrorsErrorTarget(errorsErrorTarget *string) {
	o.ErrorsErrorTarget = errorsErrorTarget
}

// WithInfo adds the info to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithInfo(info WorkspaceModifyCollectionBody) *WorkspaceModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetInfo(info WorkspaceModifyCollectionBody) {
	o.Info = info
}

// WithLastRefreshTime adds the lastRefreshTime to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithLastRefreshTime(lastRefreshTime *string) *WorkspaceModifyCollectionParams {
	o.SetLastRefreshTime(lastRefreshTime)
	return o
}

// SetLastRefreshTime adds the lastRefreshTime to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetLastRefreshTime(lastRefreshTime *string) {
	o.LastRefreshTime = lastRefreshTime
}

// WithMessage adds the message to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithMessage(message *string) *WorkspaceModifyCollectionParams {
	o.SetMessage(message)
	return o
}

// SetMessage adds the message to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetMessage(message *string) {
	o.Message = message
}

// WithName adds the name to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithName(name *string) *WorkspaceModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithOwner adds the owner to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithOwner(owner *string) *WorkspaceModifyCollectionParams {
	o.SetOwner(owner)
	return o
}

// SetOwner adds the owner to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetOwner(owner *string) {
	o.Owner = owner
}

// WithPoliciesDescription adds the policiesDescription to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithPoliciesDescription(policiesDescription *string) *WorkspaceModifyCollectionParams {
	o.SetPoliciesDescription(policiesDescription)
	return o
}

// SetPoliciesDescription adds the policiesDescription to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetPoliciesDescription(policiesDescription *string) {
	o.PoliciesDescription = policiesDescription
}

// WithPoliciesName adds the policiesName to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithPoliciesName(policiesName *string) *WorkspaceModifyCollectionParams {
	o.SetPoliciesName(policiesName)
	return o
}

// SetPoliciesName adds the policiesName to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetPoliciesName(policiesName *string) {
	o.PoliciesName = policiesName
}

// WithPoliciesUUID adds the policiesUUID to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithPoliciesUUID(policiesUUID *string) *WorkspaceModifyCollectionParams {
	o.SetPoliciesUUID(policiesUUID)
	return o
}

// SetPoliciesUUID adds the policiesUuid to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetPoliciesUUID(policiesUUID *string) {
	o.PoliciesUUID = policiesUUID
}

// WithRefreshInterval adds the refreshInterval to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithRefreshInterval(refreshInterval *string) *WorkspaceModifyCollectionParams {
	o.SetRefreshInterval(refreshInterval)
	return o
}

// SetRefreshInterval adds the refreshInterval to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetRefreshInterval(refreshInterval *string) {
	o.RefreshInterval = refreshInterval
}

// WithReturnRecords adds the returnRecords to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithReturnRecords(returnRecords *bool) *WorkspaceModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *WorkspaceModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithSerialRecords(serialRecords *bool) *WorkspaceModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSpaceAvailable adds the spaceAvailable to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithSpaceAvailable(spaceAvailable *int64) *WorkspaceModifyCollectionParams {
	o.SetSpaceAvailable(spaceAvailable)
	return o
}

// SetSpaceAvailable adds the spaceAvailable to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetSpaceAvailable(spaceAvailable *int64) {
	o.SpaceAvailable = spaceAvailable
}

// WithSpaceTotal adds the spaceTotal to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithSpaceTotal(spaceTotal *int64) *WorkspaceModifyCollectionParams {
	o.SetSpaceTotal(spaceTotal)
	return o
}

// SetSpaceTotal adds the spaceTotal to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetSpaceTotal(spaceTotal *int64) {
	o.SpaceTotal = spaceTotal
}

// WithSpaceUsed adds the spaceUsed to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithSpaceUsed(spaceUsed *int64) *WorkspaceModifyCollectionParams {
	o.SetSpaceUsed(spaceUsed)
	return o
}

// SetSpaceUsed adds the spaceUsed to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetSpaceUsed(spaceUsed *int64) {
	o.SpaceUsed = spaceUsed
}

// WithState adds the state to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithState(state *string) *WorkspaceModifyCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetState(state *string) {
	o.State = state
}

// WithUpdateTime adds the updateTime to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithUpdateTime(updateTime *string) *WorkspaceModifyCollectionParams {
	o.SetUpdateTime(updateTime)
	return o
}

// SetUpdateTime adds the updateTime to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetUpdateTime(updateTime *string) {
	o.UpdateTime = updateTime
}

// WithUUID adds the uuid to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithUUID(uuid *string) *WorkspaceModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVersionCurrentJobState adds the versionCurrentJobState to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithVersionCurrentJobState(versionCurrentJobState *string) *WorkspaceModifyCollectionParams {
	o.SetVersionCurrentJobState(versionCurrentJobState)
	return o
}

// SetVersionCurrentJobState adds the versionCurrentJobState to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetVersionCurrentJobState(versionCurrentJobState *string) {
	o.VersionCurrentJobState = versionCurrentJobState
}

// WithVersionCurrentJobUUID adds the versionCurrentJobUUID to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithVersionCurrentJobUUID(versionCurrentJobUUID *string) *WorkspaceModifyCollectionParams {
	o.SetVersionCurrentJobUUID(versionCurrentJobUUID)
	return o
}

// SetVersionCurrentJobUUID adds the versionCurrentJobUuid to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetVersionCurrentJobUUID(versionCurrentJobUUID *string) {
	o.VersionCurrentJobUUID = versionCurrentJobUUID
}

// WithVersionCurrentUUID adds the versionCurrentUUID to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithVersionCurrentUUID(versionCurrentUUID *string) *WorkspaceModifyCollectionParams {
	o.SetVersionCurrentUUID(versionCurrentUUID)
	return o
}

// SetVersionCurrentUUID adds the versionCurrentUuid to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetVersionCurrentUUID(versionCurrentUUID *string) {
	o.VersionCurrentUUID = versionCurrentUUID
}

// WithVersionJobState adds the versionJobState to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithVersionJobState(versionJobState *string) *WorkspaceModifyCollectionParams {
	o.SetVersionJobState(versionJobState)
	return o
}

// SetVersionJobState adds the versionJobState to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetVersionJobState(versionJobState *string) {
	o.VersionJobState = versionJobState
}

// WithVersionJobUUID adds the versionJobUUID to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithVersionJobUUID(versionJobUUID *string) *WorkspaceModifyCollectionParams {
	o.SetVersionJobUUID(versionJobUUID)
	return o
}

// SetVersionJobUUID adds the versionJobUuid to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetVersionJobUUID(versionJobUUID *string) {
	o.VersionJobUUID = versionJobUUID
}

// WithVersionNextJobState adds the versionNextJobState to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithVersionNextJobState(versionNextJobState *string) *WorkspaceModifyCollectionParams {
	o.SetVersionNextJobState(versionNextJobState)
	return o
}

// SetVersionNextJobState adds the versionNextJobState to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetVersionNextJobState(versionNextJobState *string) {
	o.VersionNextJobState = versionNextJobState
}

// WithVersionNextJobUUID adds the versionNextJobUUID to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithVersionNextJobUUID(versionNextJobUUID *string) *WorkspaceModifyCollectionParams {
	o.SetVersionNextJobUUID(versionNextJobUUID)
	return o
}

// SetVersionNextJobUUID adds the versionNextJobUuid to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetVersionNextJobUUID(versionNextJobUUID *string) {
	o.VersionNextJobUUID = versionNextJobUUID
}

// WithVersionNextUUID adds the versionNextUUID to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithVersionNextUUID(versionNextUUID *string) *WorkspaceModifyCollectionParams {
	o.SetVersionNextUUID(versionNextUUID)
	return o
}

// SetVersionNextUUID adds the versionNextUuid to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetVersionNextUUID(versionNextUUID *string) {
	o.VersionNextUUID = versionNextUUID
}

// WithVersionUUID adds the versionUUID to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) WithVersionUUID(versionUUID *string) *WorkspaceModifyCollectionParams {
	o.SetVersionUUID(versionUUID)
	return o
}

// SetVersionUUID adds the versionUuid to the workspace modify collection params
func (o *WorkspaceModifyCollectionParams) SetVersionUUID(versionUUID *string) {
	o.VersionUUID = versionUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.DataCollectionCount != nil {

		// query param data_collection_count
		var qrDataCollectionCount int64

		if o.DataCollectionCount != nil {
			qrDataCollectionCount = *o.DataCollectionCount
		}
		qDataCollectionCount := swag.FormatInt64(qrDataCollectionCount)
		if qDataCollectionCount != "" {

			if err := r.SetQueryParam("data_collection_count", qDataCollectionCount); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.EntityCount != nil {

		// query param entity_count
		var qrEntityCount int64

		if o.EntityCount != nil {
			qrEntityCount = *o.EntityCount
		}
		qEntityCount := swag.FormatInt64(qrEntityCount)
		if qEntityCount != "" {

			if err := r.SetQueryParam("entity_count", qEntityCount); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorCode != nil {

		// query param errors.error.code
		var qrErrorsErrorCode string

		if o.ErrorsErrorCode != nil {
			qrErrorsErrorCode = *o.ErrorsErrorCode
		}
		qErrorsErrorCode := qrErrorsErrorCode
		if qErrorsErrorCode != "" {

			if err := r.SetQueryParam("errors.error.code", qErrorsErrorCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorMessage != nil {

		// query param errors.error.message
		var qrErrorsErrorMessage string

		if o.ErrorsErrorMessage != nil {
			qrErrorsErrorMessage = *o.ErrorsErrorMessage
		}
		qErrorsErrorMessage := qrErrorsErrorMessage
		if qErrorsErrorMessage != "" {

			if err := r.SetQueryParam("errors.error.message", qErrorsErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorsErrorTarget != nil {

		// query param errors.error.target
		var qrErrorsErrorTarget string

		if o.ErrorsErrorTarget != nil {
			qrErrorsErrorTarget = *o.ErrorsErrorTarget
		}
		qErrorsErrorTarget := qrErrorsErrorTarget
		if qErrorsErrorTarget != "" {

			if err := r.SetQueryParam("errors.error.target", qErrorsErrorTarget); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.LastRefreshTime != nil {

		// query param last_refresh_time
		var qrLastRefreshTime string

		if o.LastRefreshTime != nil {
			qrLastRefreshTime = *o.LastRefreshTime
		}
		qLastRefreshTime := qrLastRefreshTime
		if qLastRefreshTime != "" {

			if err := r.SetQueryParam("last_refresh_time", qLastRefreshTime); err != nil {
				return err
			}
		}
	}

	if o.Message != nil {

		// query param message
		var qrMessage string

		if o.Message != nil {
			qrMessage = *o.Message
		}
		qMessage := qrMessage
		if qMessage != "" {

			if err := r.SetQueryParam("message", qMessage); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.Owner != nil {

		// query param owner
		var qrOwner string

		if o.Owner != nil {
			qrOwner = *o.Owner
		}
		qOwner := qrOwner
		if qOwner != "" {

			if err := r.SetQueryParam("owner", qOwner); err != nil {
				return err
			}
		}
	}

	if o.PoliciesDescription != nil {

		// query param policies.description
		var qrPoliciesDescription string

		if o.PoliciesDescription != nil {
			qrPoliciesDescription = *o.PoliciesDescription
		}
		qPoliciesDescription := qrPoliciesDescription
		if qPoliciesDescription != "" {

			if err := r.SetQueryParam("policies.description", qPoliciesDescription); err != nil {
				return err
			}
		}
	}

	if o.PoliciesName != nil {

		// query param policies.name
		var qrPoliciesName string

		if o.PoliciesName != nil {
			qrPoliciesName = *o.PoliciesName
		}
		qPoliciesName := qrPoliciesName
		if qPoliciesName != "" {

			if err := r.SetQueryParam("policies.name", qPoliciesName); err != nil {
				return err
			}
		}
	}

	if o.PoliciesUUID != nil {

		// query param policies.uuid
		var qrPoliciesUUID string

		if o.PoliciesUUID != nil {
			qrPoliciesUUID = *o.PoliciesUUID
		}
		qPoliciesUUID := qrPoliciesUUID
		if qPoliciesUUID != "" {

			if err := r.SetQueryParam("policies.uuid", qPoliciesUUID); err != nil {
				return err
			}
		}
	}

	if o.RefreshInterval != nil {

		// query param refresh_interval
		var qrRefreshInterval string

		if o.RefreshInterval != nil {
			qrRefreshInterval = *o.RefreshInterval
		}
		qRefreshInterval := qrRefreshInterval
		if qRefreshInterval != "" {

			if err := r.SetQueryParam("refresh_interval", qRefreshInterval); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SpaceAvailable != nil {

		// query param space.available
		var qrSpaceAvailable int64

		if o.SpaceAvailable != nil {
			qrSpaceAvailable = *o.SpaceAvailable
		}
		qSpaceAvailable := swag.FormatInt64(qrSpaceAvailable)
		if qSpaceAvailable != "" {

			if err := r.SetQueryParam("space.available", qSpaceAvailable); err != nil {
				return err
			}
		}
	}

	if o.SpaceTotal != nil {

		// query param space.total
		var qrSpaceTotal int64

		if o.SpaceTotal != nil {
			qrSpaceTotal = *o.SpaceTotal
		}
		qSpaceTotal := swag.FormatInt64(qrSpaceTotal)
		if qSpaceTotal != "" {

			if err := r.SetQueryParam("space.total", qSpaceTotal); err != nil {
				return err
			}
		}
	}

	if o.SpaceUsed != nil {

		// query param space.used
		var qrSpaceUsed int64

		if o.SpaceUsed != nil {
			qrSpaceUsed = *o.SpaceUsed
		}
		qSpaceUsed := swag.FormatInt64(qrSpaceUsed)
		if qSpaceUsed != "" {

			if err := r.SetQueryParam("space.used", qSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.UpdateTime != nil {

		// query param update_time
		var qrUpdateTime string

		if o.UpdateTime != nil {
			qrUpdateTime = *o.UpdateTime
		}
		qUpdateTime := qrUpdateTime
		if qUpdateTime != "" {

			if err := r.SetQueryParam("update_time", qUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionCurrentJobState != nil {

		// query param version.current.job.state
		var qrVersionCurrentJobState string

		if o.VersionCurrentJobState != nil {
			qrVersionCurrentJobState = *o.VersionCurrentJobState
		}
		qVersionCurrentJobState := qrVersionCurrentJobState
		if qVersionCurrentJobState != "" {

			if err := r.SetQueryParam("version.current.job.state", qVersionCurrentJobState); err != nil {
				return err
			}
		}
	}

	if o.VersionCurrentJobUUID != nil {

		// query param version.current.job.uuid
		var qrVersionCurrentJobUUID string

		if o.VersionCurrentJobUUID != nil {
			qrVersionCurrentJobUUID = *o.VersionCurrentJobUUID
		}
		qVersionCurrentJobUUID := qrVersionCurrentJobUUID
		if qVersionCurrentJobUUID != "" {

			if err := r.SetQueryParam("version.current.job.uuid", qVersionCurrentJobUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionCurrentUUID != nil {

		// query param version.current.uuid
		var qrVersionCurrentUUID string

		if o.VersionCurrentUUID != nil {
			qrVersionCurrentUUID = *o.VersionCurrentUUID
		}
		qVersionCurrentUUID := qrVersionCurrentUUID
		if qVersionCurrentUUID != "" {

			if err := r.SetQueryParam("version.current.uuid", qVersionCurrentUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionJobState != nil {

		// query param version.job.state
		var qrVersionJobState string

		if o.VersionJobState != nil {
			qrVersionJobState = *o.VersionJobState
		}
		qVersionJobState := qrVersionJobState
		if qVersionJobState != "" {

			if err := r.SetQueryParam("version.job.state", qVersionJobState); err != nil {
				return err
			}
		}
	}

	if o.VersionJobUUID != nil {

		// query param version.job.uuid
		var qrVersionJobUUID string

		if o.VersionJobUUID != nil {
			qrVersionJobUUID = *o.VersionJobUUID
		}
		qVersionJobUUID := qrVersionJobUUID
		if qVersionJobUUID != "" {

			if err := r.SetQueryParam("version.job.uuid", qVersionJobUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionNextJobState != nil {

		// query param version.next.job.state
		var qrVersionNextJobState string

		if o.VersionNextJobState != nil {
			qrVersionNextJobState = *o.VersionNextJobState
		}
		qVersionNextJobState := qrVersionNextJobState
		if qVersionNextJobState != "" {

			if err := r.SetQueryParam("version.next.job.state", qVersionNextJobState); err != nil {
				return err
			}
		}
	}

	if o.VersionNextJobUUID != nil {

		// query param version.next.job.uuid
		var qrVersionNextJobUUID string

		if o.VersionNextJobUUID != nil {
			qrVersionNextJobUUID = *o.VersionNextJobUUID
		}
		qVersionNextJobUUID := qrVersionNextJobUUID
		if qVersionNextJobUUID != "" {

			if err := r.SetQueryParam("version.next.job.uuid", qVersionNextJobUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionNextUUID != nil {

		// query param version.next.uuid
		var qrVersionNextUUID string

		if o.VersionNextUUID != nil {
			qrVersionNextUUID = *o.VersionNextUUID
		}
		qVersionNextUUID := qrVersionNextUUID
		if qVersionNextUUID != "" {

			if err := r.SetQueryParam("version.next.uuid", qVersionNextUUID); err != nil {
				return err
			}
		}
	}

	if o.VersionUUID != nil {

		// query param version.uuid
		var qrVersionUUID string

		if o.VersionUUID != nil {
			qrVersionUUID = *o.VersionUUID
		}
		qVersionUUID := qrVersionUUID
		if qVersionUUID != "" {

			if err := r.SetQueryParam("version.uuid", qVersionUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
