// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceModifyCollectionReader is a Reader for the WorkspaceModifyCollection structure.
type WorkspaceModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewWorkspaceModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceModifyCollectionOK creates a WorkspaceModifyCollectionOK with default headers values
func NewWorkspaceModifyCollectionOK() *WorkspaceModifyCollectionOK {
	return &WorkspaceModifyCollectionOK{}
}

/*
WorkspaceModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceModifyCollectionOK struct {
}

// IsSuccess returns true when this workspace modify collection o k response has a 2xx status code
func (o *WorkspaceModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace modify collection o k response has a 3xx status code
func (o *WorkspaceModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace modify collection o k response has a 4xx status code
func (o *WorkspaceModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace modify collection o k response has a 5xx status code
func (o *WorkspaceModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace modify collection o k response a status code equal to that given
func (o *WorkspaceModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace modify collection o k response
func (o *WorkspaceModifyCollectionOK) Code() int {
	return 200
}

func (o *WorkspaceModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /data-engine/workspaces][%d] workspaceModifyCollectionOK", 200)
}

func (o *WorkspaceModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /data-engine/workspaces][%d] workspaceModifyCollectionOK", 200)
}

func (o *WorkspaceModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewWorkspaceModifyCollectionAccepted creates a WorkspaceModifyCollectionAccepted with default headers values
func NewWorkspaceModifyCollectionAccepted() *WorkspaceModifyCollectionAccepted {
	return &WorkspaceModifyCollectionAccepted{}
}

/*
WorkspaceModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type WorkspaceModifyCollectionAccepted struct {
	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this workspace modify collection accepted response has a 2xx status code
func (o *WorkspaceModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace modify collection accepted response has a 3xx status code
func (o *WorkspaceModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace modify collection accepted response has a 4xx status code
func (o *WorkspaceModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace modify collection accepted response has a 5xx status code
func (o *WorkspaceModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace modify collection accepted response a status code equal to that given
func (o *WorkspaceModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the workspace modify collection accepted response
func (o *WorkspaceModifyCollectionAccepted) Code() int {
	return 202
}

func (o *WorkspaceModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces][%d] workspaceModifyCollectionAccepted %s", 202, payload)
}

func (o *WorkspaceModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces][%d] workspaceModifyCollectionAccepted %s", 202, payload)
}

func (o *WorkspaceModifyCollectionAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *WorkspaceModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceModifyCollectionDefault creates a WorkspaceModifyCollectionDefault with default headers values
func NewWorkspaceModifyCollectionDefault(code int) *WorkspaceModifyCollectionDefault {
	return &WorkspaceModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
WorkspaceModifyCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace modify collection default response has a 2xx status code
func (o *WorkspaceModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace modify collection default response has a 3xx status code
func (o *WorkspaceModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace modify collection default response has a 4xx status code
func (o *WorkspaceModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace modify collection default response has a 5xx status code
func (o *WorkspaceModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace modify collection default response a status code equal to that given
func (o *WorkspaceModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace modify collection default response
func (o *WorkspaceModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces][%d] workspace_modify_collection default %s", o._statusCode, payload)
}

func (o *WorkspaceModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces][%d] workspace_modify_collection default %s", o._statusCode, payload)
}

func (o *WorkspaceModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
WorkspaceModifyCollectionBody workspace modify collection body
swagger:model WorkspaceModifyCollectionBody
*/
type WorkspaceModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The creation time of the workspace. This field is generated when the workspace is created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The count of data collection in a workspace.
	// Example: 20
	// Read Only: true
	DataCollectionCount *int64 `json:"data_collection_count,omitempty"`

	// Description of the workspace.
	// Example: Example workspace
	Description *string `json:"description,omitempty"`

	// The count of entities in a workspace.
	// Example: 1000
	// Read Only: true
	EntityCount *int64 `json:"entity_count,omitempty"`

	// The last refresh time of the workspace. This field is generated when the workspace is refreshed.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	LastRefreshTime *strfmt.DateTime `json:"last_refresh_time,omitempty"`

	// The message associated with the current state of the workspace.
	// Example: creating workspace
	// Read Only: true
	Message *string `json:"message,omitempty"`

	// Name for the workspace. Required for POST requests.
	// Example: Doc workspace
	Name *string `json:"name,omitempty"`

	// The owner of the workspace.
	// Example: SAL
	// Read Only: true
	Owner *string `json:"owner,omitempty"`

	// The workspace refresh time interval in ISO-8601 format. Optional in POST requests. If not supplied, this value defaults to PT1H.
	// Example: PT1H
	RefreshInterval *string `json:"refresh_interval,omitempty"`

	// space
	Space *models.WorkspaceInlineSpace `json:"space,omitempty"`

	// State of the workspace:
	// * <i>processing</i> - The workspace is being processed after creation.
	// * <i>ready</i> - The workspace is ready for use.
	// * <i>failed</i> - The workspace has a failure.
	// * <i>outdated</i> - The workspace is outdated.
	// * Valid in GET.
	//
	// Example: ready
	// Read Only: true
	// Enum: ["processing","ready","failed","outdated"]
	State *string `json:"state,omitempty"`

	// The total number of workspaces present in the cluster.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`

	// The time of update of the workspace. This field is generated when the workspace is updated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// Unique identifier for the workspace.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// version
	Version *models.WorkspaceInlineVersion `json:"version,omitempty"`

	// List of users or groups associated with the ACL.
	WorkspaceInlineAcls []*models.DataEngineACL `json:"acls,omitempty"`

	// The data sources to be added to the workspace. Required in a POST request.
	WorkspaceInlineDataSources []*models.WorkspaceInlineDataSourcesInlineArrayItem `json:"data_sources,omitempty"`

	// workspace inline errors
	// Read Only: true
	WorkspaceInlineErrors []*models.WorkspaceInlineErrorsInlineArrayItem `json:"errors,omitempty"`

	// workspace inline policies
	WorkspaceInlinePolicies []*models.WorkspaceInlinePoliciesInlineArrayItem `json:"policies,omitempty"`

	// workspace response inline records
	WorkspaceResponseInlineRecords []*models.Workspace `json:"records,omitempty"`
}

// Validate validates this workspace modify collection body
func (o *WorkspaceModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLastRefreshTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWorkspaceInlineAcls(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWorkspaceInlineDataSources(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWorkspaceInlineErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWorkspaceInlinePolicies(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWorkspaceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) validateLastRefreshTime(formats strfmt.Registry) error {
	if swag.IsZero(o.LastRefreshTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"last_refresh_time", "body", "date-time", o.LastRefreshTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

var workspaceModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["processing","ready","failed","outdated"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		workspaceModifyCollectionBodyTypeStatePropEnum = append(workspaceModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// WorkspaceModifyCollectionBody
	// WorkspaceModifyCollectionBody
	// state
	// State
	// processing
	// END DEBUGGING
	// WorkspaceModifyCollectionBodyStateProcessing captures enum value "processing"
	WorkspaceModifyCollectionBodyStateProcessing string = "processing"

	// BEGIN DEBUGGING
	// WorkspaceModifyCollectionBody
	// WorkspaceModifyCollectionBody
	// state
	// State
	// ready
	// END DEBUGGING
	// WorkspaceModifyCollectionBodyStateReady captures enum value "ready"
	WorkspaceModifyCollectionBodyStateReady string = "ready"

	// BEGIN DEBUGGING
	// WorkspaceModifyCollectionBody
	// WorkspaceModifyCollectionBody
	// state
	// State
	// failed
	// END DEBUGGING
	// WorkspaceModifyCollectionBodyStateFailed captures enum value "failed"
	WorkspaceModifyCollectionBodyStateFailed string = "failed"

	// BEGIN DEBUGGING
	// WorkspaceModifyCollectionBody
	// WorkspaceModifyCollectionBody
	// state
	// State
	// outdated
	// END DEBUGGING
	// WorkspaceModifyCollectionBodyStateOutdated captures enum value "outdated"
	WorkspaceModifyCollectionBodyStateOutdated string = "outdated"
)

// prop value enum
func (o *WorkspaceModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, workspaceModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *WorkspaceModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"update_time", "body", "date-time", o.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(o.Version) { // not required
		return nil
	}

	if o.Version != nil {
		if err := o.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) validateWorkspaceInlineAcls(formats strfmt.Registry) error {
	if swag.IsZero(o.WorkspaceInlineAcls) { // not required
		return nil
	}

	for i := 0; i < len(o.WorkspaceInlineAcls); i++ {
		if swag.IsZero(o.WorkspaceInlineAcls[i]) { // not required
			continue
		}

		if o.WorkspaceInlineAcls[i] != nil {
			if err := o.WorkspaceInlineAcls[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "acls" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) validateWorkspaceInlineDataSources(formats strfmt.Registry) error {
	if swag.IsZero(o.WorkspaceInlineDataSources) { // not required
		return nil
	}

	for i := 0; i < len(o.WorkspaceInlineDataSources); i++ {
		if swag.IsZero(o.WorkspaceInlineDataSources[i]) { // not required
			continue
		}

		if o.WorkspaceInlineDataSources[i] != nil {
			if err := o.WorkspaceInlineDataSources[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "data_sources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) validateWorkspaceInlineErrors(formats strfmt.Registry) error {
	if swag.IsZero(o.WorkspaceInlineErrors) { // not required
		return nil
	}

	for i := 0; i < len(o.WorkspaceInlineErrors); i++ {
		if swag.IsZero(o.WorkspaceInlineErrors[i]) { // not required
			continue
		}

		if o.WorkspaceInlineErrors[i] != nil {
			if err := o.WorkspaceInlineErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) validateWorkspaceInlinePolicies(formats strfmt.Registry) error {
	if swag.IsZero(o.WorkspaceInlinePolicies) { // not required
		return nil
	}

	for i := 0; i < len(o.WorkspaceInlinePolicies); i++ {
		if swag.IsZero(o.WorkspaceInlinePolicies[i]) { // not required
			continue
		}

		if o.WorkspaceInlinePolicies[i] != nil {
			if err := o.WorkspaceInlinePolicies[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) validateWorkspaceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.WorkspaceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.WorkspaceResponseInlineRecords); i++ {
		if swag.IsZero(o.WorkspaceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.WorkspaceResponseInlineRecords[i] != nil {
			if err := o.WorkspaceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this workspace modify collection body based on the context it is used
func (o *WorkspaceModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataCollectionCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEntityCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastRefreshTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWorkspaceInlineAcls(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWorkspaceInlineDataSources(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWorkspaceInlineErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWorkspaceInlinePolicies(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWorkspaceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateDataCollectionCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"data_collection_count", "body", o.DataCollectionCount); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateEntityCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"entity_count", "body", o.EntityCount); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateLastRefreshTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"last_refresh_time", "body", o.LastRefreshTime); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"owner", "body", o.Owner); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"update_time", "body", o.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if o.Version != nil {
		if err := o.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateWorkspaceInlineAcls(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.WorkspaceInlineAcls); i++ {

		if o.WorkspaceInlineAcls[i] != nil {
			if err := o.WorkspaceInlineAcls[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "acls" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateWorkspaceInlineDataSources(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.WorkspaceInlineDataSources); i++ {

		if o.WorkspaceInlineDataSources[i] != nil {
			if err := o.WorkspaceInlineDataSources[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "data_sources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateWorkspaceInlineErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"errors", "body", []*models.WorkspaceInlineErrorsInlineArrayItem(o.WorkspaceInlineErrors)); err != nil {
		return err
	}

	for i := 0; i < len(o.WorkspaceInlineErrors); i++ {

		if o.WorkspaceInlineErrors[i] != nil {
			if err := o.WorkspaceInlineErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateWorkspaceInlinePolicies(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.WorkspaceInlinePolicies); i++ {

		if o.WorkspaceInlinePolicies[i] != nil {
			if err := o.WorkspaceInlinePolicies[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *WorkspaceModifyCollectionBody) contextValidateWorkspaceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.WorkspaceResponseInlineRecords); i++ {

		if o.WorkspaceResponseInlineRecords[i] != nil {
			if err := o.WorkspaceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *WorkspaceModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WorkspaceModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res WorkspaceModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
WorkspaceInlineDataSourcesInlineArrayItem workspace inline data sources inline array item
swagger:model workspace_inline_data_sources_inline_array_item
*/
type WorkspaceInlineDataSourcesInlineArrayItem struct {

	// data source
	DataSource *models.CommonDataSource `json:"data_source,omitempty"`
}

// Validate validates this workspace inline data sources inline array item
func (o *WorkspaceInlineDataSourcesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDataSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceInlineDataSourcesInlineArrayItem) validateDataSource(formats strfmt.Registry) error {
	if swag.IsZero(o.DataSource) { // not required
		return nil
	}

	if o.DataSource != nil {
		if err := o.DataSource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this workspace inline data sources inline array item based on the context it is used
func (o *WorkspaceInlineDataSourcesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDataSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceInlineDataSourcesInlineArrayItem) contextValidateDataSource(ctx context.Context, formats strfmt.Registry) error {

	if o.DataSource != nil {
		if err := o.DataSource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *WorkspaceInlineDataSourcesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WorkspaceInlineDataSourcesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlineDataSourcesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
WorkspaceInlineErrorsInlineArrayItem workspace inline errors inline array item
swagger:model workspace_inline_errors_inline_array_item
*/
type WorkspaceInlineErrorsInlineArrayItem struct {

	// error
	Error *models.DcnCommonError `json:"error,omitempty"`
}

// Validate validates this workspace inline errors inline array item
func (o *WorkspaceInlineErrorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceInlineErrorsInlineArrayItem) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this workspace inline errors inline array item based on the context it is used
func (o *WorkspaceInlineErrorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceInlineErrorsInlineArrayItem) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *WorkspaceInlineErrorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WorkspaceInlineErrorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlineErrorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
WorkspaceInlinePoliciesInlineArrayItem workspace inline policies inline array item
swagger:model workspace_inline_policies_inline_array_item
*/
type WorkspaceInlinePoliciesInlineArrayItem struct {

	// description
	// Example: Description of Policy
	Description *string `json:"description,omitempty"`

	// name
	// Example: Example Policy
	Name *string `json:"name,omitempty"`

	// The unique identifier of the policy.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this workspace inline policies inline array item
func (o *WorkspaceInlinePoliciesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceInlinePoliciesInlineArrayItem) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this workspace inline policies inline array item based on context it is used
func (o *WorkspaceInlinePoliciesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *WorkspaceInlinePoliciesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WorkspaceInlinePoliciesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlinePoliciesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
WorkspaceInlineSpace workspace inline space
swagger:model workspace_inline_space
*/
type WorkspaceInlineSpace struct {

	// The available space of a workspace, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The total space of a workspace, in bytes.
	// Read Only: true
	Total *int64 `json:"total,omitempty"`

	// The used space of a workspace, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this workspace inline space
func (o *WorkspaceInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this workspace inline space based on the context it is used
func (o *WorkspaceInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceInlineSpace) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"total", "body", o.Total); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *WorkspaceInlineSpace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WorkspaceInlineSpace) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
WorkspaceInlineVersion The version information of a workspace.
swagger:model workspace_inline_version
*/
type WorkspaceInlineVersion struct {

	// current
	Current *models.WorkspaceInlineVersionInlineCurrent `json:"current,omitempty"`

	// job
	Job *models.DataEngineVersionJob `json:"job,omitempty"`

	// next
	Next *models.WorkspaceInlineVersionInlineNext `json:"next,omitempty"`

	// The unique identifier of the version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this workspace inline version
func (o *WorkspaceInlineVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCurrent(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceInlineVersion) validateCurrent(formats strfmt.Registry) error {
	if swag.IsZero(o.Current) { // not required
		return nil
	}

	if o.Current != nil {
		if err := o.Current.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "current")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceInlineVersion) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(o.Job) { // not required
		return nil
	}

	if o.Job != nil {
		if err := o.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceInlineVersion) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(o.Next) { // not required
		return nil
	}

	if o.Next != nil {
		if err := o.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceInlineVersion) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"version"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this workspace inline version based on the context it is used
func (o *WorkspaceInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceInlineVersion) contextValidateCurrent(ctx context.Context, formats strfmt.Registry) error {

	if o.Current != nil {
		if err := o.Current.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "current")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceInlineVersion) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if o.Job != nil {
		if err := o.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceInlineVersion) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if o.Next != nil {
		if err := o.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "next")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *WorkspaceInlineVersion) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WorkspaceInlineVersion) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
WorkspaceInlineVersionInlineCurrent Current version information.
swagger:model workspace_inline_version_inline_current
*/
type WorkspaceInlineVersionInlineCurrent struct {

	// job
	Job *models.DataEngineVersionJob `json:"job,omitempty"`

	// The unique identifier of the current version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this workspace inline version inline current
func (o *WorkspaceInlineVersionInlineCurrent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceInlineVersionInlineCurrent) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(o.Job) { // not required
		return nil
	}

	if o.Job != nil {
		if err := o.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "current" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceInlineVersionInlineCurrent) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"version"+"."+"current"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this workspace inline version inline current based on the context it is used
func (o *WorkspaceInlineVersionInlineCurrent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceInlineVersionInlineCurrent) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if o.Job != nil {
		if err := o.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "current" + "." + "job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *WorkspaceInlineVersionInlineCurrent) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WorkspaceInlineVersionInlineCurrent) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlineVersionInlineCurrent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
WorkspaceInlineVersionInlineNext Next version information.
swagger:model workspace_inline_version_inline_next
*/
type WorkspaceInlineVersionInlineNext struct {

	// job
	Job *models.DataEngineVersionJob `json:"job,omitempty"`

	// The unique identifier of the next version.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this workspace inline version inline next
func (o *WorkspaceInlineVersionInlineNext) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceInlineVersionInlineNext) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(o.Job) { // not required
		return nil
	}

	if o.Job != nil {
		if err := o.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "next" + "." + "job")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceInlineVersionInlineNext) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"version"+"."+"next"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this workspace inline version inline next based on the context it is used
func (o *WorkspaceInlineVersionInlineNext) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceInlineVersionInlineNext) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if o.Job != nil {
		if err := o.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "version" + "." + "next" + "." + "job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *WorkspaceInlineVersionInlineNext) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WorkspaceInlineVersionInlineNext) UnmarshalBinary(b []byte) error {
	var res WorkspaceInlineVersionInlineNext
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
