// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceModifyReader is a Reader for the WorkspaceModify structure.
type WorkspaceModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewWorkspaceModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceModifyOK creates a WorkspaceModifyOK with default headers values
func NewWorkspaceModifyOK() *WorkspaceModifyOK {
	return &WorkspaceModifyOK{}
}

/*
WorkspaceModifyOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceModifyOK struct {
}

// IsSuccess returns true when this workspace modify o k response has a 2xx status code
func (o *WorkspaceModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace modify o k response has a 3xx status code
func (o *WorkspaceModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace modify o k response has a 4xx status code
func (o *WorkspaceModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace modify o k response has a 5xx status code
func (o *WorkspaceModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace modify o k response a status code equal to that given
func (o *WorkspaceModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace modify o k response
func (o *WorkspaceModifyOK) Code() int {
	return 200
}

func (o *WorkspaceModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{uuid}][%d] workspaceModifyOK", 200)
}

func (o *WorkspaceModifyOK) String() string {
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{uuid}][%d] workspaceModifyOK", 200)
}

func (o *WorkspaceModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewWorkspaceModifyAccepted creates a WorkspaceModifyAccepted with default headers values
func NewWorkspaceModifyAccepted() *WorkspaceModifyAccepted {
	return &WorkspaceModifyAccepted{}
}

/*
WorkspaceModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type WorkspaceModifyAccepted struct {
	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this workspace modify accepted response has a 2xx status code
func (o *WorkspaceModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace modify accepted response has a 3xx status code
func (o *WorkspaceModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace modify accepted response has a 4xx status code
func (o *WorkspaceModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace modify accepted response has a 5xx status code
func (o *WorkspaceModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace modify accepted response a status code equal to that given
func (o *WorkspaceModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the workspace modify accepted response
func (o *WorkspaceModifyAccepted) Code() int {
	return 202
}

func (o *WorkspaceModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{uuid}][%d] workspaceModifyAccepted %s", 202, payload)
}

func (o *WorkspaceModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{uuid}][%d] workspaceModifyAccepted %s", 202, payload)
}

func (o *WorkspaceModifyAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *WorkspaceModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceModifyDefault creates a WorkspaceModifyDefault with default headers values
func NewWorkspaceModifyDefault(code int) *WorkspaceModifyDefault {
	return &WorkspaceModifyDefault{
		_statusCode: code,
	}
}

/*
WorkspaceModifyDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace modify default response has a 2xx status code
func (o *WorkspaceModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace modify default response has a 3xx status code
func (o *WorkspaceModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace modify default response has a 4xx status code
func (o *WorkspaceModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace modify default response has a 5xx status code
func (o *WorkspaceModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace modify default response a status code equal to that given
func (o *WorkspaceModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace modify default response
func (o *WorkspaceModifyDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{uuid}][%d] workspace_modify default %s", o._statusCode, payload)
}

func (o *WorkspaceModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{uuid}][%d] workspace_modify default %s", o._statusCode, payload)
}

func (o *WorkspaceModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
