// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWorkspaceQueryCollectionGetParams creates a new WorkspaceQueryCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceQueryCollectionGetParams() *WorkspaceQueryCollectionGetParams {
	return &WorkspaceQueryCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceQueryCollectionGetParamsWithTimeout creates a new WorkspaceQueryCollectionGetParams object
// with the ability to set a timeout on a request.
func NewWorkspaceQueryCollectionGetParamsWithTimeout(timeout time.Duration) *WorkspaceQueryCollectionGetParams {
	return &WorkspaceQueryCollectionGetParams{
		timeout: timeout,
	}
}

// NewWorkspaceQueryCollectionGetParamsWithContext creates a new WorkspaceQueryCollectionGetParams object
// with the ability to set a context for a request.
func NewWorkspaceQueryCollectionGetParamsWithContext(ctx context.Context) *WorkspaceQueryCollectionGetParams {
	return &WorkspaceQueryCollectionGetParams{
		Context: ctx,
	}
}

// NewWorkspaceQueryCollectionGetParamsWithHTTPClient creates a new WorkspaceQueryCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceQueryCollectionGetParamsWithHTTPClient(client *http.Client) *WorkspaceQueryCollectionGetParams {
	return &WorkspaceQueryCollectionGetParams{
		HTTPClient: client,
	}
}

/*
WorkspaceQueryCollectionGetParams contains all the parameters to send to the API endpoint

	for the workspace query collection get operation.

	Typically these are written to a http.Request.
*/
type WorkspaceQueryCollectionGetParams struct {

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Description.

	   Filter by description
	*/
	Description *string

	/* Expression.

	   Filter by expression
	*/
	Expression *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* UpdateTime.

	   Filter by update_time
	*/
	UpdateTime *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace query collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceQueryCollectionGetParams) WithDefaults() *WorkspaceQueryCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace query collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceQueryCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := WorkspaceQueryCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithTimeout(timeout time.Duration) *WorkspaceQueryCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithContext(ctx context.Context) *WorkspaceQueryCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithHTTPClient(client *http.Client) *WorkspaceQueryCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCreateTime adds the createTime to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithCreateTime(createTime *string) *WorkspaceQueryCollectionGetParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithDescription adds the description to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithDescription(description *string) *WorkspaceQueryCollectionGetParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetDescription(description *string) {
	o.Description = description
}

// WithExpression adds the expression to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithExpression(expression *string) *WorkspaceQueryCollectionGetParams {
	o.SetExpression(expression)
	return o
}

// SetExpression adds the expression to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetExpression(expression *string) {
	o.Expression = expression
}

// WithFields adds the fields to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithFields(fields []string) *WorkspaceQueryCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithMaxRecords(maxRecords *int64) *WorkspaceQueryCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithOrderBy(orderBy []string) *WorkspaceQueryCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithReturnRecords(returnRecords *bool) *WorkspaceQueryCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *WorkspaceQueryCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUpdateTime adds the updateTime to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithUpdateTime(updateTime *string) *WorkspaceQueryCollectionGetParams {
	o.SetUpdateTime(updateTime)
	return o
}

// SetUpdateTime adds the updateTime to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetUpdateTime(updateTime *string) {
	o.UpdateTime = updateTime
}

// WithUUID adds the uuid to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithUUID(uuid *string) *WorkspaceQueryCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWorkspaceName adds the workspaceName to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithWorkspaceName(workspaceName *string) *WorkspaceQueryCollectionGetParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceUUID adds the workspaceUUID to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) WithWorkspaceUUID(workspaceUUID string) *WorkspaceQueryCollectionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the workspace query collection get params
func (o *WorkspaceQueryCollectionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceQueryCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.Expression != nil {

		// query param expression
		var qrExpression string

		if o.Expression != nil {
			qrExpression = *o.Expression
		}
		qExpression := qrExpression
		if qExpression != "" {

			if err := r.SetQueryParam("expression", qExpression); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.UpdateTime != nil {

		// query param update_time
		var qrUpdateTime string

		if o.UpdateTime != nil {
			qrUpdateTime = *o.UpdateTime
		}
		qUpdateTime := qrUpdateTime
		if qUpdateTime != "" {

			if err := r.SetQueryParam("update_time", qUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWorkspaceQueryCollectionGet binds the parameter fields
func (o *WorkspaceQueryCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamWorkspaceQueryCollectionGet binds the parameter order_by
func (o *WorkspaceQueryCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
