// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewWorkspaceQueryCreateParams creates a new WorkspaceQueryCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceQueryCreateParams() *WorkspaceQueryCreateParams {
	return &WorkspaceQueryCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceQueryCreateParamsWithTimeout creates a new WorkspaceQueryCreateParams object
// with the ability to set a timeout on a request.
func NewWorkspaceQueryCreateParamsWithTimeout(timeout time.Duration) *WorkspaceQueryCreateParams {
	return &WorkspaceQueryCreateParams{
		timeout: timeout,
	}
}

// NewWorkspaceQueryCreateParamsWithContext creates a new WorkspaceQueryCreateParams object
// with the ability to set a context for a request.
func NewWorkspaceQueryCreateParamsWithContext(ctx context.Context) *WorkspaceQueryCreateParams {
	return &WorkspaceQueryCreateParams{
		Context: ctx,
	}
}

// NewWorkspaceQueryCreateParamsWithHTTPClient creates a new WorkspaceQueryCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceQueryCreateParamsWithHTTPClient(client *http.Client) *WorkspaceQueryCreateParams {
	return &WorkspaceQueryCreateParams{
		HTTPClient: client,
	}
}

/*
WorkspaceQueryCreateParams contains all the parameters to send to the API endpoint

	for the workspace query create operation.

	Typically these are written to a http.Request.
*/
type WorkspaceQueryCreateParams struct {

	/* Info.

	   Query specification
	*/
	Info *models.WorkspaceQuery

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace query create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceQueryCreateParams) WithDefaults() *WorkspaceQueryCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace query create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceQueryCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := WorkspaceQueryCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the workspace query create params
func (o *WorkspaceQueryCreateParams) WithTimeout(timeout time.Duration) *WorkspaceQueryCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace query create params
func (o *WorkspaceQueryCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace query create params
func (o *WorkspaceQueryCreateParams) WithContext(ctx context.Context) *WorkspaceQueryCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace query create params
func (o *WorkspaceQueryCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace query create params
func (o *WorkspaceQueryCreateParams) WithHTTPClient(client *http.Client) *WorkspaceQueryCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace query create params
func (o *WorkspaceQueryCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the workspace query create params
func (o *WorkspaceQueryCreateParams) WithInfo(info *models.WorkspaceQuery) *WorkspaceQueryCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the workspace query create params
func (o *WorkspaceQueryCreateParams) SetInfo(info *models.WorkspaceQuery) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the workspace query create params
func (o *WorkspaceQueryCreateParams) WithReturnRecords(returnRecords *bool) *WorkspaceQueryCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the workspace query create params
func (o *WorkspaceQueryCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithWorkspaceUUID adds the workspaceUUID to the workspace query create params
func (o *WorkspaceQueryCreateParams) WithWorkspaceUUID(workspaceUUID string) *WorkspaceQueryCreateParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the workspace query create params
func (o *WorkspaceQueryCreateParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceQueryCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
