// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceQueryCreateReader is a Reader for the WorkspaceQueryCreate structure.
type WorkspaceQueryCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceQueryCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewWorkspaceQueryCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceQueryCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceQueryCreateCreated creates a WorkspaceQueryCreateCreated with default headers values
func NewWorkspaceQueryCreateCreated() *WorkspaceQueryCreateCreated {
	return &WorkspaceQueryCreateCreated{}
}

/*
WorkspaceQueryCreateCreated describes a response with status code 201, with default header values.

Created
*/
type WorkspaceQueryCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.WorkspaceQueryResponse
}

// IsSuccess returns true when this workspace query create created response has a 2xx status code
func (o *WorkspaceQueryCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace query create created response has a 3xx status code
func (o *WorkspaceQueryCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace query create created response has a 4xx status code
func (o *WorkspaceQueryCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace query create created response has a 5xx status code
func (o *WorkspaceQueryCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace query create created response a status code equal to that given
func (o *WorkspaceQueryCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the workspace query create created response
func (o *WorkspaceQueryCreateCreated) Code() int {
	return 201
}

func (o *WorkspaceQueryCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/queries][%d] workspaceQueryCreateCreated %s", 201, payload)
}

func (o *WorkspaceQueryCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/queries][%d] workspaceQueryCreateCreated %s", 201, payload)
}

func (o *WorkspaceQueryCreateCreated) GetPayload() *models.WorkspaceQueryResponse {
	return o.Payload
}

func (o *WorkspaceQueryCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.WorkspaceQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceQueryCreateDefault creates a WorkspaceQueryCreateDefault with default headers values
func NewWorkspaceQueryCreateDefault(code int) *WorkspaceQueryCreateDefault {
	return &WorkspaceQueryCreateDefault{
		_statusCode: code,
	}
}

/*
WorkspaceQueryCreateDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceQueryCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace query create default response has a 2xx status code
func (o *WorkspaceQueryCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace query create default response has a 3xx status code
func (o *WorkspaceQueryCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace query create default response has a 4xx status code
func (o *WorkspaceQueryCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace query create default response has a 5xx status code
func (o *WorkspaceQueryCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace query create default response a status code equal to that given
func (o *WorkspaceQueryCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace query create default response
func (o *WorkspaceQueryCreateDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceQueryCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/queries][%d] workspace_query_create default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/queries][%d] workspace_query_create default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceQueryCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
