// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWorkspaceQueryDeleteCollectionParams creates a new WorkspaceQueryDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceQueryDeleteCollectionParams() *WorkspaceQueryDeleteCollectionParams {
	return &WorkspaceQueryDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceQueryDeleteCollectionParamsWithTimeout creates a new WorkspaceQueryDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewWorkspaceQueryDeleteCollectionParamsWithTimeout(timeout time.Duration) *WorkspaceQueryDeleteCollectionParams {
	return &WorkspaceQueryDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewWorkspaceQueryDeleteCollectionParamsWithContext creates a new WorkspaceQueryDeleteCollectionParams object
// with the ability to set a context for a request.
func NewWorkspaceQueryDeleteCollectionParamsWithContext(ctx context.Context) *WorkspaceQueryDeleteCollectionParams {
	return &WorkspaceQueryDeleteCollectionParams{
		Context: ctx,
	}
}

// NewWorkspaceQueryDeleteCollectionParamsWithHTTPClient creates a new WorkspaceQueryDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceQueryDeleteCollectionParamsWithHTTPClient(client *http.Client) *WorkspaceQueryDeleteCollectionParams {
	return &WorkspaceQueryDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
WorkspaceQueryDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the workspace query delete collection operation.

	Typically these are written to a http.Request.
*/
type WorkspaceQueryDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Description.

	   Filter by description
	*/
	Description *string

	/* Expression.

	   Filter by expression
	*/
	Expression *string

	/* Info.

	   Info specification
	*/
	Info WorkspaceQueryDeleteCollectionBody

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* UpdateTime.

	   Filter by update_time
	*/
	UpdateTime *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace query delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceQueryDeleteCollectionParams) WithDefaults() *WorkspaceQueryDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace query delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceQueryDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := WorkspaceQueryDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithTimeout(timeout time.Duration) *WorkspaceQueryDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithContext(ctx context.Context) *WorkspaceQueryDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithHTTPClient(client *http.Client) *WorkspaceQueryDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *WorkspaceQueryDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCreateTime adds the createTime to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithCreateTime(createTime *string) *WorkspaceQueryDeleteCollectionParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithDescription adds the description to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithDescription(description *string) *WorkspaceQueryDeleteCollectionParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetDescription(description *string) {
	o.Description = description
}

// WithExpression adds the expression to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithExpression(expression *string) *WorkspaceQueryDeleteCollectionParams {
	o.SetExpression(expression)
	return o
}

// SetExpression adds the expression to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetExpression(expression *string) {
	o.Expression = expression
}

// WithInfo adds the info to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithInfo(info WorkspaceQueryDeleteCollectionBody) *WorkspaceQueryDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetInfo(info WorkspaceQueryDeleteCollectionBody) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *WorkspaceQueryDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *WorkspaceQueryDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *WorkspaceQueryDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithUpdateTime adds the updateTime to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithUpdateTime(updateTime *string) *WorkspaceQueryDeleteCollectionParams {
	o.SetUpdateTime(updateTime)
	return o
}

// SetUpdateTime adds the updateTime to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetUpdateTime(updateTime *string) {
	o.UpdateTime = updateTime
}

// WithUUID adds the uuid to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithUUID(uuid *string) *WorkspaceQueryDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWorkspaceName adds the workspaceName to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithWorkspaceName(workspaceName *string) *WorkspaceQueryDeleteCollectionParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceUUID adds the workspaceUUID to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) WithWorkspaceUUID(workspaceUUID string) *WorkspaceQueryDeleteCollectionParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the workspace query delete collection params
func (o *WorkspaceQueryDeleteCollectionParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceQueryDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.Expression != nil {

		// query param expression
		var qrExpression string

		if o.Expression != nil {
			qrExpression = *o.Expression
		}
		qExpression := qrExpression
		if qExpression != "" {

			if err := r.SetQueryParam("expression", qExpression); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.UpdateTime != nil {

		// query param update_time
		var qrUpdateTime string

		if o.UpdateTime != nil {
			qrUpdateTime = *o.UpdateTime
		}
		qUpdateTime := qrUpdateTime
		if qUpdateTime != "" {

			if err := r.SetQueryParam("update_time", qUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
