// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceQueryDeleteCollectionReader is a Reader for the WorkspaceQueryDeleteCollection structure.
type WorkspaceQueryDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceQueryDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceQueryDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceQueryDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceQueryDeleteCollectionOK creates a WorkspaceQueryDeleteCollectionOK with default headers values
func NewWorkspaceQueryDeleteCollectionOK() *WorkspaceQueryDeleteCollectionOK {
	return &WorkspaceQueryDeleteCollectionOK{}
}

/*
WorkspaceQueryDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceQueryDeleteCollectionOK struct {
}

// IsSuccess returns true when this workspace query delete collection o k response has a 2xx status code
func (o *WorkspaceQueryDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace query delete collection o k response has a 3xx status code
func (o *WorkspaceQueryDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace query delete collection o k response has a 4xx status code
func (o *WorkspaceQueryDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace query delete collection o k response has a 5xx status code
func (o *WorkspaceQueryDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace query delete collection o k response a status code equal to that given
func (o *WorkspaceQueryDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace query delete collection o k response
func (o *WorkspaceQueryDeleteCollectionOK) Code() int {
	return 200
}

func (o *WorkspaceQueryDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/queries][%d] workspaceQueryDeleteCollectionOK", 200)
}

func (o *WorkspaceQueryDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/queries][%d] workspaceQueryDeleteCollectionOK", 200)
}

func (o *WorkspaceQueryDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewWorkspaceQueryDeleteCollectionDefault creates a WorkspaceQueryDeleteCollectionDefault with default headers values
func NewWorkspaceQueryDeleteCollectionDefault(code int) *WorkspaceQueryDeleteCollectionDefault {
	return &WorkspaceQueryDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
WorkspaceQueryDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceQueryDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace query delete collection default response has a 2xx status code
func (o *WorkspaceQueryDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace query delete collection default response has a 3xx status code
func (o *WorkspaceQueryDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace query delete collection default response has a 4xx status code
func (o *WorkspaceQueryDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace query delete collection default response has a 5xx status code
func (o *WorkspaceQueryDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace query delete collection default response a status code equal to that given
func (o *WorkspaceQueryDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace query delete collection default response
func (o *WorkspaceQueryDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceQueryDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/queries][%d] workspace_query_delete_collection default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/queries][%d] workspace_query_delete_collection default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceQueryDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
WorkspaceQueryDeleteCollectionBody workspace query delete collection body
swagger:model WorkspaceQueryDeleteCollectionBody
*/
type WorkspaceQueryDeleteCollectionBody struct {

	// The total number of queries in the workspace.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`

	// workspace query response inline records
	WorkspaceQueryResponseInlineRecords []*models.WorkspaceQuery `json:"records,omitempty"`
}

// Validate validates this workspace query delete collection body
func (o *WorkspaceQueryDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateWorkspaceQueryResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceQueryDeleteCollectionBody) validateWorkspaceQueryResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.WorkspaceQueryResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.WorkspaceQueryResponseInlineRecords); i++ {
		if swag.IsZero(o.WorkspaceQueryResponseInlineRecords[i]) { // not required
			continue
		}

		if o.WorkspaceQueryResponseInlineRecords[i] != nil {
			if err := o.WorkspaceQueryResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this workspace query delete collection body based on the context it is used
func (o *WorkspaceQueryDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWorkspaceQueryResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceQueryDeleteCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceQueryDeleteCollectionBody) contextValidateWorkspaceQueryResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.WorkspaceQueryResponseInlineRecords); i++ {

		if o.WorkspaceQueryResponseInlineRecords[i] != nil {
			if err := o.WorkspaceQueryResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *WorkspaceQueryDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WorkspaceQueryDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res WorkspaceQueryDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
