// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceQueryDeleteReader is a Reader for the WorkspaceQueryDelete structure.
type WorkspaceQueryDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceQueryDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceQueryDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceQueryDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceQueryDeleteOK creates a WorkspaceQueryDeleteOK with default headers values
func NewWorkspaceQueryDeleteOK() *WorkspaceQueryDeleteOK {
	return &WorkspaceQueryDeleteOK{}
}

/*
WorkspaceQueryDeleteOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceQueryDeleteOK struct {
}

// IsSuccess returns true when this workspace query delete o k response has a 2xx status code
func (o *WorkspaceQueryDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace query delete o k response has a 3xx status code
func (o *WorkspaceQueryDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace query delete o k response has a 4xx status code
func (o *WorkspaceQueryDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace query delete o k response has a 5xx status code
func (o *WorkspaceQueryDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace query delete o k response a status code equal to that given
func (o *WorkspaceQueryDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace query delete o k response
func (o *WorkspaceQueryDeleteOK) Code() int {
	return 200
}

func (o *WorkspaceQueryDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/queries/{uuid}][%d] workspaceQueryDeleteOK", 200)
}

func (o *WorkspaceQueryDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/queries/{uuid}][%d] workspaceQueryDeleteOK", 200)
}

func (o *WorkspaceQueryDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewWorkspaceQueryDeleteDefault creates a WorkspaceQueryDeleteDefault with default headers values
func NewWorkspaceQueryDeleteDefault(code int) *WorkspaceQueryDeleteDefault {
	return &WorkspaceQueryDeleteDefault{
		_statusCode: code,
	}
}

/*
WorkspaceQueryDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceQueryDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace query delete default response has a 2xx status code
func (o *WorkspaceQueryDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace query delete default response has a 3xx status code
func (o *WorkspaceQueryDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace query delete default response has a 4xx status code
func (o *WorkspaceQueryDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace query delete default response has a 5xx status code
func (o *WorkspaceQueryDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace query delete default response a status code equal to that given
func (o *WorkspaceQueryDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace query delete default response
func (o *WorkspaceQueryDeleteDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceQueryDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/queries/{uuid}][%d] workspace_query_delete default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /data-engine/workspaces/{workspace.uuid}/queries/{uuid}][%d] workspace_query_delete default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceQueryDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
