// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceQueryEntityCollectionGetReader is a Reader for the WorkspaceQueryEntityCollectionGet structure.
type WorkspaceQueryEntityCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceQueryEntityCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceQueryEntityCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceQueryEntityCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceQueryEntityCollectionGetOK creates a WorkspaceQueryEntityCollectionGetOK with default headers values
func NewWorkspaceQueryEntityCollectionGetOK() *WorkspaceQueryEntityCollectionGetOK {
	return &WorkspaceQueryEntityCollectionGetOK{}
}

/*
WorkspaceQueryEntityCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceQueryEntityCollectionGetOK struct {
	Payload *models.WorkspaceQueryEntityResponse
}

// IsSuccess returns true when this workspace query entity collection get o k response has a 2xx status code
func (o *WorkspaceQueryEntityCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace query entity collection get o k response has a 3xx status code
func (o *WorkspaceQueryEntityCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace query entity collection get o k response has a 4xx status code
func (o *WorkspaceQueryEntityCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace query entity collection get o k response has a 5xx status code
func (o *WorkspaceQueryEntityCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace query entity collection get o k response a status code equal to that given
func (o *WorkspaceQueryEntityCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace query entity collection get o k response
func (o *WorkspaceQueryEntityCollectionGetOK) Code() int {
	return 200
}

func (o *WorkspaceQueryEntityCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/queries/{workspace_query.uuid}/entities][%d] workspaceQueryEntityCollectionGetOK %s", 200, payload)
}

func (o *WorkspaceQueryEntityCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/queries/{workspace_query.uuid}/entities][%d] workspaceQueryEntityCollectionGetOK %s", 200, payload)
}

func (o *WorkspaceQueryEntityCollectionGetOK) GetPayload() *models.WorkspaceQueryEntityResponse {
	return o.Payload
}

func (o *WorkspaceQueryEntityCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.WorkspaceQueryEntityResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceQueryEntityCollectionGetDefault creates a WorkspaceQueryEntityCollectionGetDefault with default headers values
func NewWorkspaceQueryEntityCollectionGetDefault(code int) *WorkspaceQueryEntityCollectionGetDefault {
	return &WorkspaceQueryEntityCollectionGetDefault{
		_statusCode: code,
	}
}

/*
WorkspaceQueryEntityCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceQueryEntityCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace query entity collection get default response has a 2xx status code
func (o *WorkspaceQueryEntityCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace query entity collection get default response has a 3xx status code
func (o *WorkspaceQueryEntityCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace query entity collection get default response has a 4xx status code
func (o *WorkspaceQueryEntityCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace query entity collection get default response has a 5xx status code
func (o *WorkspaceQueryEntityCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace query entity collection get default response a status code equal to that given
func (o *WorkspaceQueryEntityCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace query entity collection get default response
func (o *WorkspaceQueryEntityCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceQueryEntityCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/queries/{workspace_query.uuid}/entities][%d] workspace_query_entity_collection_get default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryEntityCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/queries/{workspace_query.uuid}/entities][%d] workspace_query_entity_collection_get default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryEntityCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceQueryEntityCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
