// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWorkspaceQueryGetParams creates a new WorkspaceQueryGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceQueryGetParams() *WorkspaceQueryGetParams {
	return &WorkspaceQueryGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceQueryGetParamsWithTimeout creates a new WorkspaceQueryGetParams object
// with the ability to set a timeout on a request.
func NewWorkspaceQueryGetParamsWithTimeout(timeout time.Duration) *WorkspaceQueryGetParams {
	return &WorkspaceQueryGetParams{
		timeout: timeout,
	}
}

// NewWorkspaceQueryGetParamsWithContext creates a new WorkspaceQueryGetParams object
// with the ability to set a context for a request.
func NewWorkspaceQueryGetParamsWithContext(ctx context.Context) *WorkspaceQueryGetParams {
	return &WorkspaceQueryGetParams{
		Context: ctx,
	}
}

// NewWorkspaceQueryGetParamsWithHTTPClient creates a new WorkspaceQueryGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceQueryGetParamsWithHTTPClient(client *http.Client) *WorkspaceQueryGetParams {
	return &WorkspaceQueryGetParams{
		HTTPClient: client,
	}
}

/*
WorkspaceQueryGetParams contains all the parameters to send to the API endpoint

	for the workspace query get operation.

	Typically these are written to a http.Request.
*/
type WorkspaceQueryGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Unique identifier of the query.
	*/
	UUID string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace query get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceQueryGetParams) WithDefaults() *WorkspaceQueryGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace query get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceQueryGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the workspace query get params
func (o *WorkspaceQueryGetParams) WithTimeout(timeout time.Duration) *WorkspaceQueryGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace query get params
func (o *WorkspaceQueryGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace query get params
func (o *WorkspaceQueryGetParams) WithContext(ctx context.Context) *WorkspaceQueryGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace query get params
func (o *WorkspaceQueryGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace query get params
func (o *WorkspaceQueryGetParams) WithHTTPClient(client *http.Client) *WorkspaceQueryGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace query get params
func (o *WorkspaceQueryGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the workspace query get params
func (o *WorkspaceQueryGetParams) WithFields(fields []string) *WorkspaceQueryGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the workspace query get params
func (o *WorkspaceQueryGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the workspace query get params
func (o *WorkspaceQueryGetParams) WithUUID(uuid string) *WorkspaceQueryGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the workspace query get params
func (o *WorkspaceQueryGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the workspace query get params
func (o *WorkspaceQueryGetParams) WithWorkspaceUUID(workspaceUUID string) *WorkspaceQueryGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the workspace query get params
func (o *WorkspaceQueryGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceQueryGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWorkspaceQueryGet binds the parameter fields
func (o *WorkspaceQueryGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
