// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceQueryGetReader is a Reader for the WorkspaceQueryGet structure.
type WorkspaceQueryGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceQueryGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceQueryGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceQueryGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceQueryGetOK creates a WorkspaceQueryGetOK with default headers values
func NewWorkspaceQueryGetOK() *WorkspaceQueryGetOK {
	return &WorkspaceQueryGetOK{}
}

/*
WorkspaceQueryGetOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceQueryGetOK struct {
	Payload *models.WorkspaceQuery
}

// IsSuccess returns true when this workspace query get o k response has a 2xx status code
func (o *WorkspaceQueryGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace query get o k response has a 3xx status code
func (o *WorkspaceQueryGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace query get o k response has a 4xx status code
func (o *WorkspaceQueryGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace query get o k response has a 5xx status code
func (o *WorkspaceQueryGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace query get o k response a status code equal to that given
func (o *WorkspaceQueryGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace query get o k response
func (o *WorkspaceQueryGetOK) Code() int {
	return 200
}

func (o *WorkspaceQueryGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/queries/{uuid}][%d] workspaceQueryGetOK %s", 200, payload)
}

func (o *WorkspaceQueryGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/queries/{uuid}][%d] workspaceQueryGetOK %s", 200, payload)
}

func (o *WorkspaceQueryGetOK) GetPayload() *models.WorkspaceQuery {
	return o.Payload
}

func (o *WorkspaceQueryGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.WorkspaceQuery)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceQueryGetDefault creates a WorkspaceQueryGetDefault with default headers values
func NewWorkspaceQueryGetDefault(code int) *WorkspaceQueryGetDefault {
	return &WorkspaceQueryGetDefault{
		_statusCode: code,
	}
}

/*
WorkspaceQueryGetDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceQueryGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace query get default response has a 2xx status code
func (o *WorkspaceQueryGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace query get default response has a 3xx status code
func (o *WorkspaceQueryGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace query get default response has a 4xx status code
func (o *WorkspaceQueryGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace query get default response has a 5xx status code
func (o *WorkspaceQueryGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace query get default response a status code equal to that given
func (o *WorkspaceQueryGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace query get default response
func (o *WorkspaceQueryGetDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceQueryGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/queries/{uuid}][%d] workspace_query_get default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/queries/{uuid}][%d] workspace_query_get default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceQueryGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
