// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceQueryModifyCollectionReader is a Reader for the WorkspaceQueryModifyCollection structure.
type WorkspaceQueryModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceQueryModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceQueryModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceQueryModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceQueryModifyCollectionOK creates a WorkspaceQueryModifyCollectionOK with default headers values
func NewWorkspaceQueryModifyCollectionOK() *WorkspaceQueryModifyCollectionOK {
	return &WorkspaceQueryModifyCollectionOK{}
}

/*
WorkspaceQueryModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceQueryModifyCollectionOK struct {
	Payload *models.WorkspaceQuery
}

// IsSuccess returns true when this workspace query modify collection o k response has a 2xx status code
func (o *WorkspaceQueryModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace query modify collection o k response has a 3xx status code
func (o *WorkspaceQueryModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace query modify collection o k response has a 4xx status code
func (o *WorkspaceQueryModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace query modify collection o k response has a 5xx status code
func (o *WorkspaceQueryModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace query modify collection o k response a status code equal to that given
func (o *WorkspaceQueryModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace query modify collection o k response
func (o *WorkspaceQueryModifyCollectionOK) Code() int {
	return 200
}

func (o *WorkspaceQueryModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/queries][%d] workspaceQueryModifyCollectionOK %s", 200, payload)
}

func (o *WorkspaceQueryModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/queries][%d] workspaceQueryModifyCollectionOK %s", 200, payload)
}

func (o *WorkspaceQueryModifyCollectionOK) GetPayload() *models.WorkspaceQuery {
	return o.Payload
}

func (o *WorkspaceQueryModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.WorkspaceQuery)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceQueryModifyCollectionDefault creates a WorkspaceQueryModifyCollectionDefault with default headers values
func NewWorkspaceQueryModifyCollectionDefault(code int) *WorkspaceQueryModifyCollectionDefault {
	return &WorkspaceQueryModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
WorkspaceQueryModifyCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceQueryModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace query modify collection default response has a 2xx status code
func (o *WorkspaceQueryModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace query modify collection default response has a 3xx status code
func (o *WorkspaceQueryModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace query modify collection default response has a 4xx status code
func (o *WorkspaceQueryModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace query modify collection default response has a 5xx status code
func (o *WorkspaceQueryModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace query modify collection default response a status code equal to that given
func (o *WorkspaceQueryModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace query modify collection default response
func (o *WorkspaceQueryModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceQueryModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/queries][%d] workspace_query_modify_collection default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/queries][%d] workspace_query_modify_collection default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceQueryModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
WorkspaceQueryModifyCollectionBody workspace query modify collection body
swagger:model WorkspaceQueryModifyCollectionBody
*/
type WorkspaceQueryModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The creation time of the query.
	// Example: 2025-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The description of the query.
	// Example: Query for pdf files
	Description *string `json:"description,omitempty"`

	// The expression of the query.
	// Example: {'type': 'pdf'}
	Expression *string `json:"expression,omitempty"`

	// The total number of queries in the workspace.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`

	// The update time of the query.
	// Example: 2025-06-04 20:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// The unique identifier of the query.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// Workspace containing the query.
	// Read Only: true
	Workspace *models.WorkspaceReference `json:"workspace,omitempty"`

	// workspace query response inline records
	WorkspaceQueryResponseInlineRecords []*models.WorkspaceQuery `json:"records,omitempty"`
}

// Validate validates this workspace query modify collection body
func (o *WorkspaceQueryModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWorkspaceQueryResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceQueryModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceQueryModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceQueryModifyCollectionBody) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"update_time", "body", "date-time", o.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceQueryModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceQueryModifyCollectionBody) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Workspace) { // not required
		return nil
	}

	if o.Workspace != nil {
		if err := o.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "workspace")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceQueryModifyCollectionBody) validateWorkspaceQueryResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.WorkspaceQueryResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.WorkspaceQueryResponseInlineRecords); i++ {
		if swag.IsZero(o.WorkspaceQueryResponseInlineRecords[i]) { // not required
			continue
		}

		if o.WorkspaceQueryResponseInlineRecords[i] != nil {
			if err := o.WorkspaceQueryResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this workspace query modify collection body based on the context it is used
func (o *WorkspaceQueryModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWorkspaceQueryResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WorkspaceQueryModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceQueryModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceQueryModifyCollectionBody) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_records", "body", o.TotalRecords); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceQueryModifyCollectionBody) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"update_time", "body", o.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceQueryModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *WorkspaceQueryModifyCollectionBody) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Workspace != nil {
		if err := o.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "workspace")
			}
			return err
		}
	}

	return nil
}

func (o *WorkspaceQueryModifyCollectionBody) contextValidateWorkspaceQueryResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.WorkspaceQueryResponseInlineRecords); i++ {

		if o.WorkspaceQueryResponseInlineRecords[i] != nil {
			if err := o.WorkspaceQueryResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *WorkspaceQueryModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WorkspaceQueryModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res WorkspaceQueryModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
