// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewWorkspaceQueryModifyParams creates a new WorkspaceQueryModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceQueryModifyParams() *WorkspaceQueryModifyParams {
	return &WorkspaceQueryModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceQueryModifyParamsWithTimeout creates a new WorkspaceQueryModifyParams object
// with the ability to set a timeout on a request.
func NewWorkspaceQueryModifyParamsWithTimeout(timeout time.Duration) *WorkspaceQueryModifyParams {
	return &WorkspaceQueryModifyParams{
		timeout: timeout,
	}
}

// NewWorkspaceQueryModifyParamsWithContext creates a new WorkspaceQueryModifyParams object
// with the ability to set a context for a request.
func NewWorkspaceQueryModifyParamsWithContext(ctx context.Context) *WorkspaceQueryModifyParams {
	return &WorkspaceQueryModifyParams{
		Context: ctx,
	}
}

// NewWorkspaceQueryModifyParamsWithHTTPClient creates a new WorkspaceQueryModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceQueryModifyParamsWithHTTPClient(client *http.Client) *WorkspaceQueryModifyParams {
	return &WorkspaceQueryModifyParams{
		HTTPClient: client,
	}
}

/*
WorkspaceQueryModifyParams contains all the parameters to send to the API endpoint

	for the workspace query modify operation.

	Typically these are written to a http.Request.
*/
type WorkspaceQueryModifyParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Info.

	   Query specification
	*/
	Info *models.WorkspaceQuery

	/* UUID.

	   Unique identifier of the query.
	*/
	UUID string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace query modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceQueryModifyParams) WithDefaults() *WorkspaceQueryModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace query modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceQueryModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the workspace query modify params
func (o *WorkspaceQueryModifyParams) WithTimeout(timeout time.Duration) *WorkspaceQueryModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace query modify params
func (o *WorkspaceQueryModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace query modify params
func (o *WorkspaceQueryModifyParams) WithContext(ctx context.Context) *WorkspaceQueryModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace query modify params
func (o *WorkspaceQueryModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace query modify params
func (o *WorkspaceQueryModifyParams) WithHTTPClient(client *http.Client) *WorkspaceQueryModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace query modify params
func (o *WorkspaceQueryModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the workspace query modify params
func (o *WorkspaceQueryModifyParams) WithFields(fields []string) *WorkspaceQueryModifyParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the workspace query modify params
func (o *WorkspaceQueryModifyParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInfo adds the info to the workspace query modify params
func (o *WorkspaceQueryModifyParams) WithInfo(info *models.WorkspaceQuery) *WorkspaceQueryModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the workspace query modify params
func (o *WorkspaceQueryModifyParams) SetInfo(info *models.WorkspaceQuery) {
	o.Info = info
}

// WithUUID adds the uuid to the workspace query modify params
func (o *WorkspaceQueryModifyParams) WithUUID(uuid string) *WorkspaceQueryModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the workspace query modify params
func (o *WorkspaceQueryModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the workspace query modify params
func (o *WorkspaceQueryModifyParams) WithWorkspaceUUID(workspaceUUID string) *WorkspaceQueryModifyParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the workspace query modify params
func (o *WorkspaceQueryModifyParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceQueryModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWorkspaceQueryModify binds the parameter fields
func (o *WorkspaceQueryModifyParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
