// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceQueryModifyReader is a Reader for the WorkspaceQueryModify structure.
type WorkspaceQueryModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceQueryModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceQueryModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceQueryModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceQueryModifyOK creates a WorkspaceQueryModifyOK with default headers values
func NewWorkspaceQueryModifyOK() *WorkspaceQueryModifyOK {
	return &WorkspaceQueryModifyOK{}
}

/*
WorkspaceQueryModifyOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceQueryModifyOK struct {
	Payload *models.WorkspaceQuery
}

// IsSuccess returns true when this workspace query modify o k response has a 2xx status code
func (o *WorkspaceQueryModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace query modify o k response has a 3xx status code
func (o *WorkspaceQueryModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace query modify o k response has a 4xx status code
func (o *WorkspaceQueryModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace query modify o k response has a 5xx status code
func (o *WorkspaceQueryModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace query modify o k response a status code equal to that given
func (o *WorkspaceQueryModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace query modify o k response
func (o *WorkspaceQueryModifyOK) Code() int {
	return 200
}

func (o *WorkspaceQueryModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/queries/{uuid}][%d] workspaceQueryModifyOK %s", 200, payload)
}

func (o *WorkspaceQueryModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/queries/{uuid}][%d] workspaceQueryModifyOK %s", 200, payload)
}

func (o *WorkspaceQueryModifyOK) GetPayload() *models.WorkspaceQuery {
	return o.Payload
}

func (o *WorkspaceQueryModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.WorkspaceQuery)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceQueryModifyDefault creates a WorkspaceQueryModifyDefault with default headers values
func NewWorkspaceQueryModifyDefault(code int) *WorkspaceQueryModifyDefault {
	return &WorkspaceQueryModifyDefault{
		_statusCode: code,
	}
}

/*
WorkspaceQueryModifyDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceQueryModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace query modify default response has a 2xx status code
func (o *WorkspaceQueryModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace query modify default response has a 3xx status code
func (o *WorkspaceQueryModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace query modify default response has a 4xx status code
func (o *WorkspaceQueryModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace query modify default response has a 5xx status code
func (o *WorkspaceQueryModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace query modify default response a status code equal to that given
func (o *WorkspaceQueryModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace query modify default response
func (o *WorkspaceQueryModifyDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceQueryModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/queries/{uuid}][%d] workspace_query_modify default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /data-engine/workspaces/{workspace.uuid}/queries/{uuid}][%d] workspace_query_modify default %s", o._statusCode, payload)
}

func (o *WorkspaceQueryModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceQueryModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
