// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWorkspaceVersionCollectionGetParams creates a new WorkspaceVersionCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceVersionCollectionGetParams() *WorkspaceVersionCollectionGetParams {
	return &WorkspaceVersionCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceVersionCollectionGetParamsWithTimeout creates a new WorkspaceVersionCollectionGetParams object
// with the ability to set a timeout on a request.
func NewWorkspaceVersionCollectionGetParamsWithTimeout(timeout time.Duration) *WorkspaceVersionCollectionGetParams {
	return &WorkspaceVersionCollectionGetParams{
		timeout: timeout,
	}
}

// NewWorkspaceVersionCollectionGetParamsWithContext creates a new WorkspaceVersionCollectionGetParams object
// with the ability to set a context for a request.
func NewWorkspaceVersionCollectionGetParamsWithContext(ctx context.Context) *WorkspaceVersionCollectionGetParams {
	return &WorkspaceVersionCollectionGetParams{
		Context: ctx,
	}
}

// NewWorkspaceVersionCollectionGetParamsWithHTTPClient creates a new WorkspaceVersionCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceVersionCollectionGetParamsWithHTTPClient(client *http.Client) *WorkspaceVersionCollectionGetParams {
	return &WorkspaceVersionCollectionGetParams{
		HTTPClient: client,
	}
}

/*
WorkspaceVersionCollectionGetParams contains all the parameters to send to the API endpoint

	for the workspace version collection get operation.

	Typically these are written to a http.Request.
*/
type WorkspaceVersionCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* WorkspaceCreateTime.

	   Filter by workspace.create_time
	*/
	WorkspaceCreateTime *string

	/* WorkspaceDataCollectionCount.

	   Filter by workspace.data_collection_count
	*/
	WorkspaceDataCollectionCount *int64

	/* WorkspaceDescription.

	   Filter by workspace.description
	*/
	WorkspaceDescription *string

	/* WorkspaceEntityCount.

	   Filter by workspace.entity_count
	*/
	WorkspaceEntityCount *int64

	/* WorkspaceErrorsErrorCode.

	   Filter by workspace.errors.error.code
	*/
	WorkspaceErrorsErrorCode *string

	/* WorkspaceErrorsErrorMessage.

	   Filter by workspace.errors.error.message
	*/
	WorkspaceErrorsErrorMessage *string

	/* WorkspaceErrorsErrorTarget.

	   Filter by workspace.errors.error.target
	*/
	WorkspaceErrorsErrorTarget *string

	/* WorkspaceMessage.

	   Filter by workspace.message
	*/
	WorkspaceMessage *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceOwner.

	   Filter by workspace.owner
	*/
	WorkspaceOwner *string

	/* WorkspacePoliciesName.

	   Filter by workspace.policies.name
	*/
	WorkspacePoliciesName *string

	/* WorkspacePoliciesUUID.

	   Filter by workspace.policies.uuid
	*/
	WorkspacePoliciesUUID *string

	/* WorkspacePoliciesVersionUUID.

	   Filter by workspace.policies.version.uuid
	*/
	WorkspacePoliciesVersionUUID *string

	/* WorkspaceRefreshInterval.

	   Filter by workspace.refresh_interval
	*/
	WorkspaceRefreshInterval *string

	/* WorkspaceSpaceAvailable.

	   Filter by workspace.space.available
	*/
	WorkspaceSpaceAvailable *int64

	/* WorkspaceSpaceTotal.

	   Filter by workspace.space.total
	*/
	WorkspaceSpaceTotal *int64

	/* WorkspaceSpaceUsed.

	   Filter by workspace.space.used
	*/
	WorkspaceSpaceUsed *int64

	/* WorkspaceState.

	   Filter by workspace.state
	*/
	WorkspaceState *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	/* WorkspaceVersionJobState.

	   Filter by workspace.version.job.state
	*/
	WorkspaceVersionJobState *string

	/* WorkspaceVersionJobUUID.

	   Filter by workspace.version.job.uuid
	*/
	WorkspaceVersionJobUUID *string

	/* WorkspaceVersionUUID.

	   Filter by workspace.version.uuid
	*/
	WorkspaceVersionUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace version collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceVersionCollectionGetParams) WithDefaults() *WorkspaceVersionCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace version collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceVersionCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := WorkspaceVersionCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithTimeout(timeout time.Duration) *WorkspaceVersionCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithContext(ctx context.Context) *WorkspaceVersionCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithHTTPClient(client *http.Client) *WorkspaceVersionCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithFields(fields []string) *WorkspaceVersionCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithMaxRecords(maxRecords *int64) *WorkspaceVersionCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithOrderBy(orderBy []string) *WorkspaceVersionCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithReturnRecords(returnRecords *bool) *WorkspaceVersionCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *WorkspaceVersionCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithUUID(uuid *string) *WorkspaceVersionCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithWorkspaceCreateTime adds the workspaceCreateTime to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceCreateTime(workspaceCreateTime *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceCreateTime(workspaceCreateTime)
	return o
}

// SetWorkspaceCreateTime adds the workspaceCreateTime to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceCreateTime(workspaceCreateTime *string) {
	o.WorkspaceCreateTime = workspaceCreateTime
}

// WithWorkspaceDataCollectionCount adds the workspaceDataCollectionCount to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceDataCollectionCount(workspaceDataCollectionCount *int64) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceDataCollectionCount(workspaceDataCollectionCount)
	return o
}

// SetWorkspaceDataCollectionCount adds the workspaceDataCollectionCount to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceDataCollectionCount(workspaceDataCollectionCount *int64) {
	o.WorkspaceDataCollectionCount = workspaceDataCollectionCount
}

// WithWorkspaceDescription adds the workspaceDescription to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceDescription(workspaceDescription *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceDescription(workspaceDescription)
	return o
}

// SetWorkspaceDescription adds the workspaceDescription to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceDescription(workspaceDescription *string) {
	o.WorkspaceDescription = workspaceDescription
}

// WithWorkspaceEntityCount adds the workspaceEntityCount to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceEntityCount(workspaceEntityCount *int64) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceEntityCount(workspaceEntityCount)
	return o
}

// SetWorkspaceEntityCount adds the workspaceEntityCount to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceEntityCount(workspaceEntityCount *int64) {
	o.WorkspaceEntityCount = workspaceEntityCount
}

// WithWorkspaceErrorsErrorCode adds the workspaceErrorsErrorCode to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceErrorsErrorCode(workspaceErrorsErrorCode *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceErrorsErrorCode(workspaceErrorsErrorCode)
	return o
}

// SetWorkspaceErrorsErrorCode adds the workspaceErrorsErrorCode to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceErrorsErrorCode(workspaceErrorsErrorCode *string) {
	o.WorkspaceErrorsErrorCode = workspaceErrorsErrorCode
}

// WithWorkspaceErrorsErrorMessage adds the workspaceErrorsErrorMessage to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceErrorsErrorMessage(workspaceErrorsErrorMessage *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceErrorsErrorMessage(workspaceErrorsErrorMessage)
	return o
}

// SetWorkspaceErrorsErrorMessage adds the workspaceErrorsErrorMessage to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceErrorsErrorMessage(workspaceErrorsErrorMessage *string) {
	o.WorkspaceErrorsErrorMessage = workspaceErrorsErrorMessage
}

// WithWorkspaceErrorsErrorTarget adds the workspaceErrorsErrorTarget to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceErrorsErrorTarget(workspaceErrorsErrorTarget *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceErrorsErrorTarget(workspaceErrorsErrorTarget)
	return o
}

// SetWorkspaceErrorsErrorTarget adds the workspaceErrorsErrorTarget to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceErrorsErrorTarget(workspaceErrorsErrorTarget *string) {
	o.WorkspaceErrorsErrorTarget = workspaceErrorsErrorTarget
}

// WithWorkspaceMessage adds the workspaceMessage to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceMessage(workspaceMessage *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceMessage(workspaceMessage)
	return o
}

// SetWorkspaceMessage adds the workspaceMessage to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceMessage(workspaceMessage *string) {
	o.WorkspaceMessage = workspaceMessage
}

// WithWorkspaceName adds the workspaceName to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceName(workspaceName *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceOwner adds the workspaceOwner to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceOwner(workspaceOwner *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceOwner(workspaceOwner)
	return o
}

// SetWorkspaceOwner adds the workspaceOwner to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceOwner(workspaceOwner *string) {
	o.WorkspaceOwner = workspaceOwner
}

// WithWorkspacePoliciesName adds the workspacePoliciesName to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspacePoliciesName(workspacePoliciesName *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspacePoliciesName(workspacePoliciesName)
	return o
}

// SetWorkspacePoliciesName adds the workspacePoliciesName to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspacePoliciesName(workspacePoliciesName *string) {
	o.WorkspacePoliciesName = workspacePoliciesName
}

// WithWorkspacePoliciesUUID adds the workspacePoliciesUUID to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspacePoliciesUUID(workspacePoliciesUUID *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspacePoliciesUUID(workspacePoliciesUUID)
	return o
}

// SetWorkspacePoliciesUUID adds the workspacePoliciesUuid to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspacePoliciesUUID(workspacePoliciesUUID *string) {
	o.WorkspacePoliciesUUID = workspacePoliciesUUID
}

// WithWorkspacePoliciesVersionUUID adds the workspacePoliciesVersionUUID to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspacePoliciesVersionUUID(workspacePoliciesVersionUUID *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspacePoliciesVersionUUID(workspacePoliciesVersionUUID)
	return o
}

// SetWorkspacePoliciesVersionUUID adds the workspacePoliciesVersionUuid to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspacePoliciesVersionUUID(workspacePoliciesVersionUUID *string) {
	o.WorkspacePoliciesVersionUUID = workspacePoliciesVersionUUID
}

// WithWorkspaceRefreshInterval adds the workspaceRefreshInterval to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceRefreshInterval(workspaceRefreshInterval *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceRefreshInterval(workspaceRefreshInterval)
	return o
}

// SetWorkspaceRefreshInterval adds the workspaceRefreshInterval to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceRefreshInterval(workspaceRefreshInterval *string) {
	o.WorkspaceRefreshInterval = workspaceRefreshInterval
}

// WithWorkspaceSpaceAvailable adds the workspaceSpaceAvailable to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceSpaceAvailable(workspaceSpaceAvailable *int64) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceSpaceAvailable(workspaceSpaceAvailable)
	return o
}

// SetWorkspaceSpaceAvailable adds the workspaceSpaceAvailable to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceSpaceAvailable(workspaceSpaceAvailable *int64) {
	o.WorkspaceSpaceAvailable = workspaceSpaceAvailable
}

// WithWorkspaceSpaceTotal adds the workspaceSpaceTotal to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceSpaceTotal(workspaceSpaceTotal *int64) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceSpaceTotal(workspaceSpaceTotal)
	return o
}

// SetWorkspaceSpaceTotal adds the workspaceSpaceTotal to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceSpaceTotal(workspaceSpaceTotal *int64) {
	o.WorkspaceSpaceTotal = workspaceSpaceTotal
}

// WithWorkspaceSpaceUsed adds the workspaceSpaceUsed to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceSpaceUsed(workspaceSpaceUsed *int64) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceSpaceUsed(workspaceSpaceUsed)
	return o
}

// SetWorkspaceSpaceUsed adds the workspaceSpaceUsed to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceSpaceUsed(workspaceSpaceUsed *int64) {
	o.WorkspaceSpaceUsed = workspaceSpaceUsed
}

// WithWorkspaceState adds the workspaceState to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceState(workspaceState *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceState(workspaceState)
	return o
}

// SetWorkspaceState adds the workspaceState to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceState(workspaceState *string) {
	o.WorkspaceState = workspaceState
}

// WithWorkspaceUUID adds the workspaceUUID to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceUUID(workspaceUUID string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WithWorkspaceVersionJobState adds the workspaceVersionJobState to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceVersionJobState(workspaceVersionJobState *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceVersionJobState(workspaceVersionJobState)
	return o
}

// SetWorkspaceVersionJobState adds the workspaceVersionJobState to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceVersionJobState(workspaceVersionJobState *string) {
	o.WorkspaceVersionJobState = workspaceVersionJobState
}

// WithWorkspaceVersionJobUUID adds the workspaceVersionJobUUID to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceVersionJobUUID(workspaceVersionJobUUID *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceVersionJobUUID(workspaceVersionJobUUID)
	return o
}

// SetWorkspaceVersionJobUUID adds the workspaceVersionJobUuid to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceVersionJobUUID(workspaceVersionJobUUID *string) {
	o.WorkspaceVersionJobUUID = workspaceVersionJobUUID
}

// WithWorkspaceVersionUUID adds the workspaceVersionUUID to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) WithWorkspaceVersionUUID(workspaceVersionUUID *string) *WorkspaceVersionCollectionGetParams {
	o.SetWorkspaceVersionUUID(workspaceVersionUUID)
	return o
}

// SetWorkspaceVersionUUID adds the workspaceVersionUuid to the workspace version collection get params
func (o *WorkspaceVersionCollectionGetParams) SetWorkspaceVersionUUID(workspaceVersionUUID *string) {
	o.WorkspaceVersionUUID = workspaceVersionUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceVersionCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceCreateTime != nil {

		// query param workspace.create_time
		var qrWorkspaceCreateTime string

		if o.WorkspaceCreateTime != nil {
			qrWorkspaceCreateTime = *o.WorkspaceCreateTime
		}
		qWorkspaceCreateTime := qrWorkspaceCreateTime
		if qWorkspaceCreateTime != "" {

			if err := r.SetQueryParam("workspace.create_time", qWorkspaceCreateTime); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceDataCollectionCount != nil {

		// query param workspace.data_collection_count
		var qrWorkspaceDataCollectionCount int64

		if o.WorkspaceDataCollectionCount != nil {
			qrWorkspaceDataCollectionCount = *o.WorkspaceDataCollectionCount
		}
		qWorkspaceDataCollectionCount := swag.FormatInt64(qrWorkspaceDataCollectionCount)
		if qWorkspaceDataCollectionCount != "" {

			if err := r.SetQueryParam("workspace.data_collection_count", qWorkspaceDataCollectionCount); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceDescription != nil {

		// query param workspace.description
		var qrWorkspaceDescription string

		if o.WorkspaceDescription != nil {
			qrWorkspaceDescription = *o.WorkspaceDescription
		}
		qWorkspaceDescription := qrWorkspaceDescription
		if qWorkspaceDescription != "" {

			if err := r.SetQueryParam("workspace.description", qWorkspaceDescription); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceEntityCount != nil {

		// query param workspace.entity_count
		var qrWorkspaceEntityCount int64

		if o.WorkspaceEntityCount != nil {
			qrWorkspaceEntityCount = *o.WorkspaceEntityCount
		}
		qWorkspaceEntityCount := swag.FormatInt64(qrWorkspaceEntityCount)
		if qWorkspaceEntityCount != "" {

			if err := r.SetQueryParam("workspace.entity_count", qWorkspaceEntityCount); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceErrorsErrorCode != nil {

		// query param workspace.errors.error.code
		var qrWorkspaceErrorsErrorCode string

		if o.WorkspaceErrorsErrorCode != nil {
			qrWorkspaceErrorsErrorCode = *o.WorkspaceErrorsErrorCode
		}
		qWorkspaceErrorsErrorCode := qrWorkspaceErrorsErrorCode
		if qWorkspaceErrorsErrorCode != "" {

			if err := r.SetQueryParam("workspace.errors.error.code", qWorkspaceErrorsErrorCode); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceErrorsErrorMessage != nil {

		// query param workspace.errors.error.message
		var qrWorkspaceErrorsErrorMessage string

		if o.WorkspaceErrorsErrorMessage != nil {
			qrWorkspaceErrorsErrorMessage = *o.WorkspaceErrorsErrorMessage
		}
		qWorkspaceErrorsErrorMessage := qrWorkspaceErrorsErrorMessage
		if qWorkspaceErrorsErrorMessage != "" {

			if err := r.SetQueryParam("workspace.errors.error.message", qWorkspaceErrorsErrorMessage); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceErrorsErrorTarget != nil {

		// query param workspace.errors.error.target
		var qrWorkspaceErrorsErrorTarget string

		if o.WorkspaceErrorsErrorTarget != nil {
			qrWorkspaceErrorsErrorTarget = *o.WorkspaceErrorsErrorTarget
		}
		qWorkspaceErrorsErrorTarget := qrWorkspaceErrorsErrorTarget
		if qWorkspaceErrorsErrorTarget != "" {

			if err := r.SetQueryParam("workspace.errors.error.target", qWorkspaceErrorsErrorTarget); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceMessage != nil {

		// query param workspace.message
		var qrWorkspaceMessage string

		if o.WorkspaceMessage != nil {
			qrWorkspaceMessage = *o.WorkspaceMessage
		}
		qWorkspaceMessage := qrWorkspaceMessage
		if qWorkspaceMessage != "" {

			if err := r.SetQueryParam("workspace.message", qWorkspaceMessage); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceOwner != nil {

		// query param workspace.owner
		var qrWorkspaceOwner string

		if o.WorkspaceOwner != nil {
			qrWorkspaceOwner = *o.WorkspaceOwner
		}
		qWorkspaceOwner := qrWorkspaceOwner
		if qWorkspaceOwner != "" {

			if err := r.SetQueryParam("workspace.owner", qWorkspaceOwner); err != nil {
				return err
			}
		}
	}

	if o.WorkspacePoliciesName != nil {

		// query param workspace.policies.name
		var qrWorkspacePoliciesName string

		if o.WorkspacePoliciesName != nil {
			qrWorkspacePoliciesName = *o.WorkspacePoliciesName
		}
		qWorkspacePoliciesName := qrWorkspacePoliciesName
		if qWorkspacePoliciesName != "" {

			if err := r.SetQueryParam("workspace.policies.name", qWorkspacePoliciesName); err != nil {
				return err
			}
		}
	}

	if o.WorkspacePoliciesUUID != nil {

		// query param workspace.policies.uuid
		var qrWorkspacePoliciesUUID string

		if o.WorkspacePoliciesUUID != nil {
			qrWorkspacePoliciesUUID = *o.WorkspacePoliciesUUID
		}
		qWorkspacePoliciesUUID := qrWorkspacePoliciesUUID
		if qWorkspacePoliciesUUID != "" {

			if err := r.SetQueryParam("workspace.policies.uuid", qWorkspacePoliciesUUID); err != nil {
				return err
			}
		}
	}

	if o.WorkspacePoliciesVersionUUID != nil {

		// query param workspace.policies.version.uuid
		var qrWorkspacePoliciesVersionUUID string

		if o.WorkspacePoliciesVersionUUID != nil {
			qrWorkspacePoliciesVersionUUID = *o.WorkspacePoliciesVersionUUID
		}
		qWorkspacePoliciesVersionUUID := qrWorkspacePoliciesVersionUUID
		if qWorkspacePoliciesVersionUUID != "" {

			if err := r.SetQueryParam("workspace.policies.version.uuid", qWorkspacePoliciesVersionUUID); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceRefreshInterval != nil {

		// query param workspace.refresh_interval
		var qrWorkspaceRefreshInterval string

		if o.WorkspaceRefreshInterval != nil {
			qrWorkspaceRefreshInterval = *o.WorkspaceRefreshInterval
		}
		qWorkspaceRefreshInterval := qrWorkspaceRefreshInterval
		if qWorkspaceRefreshInterval != "" {

			if err := r.SetQueryParam("workspace.refresh_interval", qWorkspaceRefreshInterval); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceSpaceAvailable != nil {

		// query param workspace.space.available
		var qrWorkspaceSpaceAvailable int64

		if o.WorkspaceSpaceAvailable != nil {
			qrWorkspaceSpaceAvailable = *o.WorkspaceSpaceAvailable
		}
		qWorkspaceSpaceAvailable := swag.FormatInt64(qrWorkspaceSpaceAvailable)
		if qWorkspaceSpaceAvailable != "" {

			if err := r.SetQueryParam("workspace.space.available", qWorkspaceSpaceAvailable); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceSpaceTotal != nil {

		// query param workspace.space.total
		var qrWorkspaceSpaceTotal int64

		if o.WorkspaceSpaceTotal != nil {
			qrWorkspaceSpaceTotal = *o.WorkspaceSpaceTotal
		}
		qWorkspaceSpaceTotal := swag.FormatInt64(qrWorkspaceSpaceTotal)
		if qWorkspaceSpaceTotal != "" {

			if err := r.SetQueryParam("workspace.space.total", qWorkspaceSpaceTotal); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceSpaceUsed != nil {

		// query param workspace.space.used
		var qrWorkspaceSpaceUsed int64

		if o.WorkspaceSpaceUsed != nil {
			qrWorkspaceSpaceUsed = *o.WorkspaceSpaceUsed
		}
		qWorkspaceSpaceUsed := swag.FormatInt64(qrWorkspaceSpaceUsed)
		if qWorkspaceSpaceUsed != "" {

			if err := r.SetQueryParam("workspace.space.used", qWorkspaceSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceState != nil {

		// query param workspace.state
		var qrWorkspaceState string

		if o.WorkspaceState != nil {
			qrWorkspaceState = *o.WorkspaceState
		}
		qWorkspaceState := qrWorkspaceState
		if qWorkspaceState != "" {

			if err := r.SetQueryParam("workspace.state", qWorkspaceState); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if o.WorkspaceVersionJobState != nil {

		// query param workspace.version.job.state
		var qrWorkspaceVersionJobState string

		if o.WorkspaceVersionJobState != nil {
			qrWorkspaceVersionJobState = *o.WorkspaceVersionJobState
		}
		qWorkspaceVersionJobState := qrWorkspaceVersionJobState
		if qWorkspaceVersionJobState != "" {

			if err := r.SetQueryParam("workspace.version.job.state", qWorkspaceVersionJobState); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceVersionJobUUID != nil {

		// query param workspace.version.job.uuid
		var qrWorkspaceVersionJobUUID string

		if o.WorkspaceVersionJobUUID != nil {
			qrWorkspaceVersionJobUUID = *o.WorkspaceVersionJobUUID
		}
		qWorkspaceVersionJobUUID := qrWorkspaceVersionJobUUID
		if qWorkspaceVersionJobUUID != "" {

			if err := r.SetQueryParam("workspace.version.job.uuid", qWorkspaceVersionJobUUID); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceVersionUUID != nil {

		// query param workspace.version.uuid
		var qrWorkspaceVersionUUID string

		if o.WorkspaceVersionUUID != nil {
			qrWorkspaceVersionUUID = *o.WorkspaceVersionUUID
		}
		qWorkspaceVersionUUID := qrWorkspaceVersionUUID
		if qWorkspaceVersionUUID != "" {

			if err := r.SetQueryParam("workspace.version.uuid", qWorkspaceVersionUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWorkspaceVersionCollectionGet binds the parameter fields
func (o *WorkspaceVersionCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamWorkspaceVersionCollectionGet binds the parameter order_by
func (o *WorkspaceVersionCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
