// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWorkspaceVersionDiffCollectionGetParams creates a new WorkspaceVersionDiffCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceVersionDiffCollectionGetParams() *WorkspaceVersionDiffCollectionGetParams {
	return &WorkspaceVersionDiffCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceVersionDiffCollectionGetParamsWithTimeout creates a new WorkspaceVersionDiffCollectionGetParams object
// with the ability to set a timeout on a request.
func NewWorkspaceVersionDiffCollectionGetParamsWithTimeout(timeout time.Duration) *WorkspaceVersionDiffCollectionGetParams {
	return &WorkspaceVersionDiffCollectionGetParams{
		timeout: timeout,
	}
}

// NewWorkspaceVersionDiffCollectionGetParamsWithContext creates a new WorkspaceVersionDiffCollectionGetParams object
// with the ability to set a context for a request.
func NewWorkspaceVersionDiffCollectionGetParamsWithContext(ctx context.Context) *WorkspaceVersionDiffCollectionGetParams {
	return &WorkspaceVersionDiffCollectionGetParams{
		Context: ctx,
	}
}

// NewWorkspaceVersionDiffCollectionGetParamsWithHTTPClient creates a new WorkspaceVersionDiffCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceVersionDiffCollectionGetParamsWithHTTPClient(client *http.Client) *WorkspaceVersionDiffCollectionGetParams {
	return &WorkspaceVersionDiffCollectionGetParams{
		HTTPClient: client,
	}
}

/*
WorkspaceVersionDiffCollectionGetParams contains all the parameters to send to the API endpoint

	for the workspace version diff collection get operation.

	Typically these are written to a http.Request.
*/
type WorkspaceVersionDiffCollectionGetParams struct {

	/* ChangeType.

	   Filter by change_type
	*/
	ChangeType *string

	/* DataSourceName.

	   Filter by data_source.name
	*/
	DataSourceName *string

	/* DataSourceType.

	   Filter by data_source.type
	*/
	DataSourceType *string

	/* DataSourceUUID.

	   Filter by data_source.uuid
	*/
	DataSourceUUID *string

	/* EntitiesEntityType.

	   Filter by entities.entity_type
	*/
	EntitiesEntityType *string

	/* EntitiesName.

	   Filter by entities.name
	*/
	EntitiesName *string

	/* EntitiesUUID.

	   Filter by entities.uuid
	*/
	EntitiesUUID *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* VersionBase.

	   Filter by version.base
	*/
	VersionBase *string

	/* VersionUUID.

	   Filter by version.uuid
	*/
	VersionUUID *string

	/* WorkspaceName.

	   Filter by workspace.name
	*/
	WorkspaceName *string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	/* WorkspaceVersionUUID.

	   Unique identifier of the workspace version.
	*/
	WorkspaceVersionUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace version diff collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceVersionDiffCollectionGetParams) WithDefaults() *WorkspaceVersionDiffCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace version diff collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceVersionDiffCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := WorkspaceVersionDiffCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithTimeout(timeout time.Duration) *WorkspaceVersionDiffCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithContext(ctx context.Context) *WorkspaceVersionDiffCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithHTTPClient(client *http.Client) *WorkspaceVersionDiffCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithChangeType adds the changeType to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithChangeType(changeType *string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetChangeType(changeType)
	return o
}

// SetChangeType adds the changeType to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetChangeType(changeType *string) {
	o.ChangeType = changeType
}

// WithDataSourceName adds the dataSourceName to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithDataSourceName(dataSourceName *string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetDataSourceName(dataSourceName)
	return o
}

// SetDataSourceName adds the dataSourceName to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetDataSourceName(dataSourceName *string) {
	o.DataSourceName = dataSourceName
}

// WithDataSourceType adds the dataSourceType to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithDataSourceType(dataSourceType *string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetDataSourceType(dataSourceType)
	return o
}

// SetDataSourceType adds the dataSourceType to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetDataSourceType(dataSourceType *string) {
	o.DataSourceType = dataSourceType
}

// WithDataSourceUUID adds the dataSourceUUID to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithDataSourceUUID(dataSourceUUID *string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetDataSourceUUID(dataSourceUUID)
	return o
}

// SetDataSourceUUID adds the dataSourceUuid to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetDataSourceUUID(dataSourceUUID *string) {
	o.DataSourceUUID = dataSourceUUID
}

// WithEntitiesEntityType adds the entitiesEntityType to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithEntitiesEntityType(entitiesEntityType *string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetEntitiesEntityType(entitiesEntityType)
	return o
}

// SetEntitiesEntityType adds the entitiesEntityType to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetEntitiesEntityType(entitiesEntityType *string) {
	o.EntitiesEntityType = entitiesEntityType
}

// WithEntitiesName adds the entitiesName to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithEntitiesName(entitiesName *string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetEntitiesName(entitiesName)
	return o
}

// SetEntitiesName adds the entitiesName to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetEntitiesName(entitiesName *string) {
	o.EntitiesName = entitiesName
}

// WithEntitiesUUID adds the entitiesUUID to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithEntitiesUUID(entitiesUUID *string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetEntitiesUUID(entitiesUUID)
	return o
}

// SetEntitiesUUID adds the entitiesUuid to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetEntitiesUUID(entitiesUUID *string) {
	o.EntitiesUUID = entitiesUUID
}

// WithFields adds the fields to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithFields(fields []string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithMaxRecords(maxRecords *int64) *WorkspaceVersionDiffCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithOrderBy(orderBy []string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithReturnRecords(returnRecords *bool) *WorkspaceVersionDiffCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *WorkspaceVersionDiffCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithVersionBase adds the versionBase to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithVersionBase(versionBase *string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetVersionBase(versionBase)
	return o
}

// SetVersionBase adds the versionBase to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetVersionBase(versionBase *string) {
	o.VersionBase = versionBase
}

// WithVersionUUID adds the versionUUID to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithVersionUUID(versionUUID *string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetVersionUUID(versionUUID)
	return o
}

// SetVersionUUID adds the versionUuid to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetVersionUUID(versionUUID *string) {
	o.VersionUUID = versionUUID
}

// WithWorkspaceName adds the workspaceName to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithWorkspaceName(workspaceName *string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetWorkspaceName(workspaceName)
	return o
}

// SetWorkspaceName adds the workspaceName to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetWorkspaceName(workspaceName *string) {
	o.WorkspaceName = workspaceName
}

// WithWorkspaceUUID adds the workspaceUUID to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithWorkspaceUUID(workspaceUUID string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WithWorkspaceVersionUUID adds the workspaceVersionUUID to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) WithWorkspaceVersionUUID(workspaceVersionUUID string) *WorkspaceVersionDiffCollectionGetParams {
	o.SetWorkspaceVersionUUID(workspaceVersionUUID)
	return o
}

// SetWorkspaceVersionUUID adds the workspaceVersionUuid to the workspace version diff collection get params
func (o *WorkspaceVersionDiffCollectionGetParams) SetWorkspaceVersionUUID(workspaceVersionUUID string) {
	o.WorkspaceVersionUUID = workspaceVersionUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceVersionDiffCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ChangeType != nil {

		// query param change_type
		var qrChangeType string

		if o.ChangeType != nil {
			qrChangeType = *o.ChangeType
		}
		qChangeType := qrChangeType
		if qChangeType != "" {

			if err := r.SetQueryParam("change_type", qChangeType); err != nil {
				return err
			}
		}
	}

	if o.DataSourceName != nil {

		// query param data_source.name
		var qrDataSourceName string

		if o.DataSourceName != nil {
			qrDataSourceName = *o.DataSourceName
		}
		qDataSourceName := qrDataSourceName
		if qDataSourceName != "" {

			if err := r.SetQueryParam("data_source.name", qDataSourceName); err != nil {
				return err
			}
		}
	}

	if o.DataSourceType != nil {

		// query param data_source.type
		var qrDataSourceType string

		if o.DataSourceType != nil {
			qrDataSourceType = *o.DataSourceType
		}
		qDataSourceType := qrDataSourceType
		if qDataSourceType != "" {

			if err := r.SetQueryParam("data_source.type", qDataSourceType); err != nil {
				return err
			}
		}
	}

	if o.DataSourceUUID != nil {

		// query param data_source.uuid
		var qrDataSourceUUID string

		if o.DataSourceUUID != nil {
			qrDataSourceUUID = *o.DataSourceUUID
		}
		qDataSourceUUID := qrDataSourceUUID
		if qDataSourceUUID != "" {

			if err := r.SetQueryParam("data_source.uuid", qDataSourceUUID); err != nil {
				return err
			}
		}
	}

	if o.EntitiesEntityType != nil {

		// query param entities.entity_type
		var qrEntitiesEntityType string

		if o.EntitiesEntityType != nil {
			qrEntitiesEntityType = *o.EntitiesEntityType
		}
		qEntitiesEntityType := qrEntitiesEntityType
		if qEntitiesEntityType != "" {

			if err := r.SetQueryParam("entities.entity_type", qEntitiesEntityType); err != nil {
				return err
			}
		}
	}

	if o.EntitiesName != nil {

		// query param entities.name
		var qrEntitiesName string

		if o.EntitiesName != nil {
			qrEntitiesName = *o.EntitiesName
		}
		qEntitiesName := qrEntitiesName
		if qEntitiesName != "" {

			if err := r.SetQueryParam("entities.name", qEntitiesName); err != nil {
				return err
			}
		}
	}

	if o.EntitiesUUID != nil {

		// query param entities.uuid
		var qrEntitiesUUID string

		if o.EntitiesUUID != nil {
			qrEntitiesUUID = *o.EntitiesUUID
		}
		qEntitiesUUID := qrEntitiesUUID
		if qEntitiesUUID != "" {

			if err := r.SetQueryParam("entities.uuid", qEntitiesUUID); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.VersionBase != nil {

		// query param version.base
		var qrVersionBase string

		if o.VersionBase != nil {
			qrVersionBase = *o.VersionBase
		}
		qVersionBase := qrVersionBase
		if qVersionBase != "" {

			if err := r.SetQueryParam("version.base", qVersionBase); err != nil {
				return err
			}
		}
	}

	if o.VersionUUID != nil {

		// query param version.uuid
		var qrVersionUUID string

		if o.VersionUUID != nil {
			qrVersionUUID = *o.VersionUUID
		}
		qVersionUUID := qrVersionUUID
		if qVersionUUID != "" {

			if err := r.SetQueryParam("version.uuid", qVersionUUID); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceName != nil {

		// query param workspace.name
		var qrWorkspaceName string

		if o.WorkspaceName != nil {
			qrWorkspaceName = *o.WorkspaceName
		}
		qWorkspaceName := qrWorkspaceName
		if qWorkspaceName != "" {

			if err := r.SetQueryParam("workspace.name", qWorkspaceName); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	// path param workspace_version.uuid
	if err := r.SetPathParam("workspace_version.uuid", o.WorkspaceVersionUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWorkspaceVersionDiffCollectionGet binds the parameter fields
func (o *WorkspaceVersionDiffCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamWorkspaceVersionDiffCollectionGet binds the parameter order_by
func (o *WorkspaceVersionDiffCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
