// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceVersionDiffCollectionGetReader is a Reader for the WorkspaceVersionDiffCollectionGet structure.
type WorkspaceVersionDiffCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceVersionDiffCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceVersionDiffCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceVersionDiffCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceVersionDiffCollectionGetOK creates a WorkspaceVersionDiffCollectionGetOK with default headers values
func NewWorkspaceVersionDiffCollectionGetOK() *WorkspaceVersionDiffCollectionGetOK {
	return &WorkspaceVersionDiffCollectionGetOK{}
}

/*
WorkspaceVersionDiffCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceVersionDiffCollectionGetOK struct {
	Payload *models.WorkspaceVersionDiffResponse
}

// IsSuccess returns true when this workspace version diff collection get o k response has a 2xx status code
func (o *WorkspaceVersionDiffCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace version diff collection get o k response has a 3xx status code
func (o *WorkspaceVersionDiffCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace version diff collection get o k response has a 4xx status code
func (o *WorkspaceVersionDiffCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace version diff collection get o k response has a 5xx status code
func (o *WorkspaceVersionDiffCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace version diff collection get o k response a status code equal to that given
func (o *WorkspaceVersionDiffCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace version diff collection get o k response
func (o *WorkspaceVersionDiffCollectionGetOK) Code() int {
	return 200
}

func (o *WorkspaceVersionDiffCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/versions/{workspace_version.uuid}/diffs][%d] workspaceVersionDiffCollectionGetOK %s", 200, payload)
}

func (o *WorkspaceVersionDiffCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/versions/{workspace_version.uuid}/diffs][%d] workspaceVersionDiffCollectionGetOK %s", 200, payload)
}

func (o *WorkspaceVersionDiffCollectionGetOK) GetPayload() *models.WorkspaceVersionDiffResponse {
	return o.Payload
}

func (o *WorkspaceVersionDiffCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.WorkspaceVersionDiffResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceVersionDiffCollectionGetDefault creates a WorkspaceVersionDiffCollectionGetDefault with default headers values
func NewWorkspaceVersionDiffCollectionGetDefault(code int) *WorkspaceVersionDiffCollectionGetDefault {
	return &WorkspaceVersionDiffCollectionGetDefault{
		_statusCode: code,
	}
}

/*
WorkspaceVersionDiffCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceVersionDiffCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace version diff collection get default response has a 2xx status code
func (o *WorkspaceVersionDiffCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace version diff collection get default response has a 3xx status code
func (o *WorkspaceVersionDiffCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace version diff collection get default response has a 4xx status code
func (o *WorkspaceVersionDiffCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace version diff collection get default response has a 5xx status code
func (o *WorkspaceVersionDiffCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace version diff collection get default response a status code equal to that given
func (o *WorkspaceVersionDiffCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace version diff collection get default response
func (o *WorkspaceVersionDiffCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceVersionDiffCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/versions/{workspace_version.uuid}/diffs][%d] workspace_version_diff_collection_get default %s", o._statusCode, payload)
}

func (o *WorkspaceVersionDiffCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/versions/{workspace_version.uuid}/diffs][%d] workspace_version_diff_collection_get default %s", o._statusCode, payload)
}

func (o *WorkspaceVersionDiffCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceVersionDiffCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
