// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewWorkspaceVersionDiffCreateParams creates a new WorkspaceVersionDiffCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceVersionDiffCreateParams() *WorkspaceVersionDiffCreateParams {
	return &WorkspaceVersionDiffCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceVersionDiffCreateParamsWithTimeout creates a new WorkspaceVersionDiffCreateParams object
// with the ability to set a timeout on a request.
func NewWorkspaceVersionDiffCreateParamsWithTimeout(timeout time.Duration) *WorkspaceVersionDiffCreateParams {
	return &WorkspaceVersionDiffCreateParams{
		timeout: timeout,
	}
}

// NewWorkspaceVersionDiffCreateParamsWithContext creates a new WorkspaceVersionDiffCreateParams object
// with the ability to set a context for a request.
func NewWorkspaceVersionDiffCreateParamsWithContext(ctx context.Context) *WorkspaceVersionDiffCreateParams {
	return &WorkspaceVersionDiffCreateParams{
		Context: ctx,
	}
}

// NewWorkspaceVersionDiffCreateParamsWithHTTPClient creates a new WorkspaceVersionDiffCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceVersionDiffCreateParamsWithHTTPClient(client *http.Client) *WorkspaceVersionDiffCreateParams {
	return &WorkspaceVersionDiffCreateParams{
		HTTPClient: client,
	}
}

/*
WorkspaceVersionDiffCreateParams contains all the parameters to send to the API endpoint

	for the workspace version diff create operation.

	Typically these are written to a http.Request.
*/
type WorkspaceVersionDiffCreateParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Info.

	   Workspace version diff specification.
	*/
	Info *models.WorkspaceVersionDiff

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	/* WorkspaceVersionUUID.

	   Unique identifier of the workspace version.
	*/
	WorkspaceVersionUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace version diff create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceVersionDiffCreateParams) WithDefaults() *WorkspaceVersionDiffCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace version diff create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceVersionDiffCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := WorkspaceVersionDiffCreateParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) WithTimeout(timeout time.Duration) *WorkspaceVersionDiffCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) WithContext(ctx context.Context) *WorkspaceVersionDiffCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) WithHTTPClient(client *http.Client) *WorkspaceVersionDiffCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) WithFields(fields []string) *WorkspaceVersionDiffCreateParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInfo adds the info to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) WithInfo(info *models.WorkspaceVersionDiff) *WorkspaceVersionDiffCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) SetInfo(info *models.WorkspaceVersionDiff) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) WithReturnRecords(returnRecords *bool) *WorkspaceVersionDiffCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) WithReturnTimeout(returnTimeout *int64) *WorkspaceVersionDiffCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithWorkspaceUUID adds the workspaceUUID to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) WithWorkspaceUUID(workspaceUUID string) *WorkspaceVersionDiffCreateParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WithWorkspaceVersionUUID adds the workspaceVersionUUID to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) WithWorkspaceVersionUUID(workspaceVersionUUID string) *WorkspaceVersionDiffCreateParams {
	o.SetWorkspaceVersionUUID(workspaceVersionUUID)
	return o
}

// SetWorkspaceVersionUUID adds the workspaceVersionUuid to the workspace version diff create params
func (o *WorkspaceVersionDiffCreateParams) SetWorkspaceVersionUUID(workspaceVersionUUID string) {
	o.WorkspaceVersionUUID = workspaceVersionUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceVersionDiffCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	// path param workspace_version.uuid
	if err := r.SetPathParam("workspace_version.uuid", o.WorkspaceVersionUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWorkspaceVersionDiffCreate binds the parameter fields
func (o *WorkspaceVersionDiffCreateParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
