// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceVersionDiffCreateReader is a Reader for the WorkspaceVersionDiffCreate structure.
type WorkspaceVersionDiffCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceVersionDiffCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewWorkspaceVersionDiffCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewWorkspaceVersionDiffCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceVersionDiffCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceVersionDiffCreateCreated creates a WorkspaceVersionDiffCreateCreated with default headers values
func NewWorkspaceVersionDiffCreateCreated() *WorkspaceVersionDiffCreateCreated {
	return &WorkspaceVersionDiffCreateCreated{}
}

/*
WorkspaceVersionDiffCreateCreated describes a response with status code 201, with default header values.

Created
*/
type WorkspaceVersionDiffCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.WorkspaceVersionDiffResponse
}

// IsSuccess returns true when this workspace version diff create created response has a 2xx status code
func (o *WorkspaceVersionDiffCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace version diff create created response has a 3xx status code
func (o *WorkspaceVersionDiffCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace version diff create created response has a 4xx status code
func (o *WorkspaceVersionDiffCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace version diff create created response has a 5xx status code
func (o *WorkspaceVersionDiffCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace version diff create created response a status code equal to that given
func (o *WorkspaceVersionDiffCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the workspace version diff create created response
func (o *WorkspaceVersionDiffCreateCreated) Code() int {
	return 201
}

func (o *WorkspaceVersionDiffCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/versions/{workspace_version.uuid}/diffs][%d] workspaceVersionDiffCreateCreated %s", 201, payload)
}

func (o *WorkspaceVersionDiffCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/versions/{workspace_version.uuid}/diffs][%d] workspaceVersionDiffCreateCreated %s", 201, payload)
}

func (o *WorkspaceVersionDiffCreateCreated) GetPayload() *models.WorkspaceVersionDiffResponse {
	return o.Payload
}

func (o *WorkspaceVersionDiffCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.WorkspaceVersionDiffResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceVersionDiffCreateAccepted creates a WorkspaceVersionDiffCreateAccepted with default headers values
func NewWorkspaceVersionDiffCreateAccepted() *WorkspaceVersionDiffCreateAccepted {
	return &WorkspaceVersionDiffCreateAccepted{}
}

/*
WorkspaceVersionDiffCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type WorkspaceVersionDiffCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DataEngineJobReference
}

// IsSuccess returns true when this workspace version diff create accepted response has a 2xx status code
func (o *WorkspaceVersionDiffCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace version diff create accepted response has a 3xx status code
func (o *WorkspaceVersionDiffCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace version diff create accepted response has a 4xx status code
func (o *WorkspaceVersionDiffCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace version diff create accepted response has a 5xx status code
func (o *WorkspaceVersionDiffCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace version diff create accepted response a status code equal to that given
func (o *WorkspaceVersionDiffCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the workspace version diff create accepted response
func (o *WorkspaceVersionDiffCreateAccepted) Code() int {
	return 202
}

func (o *WorkspaceVersionDiffCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/versions/{workspace_version.uuid}/diffs][%d] workspaceVersionDiffCreateAccepted %s", 202, payload)
}

func (o *WorkspaceVersionDiffCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/versions/{workspace_version.uuid}/diffs][%d] workspaceVersionDiffCreateAccepted %s", 202, payload)
}

func (o *WorkspaceVersionDiffCreateAccepted) GetPayload() *models.DataEngineJobReference {
	return o.Payload
}

func (o *WorkspaceVersionDiffCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DataEngineJobReference)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceVersionDiffCreateDefault creates a WorkspaceVersionDiffCreateDefault with default headers values
func NewWorkspaceVersionDiffCreateDefault(code int) *WorkspaceVersionDiffCreateDefault {
	return &WorkspaceVersionDiffCreateDefault{
		_statusCode: code,
	}
}

/*
WorkspaceVersionDiffCreateDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceVersionDiffCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace version diff create default response has a 2xx status code
func (o *WorkspaceVersionDiffCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace version diff create default response has a 3xx status code
func (o *WorkspaceVersionDiffCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace version diff create default response has a 4xx status code
func (o *WorkspaceVersionDiffCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace version diff create default response has a 5xx status code
func (o *WorkspaceVersionDiffCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace version diff create default response a status code equal to that given
func (o *WorkspaceVersionDiffCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace version diff create default response
func (o *WorkspaceVersionDiffCreateDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceVersionDiffCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/versions/{workspace_version.uuid}/diffs][%d] workspace_version_diff_create default %s", o._statusCode, payload)
}

func (o *WorkspaceVersionDiffCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /data-engine/workspaces/{workspace.uuid}/versions/{workspace_version.uuid}/diffs][%d] workspace_version_diff_create default %s", o._statusCode, payload)
}

func (o *WorkspaceVersionDiffCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceVersionDiffCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
