// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWorkspaceVersionGetParams creates a new WorkspaceVersionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWorkspaceVersionGetParams() *WorkspaceVersionGetParams {
	return &WorkspaceVersionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWorkspaceVersionGetParamsWithTimeout creates a new WorkspaceVersionGetParams object
// with the ability to set a timeout on a request.
func NewWorkspaceVersionGetParamsWithTimeout(timeout time.Duration) *WorkspaceVersionGetParams {
	return &WorkspaceVersionGetParams{
		timeout: timeout,
	}
}

// NewWorkspaceVersionGetParamsWithContext creates a new WorkspaceVersionGetParams object
// with the ability to set a context for a request.
func NewWorkspaceVersionGetParamsWithContext(ctx context.Context) *WorkspaceVersionGetParams {
	return &WorkspaceVersionGetParams{
		Context: ctx,
	}
}

// NewWorkspaceVersionGetParamsWithHTTPClient creates a new WorkspaceVersionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewWorkspaceVersionGetParamsWithHTTPClient(client *http.Client) *WorkspaceVersionGetParams {
	return &WorkspaceVersionGetParams{
		HTTPClient: client,
	}
}

/*
WorkspaceVersionGetParams contains all the parameters to send to the API endpoint

	for the workspace version get operation.

	Typically these are written to a http.Request.
*/
type WorkspaceVersionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Unique identifier of the workspace version.
	*/
	UUID string

	/* WorkspaceUUID.

	   Unique identifier of the workspace.
	*/
	WorkspaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the workspace version get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceVersionGetParams) WithDefaults() *WorkspaceVersionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the workspace version get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WorkspaceVersionGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the workspace version get params
func (o *WorkspaceVersionGetParams) WithTimeout(timeout time.Duration) *WorkspaceVersionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the workspace version get params
func (o *WorkspaceVersionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the workspace version get params
func (o *WorkspaceVersionGetParams) WithContext(ctx context.Context) *WorkspaceVersionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the workspace version get params
func (o *WorkspaceVersionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the workspace version get params
func (o *WorkspaceVersionGetParams) WithHTTPClient(client *http.Client) *WorkspaceVersionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the workspace version get params
func (o *WorkspaceVersionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the workspace version get params
func (o *WorkspaceVersionGetParams) WithFields(fields []string) *WorkspaceVersionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the workspace version get params
func (o *WorkspaceVersionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the workspace version get params
func (o *WorkspaceVersionGetParams) WithUUID(uuid string) *WorkspaceVersionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the workspace version get params
func (o *WorkspaceVersionGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WithWorkspaceUUID adds the workspaceUUID to the workspace version get params
func (o *WorkspaceVersionGetParams) WithWorkspaceUUID(workspaceUUID string) *WorkspaceVersionGetParams {
	o.SetWorkspaceUUID(workspaceUUID)
	return o
}

// SetWorkspaceUUID adds the workspaceUuid to the workspace version get params
func (o *WorkspaceVersionGetParams) SetWorkspaceUUID(workspaceUUID string) {
	o.WorkspaceUUID = workspaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *WorkspaceVersionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	// path param workspace.uuid
	if err := r.SetPathParam("workspace.uuid", o.WorkspaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWorkspaceVersionGet binds the parameter fields
func (o *WorkspaceVersionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
