// Code generated by go-swagger; DO NOT EDIT.

package data_engine

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// WorkspaceVersionGetReader is a Reader for the WorkspaceVersionGet structure.
type WorkspaceVersionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WorkspaceVersionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWorkspaceVersionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWorkspaceVersionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWorkspaceVersionGetOK creates a WorkspaceVersionGetOK with default headers values
func NewWorkspaceVersionGetOK() *WorkspaceVersionGetOK {
	return &WorkspaceVersionGetOK{}
}

/*
WorkspaceVersionGetOK describes a response with status code 200, with default header values.

OK
*/
type WorkspaceVersionGetOK struct {
	Payload *models.WorkspaceVersion
}

// IsSuccess returns true when this workspace version get o k response has a 2xx status code
func (o *WorkspaceVersionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this workspace version get o k response has a 3xx status code
func (o *WorkspaceVersionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this workspace version get o k response has a 4xx status code
func (o *WorkspaceVersionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this workspace version get o k response has a 5xx status code
func (o *WorkspaceVersionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this workspace version get o k response a status code equal to that given
func (o *WorkspaceVersionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the workspace version get o k response
func (o *WorkspaceVersionGetOK) Code() int {
	return 200
}

func (o *WorkspaceVersionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/versions/{uuid}][%d] workspaceVersionGetOK %s", 200, payload)
}

func (o *WorkspaceVersionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/versions/{uuid}][%d] workspaceVersionGetOK %s", 200, payload)
}

func (o *WorkspaceVersionGetOK) GetPayload() *models.WorkspaceVersion {
	return o.Payload
}

func (o *WorkspaceVersionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.WorkspaceVersion)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWorkspaceVersionGetDefault creates a WorkspaceVersionGetDefault with default headers values
func NewWorkspaceVersionGetDefault(code int) *WorkspaceVersionGetDefault {
	return &WorkspaceVersionGetDefault{
		_statusCode: code,
	}
}

/*
WorkspaceVersionGetDefault describes a response with status code -1, with default header values.

Error
*/
type WorkspaceVersionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this workspace version get default response has a 2xx status code
func (o *WorkspaceVersionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this workspace version get default response has a 3xx status code
func (o *WorkspaceVersionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this workspace version get default response has a 4xx status code
func (o *WorkspaceVersionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this workspace version get default response has a 5xx status code
func (o *WorkspaceVersionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this workspace version get default response a status code equal to that given
func (o *WorkspaceVersionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the workspace version get default response
func (o *WorkspaceVersionGetDefault) Code() int {
	return o._statusCode
}

func (o *WorkspaceVersionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/versions/{uuid}][%d] workspace_version_get default %s", o._statusCode, payload)
}

func (o *WorkspaceVersionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /data-engine/workspaces/{workspace.uuid}/versions/{uuid}][%d] workspace_version_get default %s", o._statusCode, payload)
}

func (o *WorkspaceVersionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *WorkspaceVersionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
