// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new dcn API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for dcn API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	DcnClusterCreate(params *DcnClusterCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterCreateCreated, *DcnClusterCreateAccepted, error)

	DcnClusterDelete(params *DcnClusterDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterDeleteOK, *DcnClusterDeleteAccepted, error)

	DcnClusterGet(params *DcnClusterGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterGetOK, error)

	DcnClusterModify(params *DcnClusterModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterModifyOK, *DcnClusterModifyAccepted, error)

	DcnClusterSoftwarePackageCollectionGet(params *DcnClusterSoftwarePackageCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterSoftwarePackageCollectionGetOK, error)

	DcnClusterSoftwarePackageGet(params *DcnClusterSoftwarePackageGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterSoftwarePackageGetOK, error)

	DcnClusterSoftwarePackageModify(params *DcnClusterSoftwarePackageModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterSoftwarePackageModifyOK, error)

	DcnClusterSoftwarePackageModifyCollection(params *DcnClusterSoftwarePackageModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterSoftwarePackageModifyCollectionOK, error)

	DcnClusterSoftwarePackageUpload(params *DcnClusterSoftwarePackageUploadParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterSoftwarePackageUploadOK, error)

	DcnNodeCollectionGet(params *DcnNodeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeCollectionGetOK, error)

	DcnNodeCreate(params *DcnNodeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeCreateCreated, *DcnNodeCreateAccepted, error)

	DcnNodeDelete(params *DcnNodeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeDeleteOK, *DcnNodeDeleteAccepted, error)

	DcnNodeDeleteCollection(params *DcnNodeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeDeleteCollectionOK, *DcnNodeDeleteCollectionAccepted, error)

	DcnNodeGet(params *DcnNodeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeGetOK, error)

	DcnNodeMetricsCollectionGet(params *DcnNodeMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeMetricsCollectionGetOK, error)

	DcnNodeModify(params *DcnNodeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeModifyOK, *DcnNodeModifyAccepted, error)

	DcnNodeModifyCollection(params *DcnNodeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeModifyCollectionOK, *DcnNodeModifyCollectionAccepted, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	DcnClusterCreate Creates a data compute cluster.

### Required properties
* `nodes`
* `network_pool`
*/
func (a *Client) DcnClusterCreate(params *DcnClusterCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterCreateCreated, *DcnClusterCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnClusterCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_cluster_create",
		Method:             "POST",
		PathPattern:        "/dcn/cluster",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnClusterCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DcnClusterCreateCreated:
		return value, nil, nil
	case *DcnClusterCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnClusterCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DcnClusterDelete Deletes a compute cluster.
*/
func (a *Client) DcnClusterDelete(params *DcnClusterDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterDeleteOK, *DcnClusterDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnClusterDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_cluster_delete",
		Method:             "DELETE",
		PathPattern:        "/dcn/cluster",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnClusterDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DcnClusterDeleteOK:
		return value, nil, nil
	case *DcnClusterDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnClusterDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DcnClusterGet Retrieves the compute cluster configuration.
*/
func (a *Client) DcnClusterGet(params *DcnClusterGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnClusterGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_cluster_get",
		Method:             "GET",
		PathPattern:        "/dcn/cluster",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnClusterGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnClusterGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnClusterGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DcnClusterModify Modifies a compute cluster.
*/
func (a *Client) DcnClusterModify(params *DcnClusterModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterModifyOK, *DcnClusterModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnClusterModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_cluster_modify",
		Method:             "PATCH",
		PathPattern:        "/dcn/cluster",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnClusterModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DcnClusterModifyOK:
		return value, nil, nil
	case *DcnClusterModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnClusterModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DcnClusterSoftwarePackageCollectionGet Retrieves the DCN software packages on the ONTAP cluster.
*/
func (a *Client) DcnClusterSoftwarePackageCollectionGet(params *DcnClusterSoftwarePackageCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterSoftwarePackageCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnClusterSoftwarePackageCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_cluster_software_package_collection_get",
		Method:             "GET",
		PathPattern:        "/dcn/cluster/software/packages",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnClusterSoftwarePackageCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnClusterSoftwarePackageCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnClusterSoftwarePackageCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DcnClusterSoftwarePackageGet Retrieves the DCN software package information for a specified package UUID.
*/
func (a *Client) DcnClusterSoftwarePackageGet(params *DcnClusterSoftwarePackageGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterSoftwarePackageGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnClusterSoftwarePackageGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_cluster_software_package_get",
		Method:             "GET",
		PathPattern:        "/dcn/cluster/software/packages/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnClusterSoftwarePackageGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnClusterSoftwarePackageGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnClusterSoftwarePackageGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DcnClusterSoftwarePackageModify Triggers an update of the DCN cluster with the previously uploaded DCN software.

Important note:
  - Setting 'staged' to true triggers the DCN cluster upgrade.
*/
func (a *Client) DcnClusterSoftwarePackageModify(params *DcnClusterSoftwarePackageModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterSoftwarePackageModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnClusterSoftwarePackageModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_cluster_software_package_modify",
		Method:             "PATCH",
		PathPattern:        "/dcn/cluster/software/packages/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnClusterSoftwarePackageModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnClusterSoftwarePackageModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnClusterSoftwarePackageModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DcnClusterSoftwarePackageModifyCollection dcn cluster software package modify collection API
*/
func (a *Client) DcnClusterSoftwarePackageModifyCollection(params *DcnClusterSoftwarePackageModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterSoftwarePackageModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnClusterSoftwarePackageModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_cluster_software_package_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/dcn/cluster/software/packages",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnClusterSoftwarePackageModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnClusterSoftwarePackageModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnClusterSoftwarePackageModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DcnClusterSoftwarePackageUpload Creates the DCN software package on the ONTAP cluster.
*/
func (a *Client) DcnClusterSoftwarePackageUpload(params *DcnClusterSoftwarePackageUploadParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterSoftwarePackageUploadOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnClusterSoftwarePackageUploadParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_cluster_software_package_upload",
		Method:             "POST",
		PathPattern:        "/dcn/cluster/software/upload",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnClusterSoftwarePackageUploadReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnClusterSoftwarePackageUploadOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnClusterSoftwarePackageUploadDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DcnNodeCollectionGet Retrieves a list of data compute nodes.
*/
func (a *Client) DcnNodeCollectionGet(params *DcnNodeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnNodeCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_node_collection_get",
		Method:             "GET",
		PathPattern:        "/dcn/cluster/nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnNodeCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnNodeCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnNodeCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DcnNodeCreate Adds one or more compute nodes to the compute cluster.

### Required properties
* `serial_number`
### Optional properties
* `name`
If a name is not provided it is automatically generated.
*/
func (a *Client) DcnNodeCreate(params *DcnNodeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeCreateCreated, *DcnNodeCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnNodeCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_node_create",
		Method:             "POST",
		PathPattern:        "/dcn/cluster/nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnNodeCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DcnNodeCreateCreated:
		return value, nil, nil
	case *DcnNodeCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnNodeCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DcnNodeDelete Deletes the node.  This is effectively a factory reset.
*/
func (a *Client) DcnNodeDelete(params *DcnNodeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeDeleteOK, *DcnNodeDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnNodeDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_node_delete",
		Method:             "DELETE",
		PathPattern:        "/dcn/cluster/nodes/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnNodeDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DcnNodeDeleteOK:
		return value, nil, nil
	case *DcnNodeDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnNodeDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DcnNodeDeleteCollection dcn node delete collection API
*/
func (a *Client) DcnNodeDeleteCollection(params *DcnNodeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeDeleteCollectionOK, *DcnNodeDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnNodeDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_node_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/dcn/cluster/nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnNodeDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DcnNodeDeleteCollectionOK:
		return value, nil, nil
	case *DcnNodeDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnNodeDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DcnNodeGet Retrieves the node configuration and status.
*/
func (a *Client) DcnNodeGet(params *DcnNodeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnNodeGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_node_get",
		Method:             "GET",
		PathPattern:        "/dcn/cluster/nodes/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnNodeGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnNodeGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnNodeGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DcnNodeMetricsCollectionGet Retrieves historical performance metrics for a node.
*/
func (a *Client) DcnNodeMetricsCollectionGet(params *DcnNodeMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeMetricsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnNodeMetricsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_node_metrics_collection_get",
		Method:             "GET",
		PathPattern:        "/dcn/cluster/nodes/{node.uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnNodeMetricsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnNodeMetricsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnNodeMetricsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DcnNodeModify Modifies a compute node.

### Required properties
* `uuid` - UUID for the compute node instance
*/
func (a *Client) DcnNodeModify(params *DcnNodeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeModifyOK, *DcnNodeModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnNodeModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_node_modify",
		Method:             "PATCH",
		PathPattern:        "/dcn/cluster/nodes/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnNodeModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DcnNodeModifyOK:
		return value, nil, nil
	case *DcnNodeModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnNodeModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DcnNodeModifyCollection dcn node modify collection API
*/
func (a *Client) DcnNodeModifyCollection(params *DcnNodeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeModifyCollectionOK, *DcnNodeModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnNodeModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_node_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/dcn/cluster/nodes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnNodeModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *DcnNodeModifyCollectionOK:
		return value, nil, nil
	case *DcnNodeModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnNodeModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
