// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDcnClusterCreateParams creates a new DcnClusterCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDcnClusterCreateParams() *DcnClusterCreateParams {
	return &DcnClusterCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDcnClusterCreateParamsWithTimeout creates a new DcnClusterCreateParams object
// with the ability to set a timeout on a request.
func NewDcnClusterCreateParamsWithTimeout(timeout time.Duration) *DcnClusterCreateParams {
	return &DcnClusterCreateParams{
		timeout: timeout,
	}
}

// NewDcnClusterCreateParamsWithContext creates a new DcnClusterCreateParams object
// with the ability to set a context for a request.
func NewDcnClusterCreateParamsWithContext(ctx context.Context) *DcnClusterCreateParams {
	return &DcnClusterCreateParams{
		Context: ctx,
	}
}

// NewDcnClusterCreateParamsWithHTTPClient creates a new DcnClusterCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewDcnClusterCreateParamsWithHTTPClient(client *http.Client) *DcnClusterCreateParams {
	return &DcnClusterCreateParams{
		HTTPClient: client,
	}
}

/*
DcnClusterCreateParams contains all the parameters to send to the API endpoint

	for the dcn cluster create operation.

	Typically these are written to a http.Request.
*/
type DcnClusterCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.DcnCluster

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the dcn cluster create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DcnClusterCreateParams) WithDefaults() *DcnClusterCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the dcn cluster create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DcnClusterCreateParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := DcnClusterCreateParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the dcn cluster create params
func (o *DcnClusterCreateParams) WithTimeout(timeout time.Duration) *DcnClusterCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the dcn cluster create params
func (o *DcnClusterCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the dcn cluster create params
func (o *DcnClusterCreateParams) WithContext(ctx context.Context) *DcnClusterCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the dcn cluster create params
func (o *DcnClusterCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the dcn cluster create params
func (o *DcnClusterCreateParams) WithHTTPClient(client *http.Client) *DcnClusterCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the dcn cluster create params
func (o *DcnClusterCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the dcn cluster create params
func (o *DcnClusterCreateParams) WithInfo(info *models.DcnCluster) *DcnClusterCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the dcn cluster create params
func (o *DcnClusterCreateParams) SetInfo(info *models.DcnCluster) {
	o.Info = info
}

// WithReturnTimeout adds the returnTimeout to the dcn cluster create params
func (o *DcnClusterCreateParams) WithReturnTimeout(returnTimeout *int64) *DcnClusterCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the dcn cluster create params
func (o *DcnClusterCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *DcnClusterCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
