// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnClusterCreateReader is a Reader for the DcnClusterCreate structure.
type DcnClusterCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnClusterCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewDcnClusterCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDcnClusterCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnClusterCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnClusterCreateCreated creates a DcnClusterCreateCreated with default headers values
func NewDcnClusterCreateCreated() *DcnClusterCreateCreated {
	return &DcnClusterCreateCreated{}
}

/*
DcnClusterCreateCreated describes a response with status code 201, with default header values.

Created
*/
type DcnClusterCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DcnClusterJobLinkResponse
}

// IsSuccess returns true when this dcn cluster create created response has a 2xx status code
func (o *DcnClusterCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn cluster create created response has a 3xx status code
func (o *DcnClusterCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn cluster create created response has a 4xx status code
func (o *DcnClusterCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn cluster create created response has a 5xx status code
func (o *DcnClusterCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn cluster create created response a status code equal to that given
func (o *DcnClusterCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the dcn cluster create created response
func (o *DcnClusterCreateCreated) Code() int {
	return 201
}

func (o *DcnClusterCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster][%d] dcnClusterCreateCreated %s", 201, payload)
}

func (o *DcnClusterCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster][%d] dcnClusterCreateCreated %s", 201, payload)
}

func (o *DcnClusterCreateCreated) GetPayload() *models.DcnClusterJobLinkResponse {
	return o.Payload
}

func (o *DcnClusterCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DcnClusterJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnClusterCreateAccepted creates a DcnClusterCreateAccepted with default headers values
func NewDcnClusterCreateAccepted() *DcnClusterCreateAccepted {
	return &DcnClusterCreateAccepted{}
}

/*
DcnClusterCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DcnClusterCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.DcnClusterJobLinkResponse
}

// IsSuccess returns true when this dcn cluster create accepted response has a 2xx status code
func (o *DcnClusterCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn cluster create accepted response has a 3xx status code
func (o *DcnClusterCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn cluster create accepted response has a 4xx status code
func (o *DcnClusterCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn cluster create accepted response has a 5xx status code
func (o *DcnClusterCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn cluster create accepted response a status code equal to that given
func (o *DcnClusterCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the dcn cluster create accepted response
func (o *DcnClusterCreateAccepted) Code() int {
	return 202
}

func (o *DcnClusterCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster][%d] dcnClusterCreateAccepted %s", 202, payload)
}

func (o *DcnClusterCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster][%d] dcnClusterCreateAccepted %s", 202, payload)
}

func (o *DcnClusterCreateAccepted) GetPayload() *models.DcnClusterJobLinkResponse {
	return o.Payload
}

func (o *DcnClusterCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.DcnClusterJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnClusterCreateDefault creates a DcnClusterCreateDefault with default headers values
func NewDcnClusterCreateDefault(code int) *DcnClusterCreateDefault {
	return &DcnClusterCreateDefault{
		_statusCode: code,
	}
}

/*
DcnClusterCreateDefault describes a response with status code -1, with default header values.

Error
*/
type DcnClusterCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn cluster create default response has a 2xx status code
func (o *DcnClusterCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn cluster create default response has a 3xx status code
func (o *DcnClusterCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn cluster create default response has a 4xx status code
func (o *DcnClusterCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn cluster create default response has a 5xx status code
func (o *DcnClusterCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn cluster create default response a status code equal to that given
func (o *DcnClusterCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn cluster create default response
func (o *DcnClusterCreateDefault) Code() int {
	return o._statusCode
}

func (o *DcnClusterCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster][%d] dcn_cluster_create default %s", o._statusCode, payload)
}

func (o *DcnClusterCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dcn/cluster][%d] dcn_cluster_create default %s", o._statusCode, payload)
}

func (o *DcnClusterCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnClusterCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
