// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnClusterDeleteReader is a Reader for the DcnClusterDelete structure.
type DcnClusterDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnClusterDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnClusterDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDcnClusterDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnClusterDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnClusterDeleteOK creates a DcnClusterDeleteOK with default headers values
func NewDcnClusterDeleteOK() *DcnClusterDeleteOK {
	return &DcnClusterDeleteOK{}
}

/*
DcnClusterDeleteOK describes a response with status code 200, with default header values.

OK
*/
type DcnClusterDeleteOK struct {
	Payload *models.DcnClusterJobLinkResponse
}

// IsSuccess returns true when this dcn cluster delete o k response has a 2xx status code
func (o *DcnClusterDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn cluster delete o k response has a 3xx status code
func (o *DcnClusterDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn cluster delete o k response has a 4xx status code
func (o *DcnClusterDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn cluster delete o k response has a 5xx status code
func (o *DcnClusterDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn cluster delete o k response a status code equal to that given
func (o *DcnClusterDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn cluster delete o k response
func (o *DcnClusterDeleteOK) Code() int {
	return 200
}

func (o *DcnClusterDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster][%d] dcnClusterDeleteOK %s", 200, payload)
}

func (o *DcnClusterDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster][%d] dcnClusterDeleteOK %s", 200, payload)
}

func (o *DcnClusterDeleteOK) GetPayload() *models.DcnClusterJobLinkResponse {
	return o.Payload
}

func (o *DcnClusterDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnClusterJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnClusterDeleteAccepted creates a DcnClusterDeleteAccepted with default headers values
func NewDcnClusterDeleteAccepted() *DcnClusterDeleteAccepted {
	return &DcnClusterDeleteAccepted{}
}

/*
DcnClusterDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DcnClusterDeleteAccepted struct {
	Payload *models.DcnClusterJobLinkResponse
}

// IsSuccess returns true when this dcn cluster delete accepted response has a 2xx status code
func (o *DcnClusterDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn cluster delete accepted response has a 3xx status code
func (o *DcnClusterDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn cluster delete accepted response has a 4xx status code
func (o *DcnClusterDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn cluster delete accepted response has a 5xx status code
func (o *DcnClusterDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn cluster delete accepted response a status code equal to that given
func (o *DcnClusterDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the dcn cluster delete accepted response
func (o *DcnClusterDeleteAccepted) Code() int {
	return 202
}

func (o *DcnClusterDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster][%d] dcnClusterDeleteAccepted %s", 202, payload)
}

func (o *DcnClusterDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster][%d] dcnClusterDeleteAccepted %s", 202, payload)
}

func (o *DcnClusterDeleteAccepted) GetPayload() *models.DcnClusterJobLinkResponse {
	return o.Payload
}

func (o *DcnClusterDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnClusterJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnClusterDeleteDefault creates a DcnClusterDeleteDefault with default headers values
func NewDcnClusterDeleteDefault(code int) *DcnClusterDeleteDefault {
	return &DcnClusterDeleteDefault{
		_statusCode: code,
	}
}

/*
DcnClusterDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type DcnClusterDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn cluster delete default response has a 2xx status code
func (o *DcnClusterDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn cluster delete default response has a 3xx status code
func (o *DcnClusterDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn cluster delete default response has a 4xx status code
func (o *DcnClusterDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn cluster delete default response has a 5xx status code
func (o *DcnClusterDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn cluster delete default response a status code equal to that given
func (o *DcnClusterDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn cluster delete default response
func (o *DcnClusterDeleteDefault) Code() int {
	return o._statusCode
}

func (o *DcnClusterDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster][%d] dcn_cluster_delete default %s", o._statusCode, payload)
}

func (o *DcnClusterDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dcn/cluster][%d] dcn_cluster_delete default %s", o._statusCode, payload)
}

func (o *DcnClusterDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnClusterDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
