// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnClusterGetReader is a Reader for the DcnClusterGet structure.
type DcnClusterGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnClusterGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnClusterGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnClusterGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnClusterGetOK creates a DcnClusterGetOK with default headers values
func NewDcnClusterGetOK() *DcnClusterGetOK {
	return &DcnClusterGetOK{}
}

/*
DcnClusterGetOK describes a response with status code 200, with default header values.

OK
*/
type DcnClusterGetOK struct {
	Payload *models.DcnCluster
}

// IsSuccess returns true when this dcn cluster get o k response has a 2xx status code
func (o *DcnClusterGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn cluster get o k response has a 3xx status code
func (o *DcnClusterGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn cluster get o k response has a 4xx status code
func (o *DcnClusterGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn cluster get o k response has a 5xx status code
func (o *DcnClusterGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn cluster get o k response a status code equal to that given
func (o *DcnClusterGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn cluster get o k response
func (o *DcnClusterGetOK) Code() int {
	return 200
}

func (o *DcnClusterGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster][%d] dcnClusterGetOK %s", 200, payload)
}

func (o *DcnClusterGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster][%d] dcnClusterGetOK %s", 200, payload)
}

func (o *DcnClusterGetOK) GetPayload() *models.DcnCluster {
	return o.Payload
}

func (o *DcnClusterGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnCluster)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnClusterGetDefault creates a DcnClusterGetDefault with default headers values
func NewDcnClusterGetDefault(code int) *DcnClusterGetDefault {
	return &DcnClusterGetDefault{
		_statusCode: code,
	}
}

/*
DcnClusterGetDefault describes a response with status code -1, with default header values.

Error
*/
type DcnClusterGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn cluster get default response has a 2xx status code
func (o *DcnClusterGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn cluster get default response has a 3xx status code
func (o *DcnClusterGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn cluster get default response has a 4xx status code
func (o *DcnClusterGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn cluster get default response has a 5xx status code
func (o *DcnClusterGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn cluster get default response a status code equal to that given
func (o *DcnClusterGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn cluster get default response
func (o *DcnClusterGetDefault) Code() int {
	return o._statusCode
}

func (o *DcnClusterGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster][%d] dcn_cluster_get default %s", o._statusCode, payload)
}

func (o *DcnClusterGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/cluster][%d] dcn_cluster_get default %s", o._statusCode, payload)
}

func (o *DcnClusterGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnClusterGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
