// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDcnClusterModifyParams creates a new DcnClusterModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDcnClusterModifyParams() *DcnClusterModifyParams {
	return &DcnClusterModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDcnClusterModifyParamsWithTimeout creates a new DcnClusterModifyParams object
// with the ability to set a timeout on a request.
func NewDcnClusterModifyParamsWithTimeout(timeout time.Duration) *DcnClusterModifyParams {
	return &DcnClusterModifyParams{
		timeout: timeout,
	}
}

// NewDcnClusterModifyParamsWithContext creates a new DcnClusterModifyParams object
// with the ability to set a context for a request.
func NewDcnClusterModifyParamsWithContext(ctx context.Context) *DcnClusterModifyParams {
	return &DcnClusterModifyParams{
		Context: ctx,
	}
}

// NewDcnClusterModifyParamsWithHTTPClient creates a new DcnClusterModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewDcnClusterModifyParamsWithHTTPClient(client *http.Client) *DcnClusterModifyParams {
	return &DcnClusterModifyParams{
		HTTPClient: client,
	}
}

/*
DcnClusterModifyParams contains all the parameters to send to the API endpoint

	for the dcn cluster modify operation.

	Typically these are written to a http.Request.
*/
type DcnClusterModifyParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.DcnCluster

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the dcn cluster modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DcnClusterModifyParams) WithDefaults() *DcnClusterModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the dcn cluster modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DcnClusterModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := DcnClusterModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the dcn cluster modify params
func (o *DcnClusterModifyParams) WithTimeout(timeout time.Duration) *DcnClusterModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the dcn cluster modify params
func (o *DcnClusterModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the dcn cluster modify params
func (o *DcnClusterModifyParams) WithContext(ctx context.Context) *DcnClusterModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the dcn cluster modify params
func (o *DcnClusterModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the dcn cluster modify params
func (o *DcnClusterModifyParams) WithHTTPClient(client *http.Client) *DcnClusterModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the dcn cluster modify params
func (o *DcnClusterModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the dcn cluster modify params
func (o *DcnClusterModifyParams) WithInfo(info *models.DcnCluster) *DcnClusterModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the dcn cluster modify params
func (o *DcnClusterModifyParams) SetInfo(info *models.DcnCluster) {
	o.Info = info
}

// WithReturnTimeout adds the returnTimeout to the dcn cluster modify params
func (o *DcnClusterModifyParams) WithReturnTimeout(returnTimeout *int64) *DcnClusterModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the dcn cluster modify params
func (o *DcnClusterModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *DcnClusterModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
