// Code generated by go-swagger; DO NOT EDIT.

package dcn

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnClusterModifyReader is a Reader for the DcnClusterModify structure.
type DcnClusterModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnClusterModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnClusterModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDcnClusterModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnClusterModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnClusterModifyOK creates a DcnClusterModifyOK with default headers values
func NewDcnClusterModifyOK() *DcnClusterModifyOK {
	return &DcnClusterModifyOK{}
}

/*
DcnClusterModifyOK describes a response with status code 200, with default header values.

OK
*/
type DcnClusterModifyOK struct {
	Payload *models.DcnClusterJobLinkResponse
}

// IsSuccess returns true when this dcn cluster modify o k response has a 2xx status code
func (o *DcnClusterModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn cluster modify o k response has a 3xx status code
func (o *DcnClusterModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn cluster modify o k response has a 4xx status code
func (o *DcnClusterModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn cluster modify o k response has a 5xx status code
func (o *DcnClusterModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn cluster modify o k response a status code equal to that given
func (o *DcnClusterModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn cluster modify o k response
func (o *DcnClusterModifyOK) Code() int {
	return 200
}

func (o *DcnClusterModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster][%d] dcnClusterModifyOK %s", 200, payload)
}

func (o *DcnClusterModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster][%d] dcnClusterModifyOK %s", 200, payload)
}

func (o *DcnClusterModifyOK) GetPayload() *models.DcnClusterJobLinkResponse {
	return o.Payload
}

func (o *DcnClusterModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnClusterJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnClusterModifyAccepted creates a DcnClusterModifyAccepted with default headers values
func NewDcnClusterModifyAccepted() *DcnClusterModifyAccepted {
	return &DcnClusterModifyAccepted{}
}

/*
DcnClusterModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type DcnClusterModifyAccepted struct {
	Payload *models.DcnClusterJobLinkResponse
}

// IsSuccess returns true when this dcn cluster modify accepted response has a 2xx status code
func (o *DcnClusterModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn cluster modify accepted response has a 3xx status code
func (o *DcnClusterModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn cluster modify accepted response has a 4xx status code
func (o *DcnClusterModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn cluster modify accepted response has a 5xx status code
func (o *DcnClusterModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn cluster modify accepted response a status code equal to that given
func (o *DcnClusterModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the dcn cluster modify accepted response
func (o *DcnClusterModifyAccepted) Code() int {
	return 202
}

func (o *DcnClusterModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster][%d] dcnClusterModifyAccepted %s", 202, payload)
}

func (o *DcnClusterModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster][%d] dcnClusterModifyAccepted %s", 202, payload)
}

func (o *DcnClusterModifyAccepted) GetPayload() *models.DcnClusterJobLinkResponse {
	return o.Payload
}

func (o *DcnClusterModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnClusterJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnClusterModifyDefault creates a DcnClusterModifyDefault with default headers values
func NewDcnClusterModifyDefault(code int) *DcnClusterModifyDefault {
	return &DcnClusterModifyDefault{
		_statusCode: code,
	}
}

/*
DcnClusterModifyDefault describes a response with status code -1, with default header values.

Error
*/
type DcnClusterModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn cluster modify default response has a 2xx status code
func (o *DcnClusterModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn cluster modify default response has a 3xx status code
func (o *DcnClusterModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn cluster modify default response has a 4xx status code
func (o *DcnClusterModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn cluster modify default response has a 5xx status code
func (o *DcnClusterModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn cluster modify default response a status code equal to that given
func (o *DcnClusterModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn cluster modify default response
func (o *DcnClusterModifyDefault) Code() int {
	return o._statusCode
}

func (o *DcnClusterModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster][%d] dcn_cluster_modify default %s", o._statusCode, payload)
}

func (o *DcnClusterModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/cluster][%d] dcn_cluster_modify default %s", o._statusCode, payload)
}

func (o *DcnClusterModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnClusterModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
